/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.model.api.misc.ExtractImageScansRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.CheckProgramInstall;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class ExtractImageScansController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractImageScansController.class);
    private static final String REPLACEFIRST = "[.][^.]+$";
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/extract-image-scans"})
    @MultiFileResponse
    @Operation(summary="Extract image scans from an input file", description="This endpoint extracts image scans from a given file based on certain parameters. Users can specify angle threshold, tolerance, minimum area, minimum contour area, and border size. Input:PDF Output:IMAGE/ZIP Type:SIMO")
    public ResponseEntity<byte[]> extractImageScans(@ModelAttribute ExtractImageScansRequest request) throws IOException, InterruptedException {
        ArrayList<byte[]> processedImageBytes;
        ArrayList<Path> tempDirs;
        Path tempZipFile;
        ArrayList<Path> tempImageFiles;
        String fileName;
        block39: {
            ResponseEntity i;
            MultipartFile inputFile = request.getFileInput();
            fileName = inputFile.getOriginalFilename();
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            ArrayList<String> images = new ArrayList<String>();
            tempImageFiles = new ArrayList<Path>();
            tempZipFile = null;
            tempDirs = new ArrayList<Path>();
            if (!CheckProgramInstall.isPythonAvailable()) {
                throw ExceptionUtils.createIOException((String)"error.toolNotInstalled", (String)"{0} is not installed", null, (Object[])new Object[]{"Python"});
            }
            String pythonVersion = CheckProgramInstall.getAvailablePythonCommand();
            Path splitPhotosScript = GeneralUtils.extractScript((String)"split_photos.py");
            try {
                int i2;
                if ("pdf".equalsIgnoreCase(extension)) {
                    try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
                        PDFRenderer pdfRenderer = new PDFRenderer(document);
                        pdfRenderer.setSubsamplingAllowed(true);
                        int pageCount = document.getNumberOfPages();
                        images = new ArrayList();
                        i2 = 0;
                        while (i2 < pageCount) {
                            Path tempFile = Files.createTempFile("image_", ".png", new FileAttribute[0]);
                            int renderDpi = 300;
                            ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
                            if (properties != null && properties.getSystem() != null) {
                                renderDpi = properties.getSystem().getMaxDPI();
                            }
                            int dpi = renderDpi;
                            int pageIndex = i2++;
                            BufferedImage image = (BufferedImage)ExceptionUtils.handleOomRendering((int)(pageIndex + 1), (int)dpi, () -> pdfRenderer.renderImageWithDPI(pageIndex, (float)dpi));
                            ImageIO.write((RenderedImage)image, "png", tempFile.toFile());
                            images.add(tempFile.toString());
                            tempImageFiles.add(tempFile);
                        }
                    }
                } else {
                    Path tempInputFile = Files.createTempFile("input_", "." + extension, new FileAttribute[0]);
                    inputFile.transferTo(tempInputFile);
                    images.add(tempInputFile.toString());
                }
                processedImageBytes = new ArrayList<byte[]>();
                for (int i3 = 0; i3 < images.size(); ++i3) {
                    List<Path> tempOutputFiles;
                    Path tempDir = Files.createTempDirectory("openCV_output", new FileAttribute[0]);
                    tempDirs.add(tempDir);
                    ArrayList<String> command = new ArrayList<String>(Arrays.asList(pythonVersion, splitPhotosScript.toAbsolutePath().toString(), (String)images.get(i3), tempDir.toString(), "--angle_threshold", String.valueOf(request.getAngleThreshold()), "--tolerance", String.valueOf(request.getTolerance()), "--min_area", String.valueOf(request.getMinArea()), "--min_contour_area", String.valueOf(request.getMinContourArea()), "--border_size", String.valueOf(request.getBorderSize())));
                    ProcessExecutor.ProcessExecutorResult returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.PYTHON_OPENCV).runCommandWithOutputHandling(command);
                    try (Stream<Path> listStream = Files.list(tempDir);){
                        tempOutputFiles = listStream.sorted().toList();
                    }
                    for (Path tempOutputFile : tempOutputFiles) {
                        byte[] imageBytes = Files.readAllBytes(tempOutputFile);
                        processedImageBytes.add(imageBytes);
                    }
                    FileUtils.deleteDirectory((File)tempDir.toFile());
                }
                if (processedImageBytes.size() <= 1) break block39;
                String outputZipFilename = GeneralUtils.generateFilename((String)fileName, (String)"_processed.zip");
                tempZipFile = Files.createTempFile("output_", ".zip", new FileAttribute[0]);
                try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(tempZipFile.toFile()));){
                    for (i2 = 0; i2 < processedImageBytes.size(); ++i2) {
                        ZipEntry entry = new ZipEntry(GeneralUtils.generateFilename((String)fileName, (String)("_processed_" + (i2 + 1) + ".png")));
                        zipOut.putNextEntry(entry);
                        zipOut.write((byte[])processedImageBytes.get(i2));
                        zipOut.closeEntry();
                    }
                }
                byte[] zipBytes = Files.readAllBytes(tempZipFile);
                Files.deleteIfExists(tempZipFile);
                i = WebResponseUtils.bytesToWebResponse((byte[])zipBytes, (String)outputZipFilename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            }
            catch (Throwable throwable) {
                tempImageFiles.forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        log.error("Failed to delete temporary image file: {}", path, (Object)e);
                    }
                });
                if (tempZipFile != null && Files.exists(tempZipFile, new LinkOption[0])) {
                    try {
                        Files.deleteIfExists(tempZipFile);
                    }
                    catch (IOException e) {
                        log.error("Failed to delete temporary zip file: {}", tempZipFile, (Object)e);
                    }
                }
                tempDirs.forEach(dir -> {
                    try {
                        FileUtils.deleteDirectory((File)dir.toFile());
                    }
                    catch (IOException e) {
                        log.error("Failed to delete temporary directory: {}", dir, (Object)e);
                    }
                });
                throw throwable;
            }
            tempImageFiles.forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    log.error("Failed to delete temporary image file: {}", path, (Object)e);
                }
            });
            if (tempZipFile != null && Files.exists(tempZipFile, new LinkOption[0])) {
                try {
                    Files.deleteIfExists(tempZipFile);
                }
                catch (IOException e) {
                    log.error("Failed to delete temporary zip file: {}", (Object)tempZipFile, (Object)e);
                }
            }
            tempDirs.forEach(dir -> {
                try {
                    FileUtils.deleteDirectory((File)dir.toFile());
                }
                catch (IOException e) {
                    log.error("Failed to delete temporary directory: {}", dir, (Object)e);
                }
            });
            return i;
        }
        if (processedImageBytes.isEmpty()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.noContent", (String)"No {0} detected", (Object[])new Object[]{"images"});
        }
        byte[] imageBytes = (byte[])processedImageBytes.get(0);
        ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])imageBytes, (String)GeneralUtils.generateFilename((String)fileName, (String)".png"), (MediaType)MediaType.IMAGE_PNG);
        tempImageFiles.forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                log.error("Failed to delete temporary image file: {}", path, (Object)e);
            }
        });
        if (tempZipFile != null && Files.exists(tempZipFile, new LinkOption[0])) {
            try {
                Files.deleteIfExists(tempZipFile);
            }
            catch (IOException e) {
                log.error("Failed to delete temporary zip file: {}", (Object)tempZipFile, (Object)e);
            }
        }
        tempDirs.forEach(dir -> {
            try {
                FileUtils.deleteDirectory((File)dir.toFile());
            }
            catch (IOException e) {
                log.error("Failed to delete temporary directory: {}", dir, (Object)e);
            }
        });
        return responseEntity;
    }

    @Generated
    public ExtractImageScansController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

