/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.misc.AutoRenameController;
import stirling.software.SPDF.model.api.misc.ExtractHeaderRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class AutoRenameController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoRenameController.class);
    private static final int LINE_LIMIT = 200;
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/auto-rename"})
    @Operation(summary="Extract header from PDF file", description="This endpoint accepts a PDF file and attempts to extract its title or header based on heuristics. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> extractHeader(@ModelAttribute ExtractHeaderRequest request) throws Exception {
        MultipartFile file = request.getFileInput();
        boolean useFirstTextAsFallback = Boolean.TRUE.equals(request.getUseFirstTextAsFallback());
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            1 reader = new /* Unavailable Anonymous Inner Class!! */;
            String header = reader.getText(document);
            if (header != null && header.length() < 255) {
                header = RegexPatternUtils.getInstance().getSafeFilenamePattern().matcher(header).replaceAll("").trim();
                ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)(header + ".pdf"));
                return responseEntity;
            }
            log.info("File has no good title to be found");
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
            return responseEntity;
        }
    }

    @Generated
    public AutoRenameController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

