/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.controller.api.converters.ConvertSvgToPDF;
import stirling.software.SPDF.model.api.converters.SvgToPdfRequest;
import stirling.software.SPDF.utils.SvgToPdf;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.SvgSanitizer;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertSvgToPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertSvgToPDF.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final SvgSanitizer svgSanitizer;
    private final TempFileManager tempFileManager;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/svg/pdf"})
    @MultiFileResponse
    @Operation(summary="Convert SVG to PDF", description="This endpoint converts one or more SVG (Scalable Vector Graphics) files to PDF format. Each SVG is converted to a separate PDF file. The conversion preserves vector graphics for crisp output at any resolution - no rasterization occurs. SVG dimensions (width/height) determine the PDF page size; defaults to A4 if not specified. SVG content is sanitized to prevent XSS attacks. Input: SVG file(s), Output: PDF file(s) or ZIP. Type: MIMO")
    public ResponseEntity<byte[]> convertSvgToPdf(@ModelAttribute SvgToPdfRequest request) {
        MultipartFile[] inputFiles = request.getFileInput();
        boolean combineIntoSinglePdf = Boolean.TRUE.equals(request.getCombineIntoSinglePdf());
        if (inputFiles == null || inputFiles.length == 0) {
            log.error("No files provided for SVG to PDF conversion.");
            return ResponseEntity.badRequest().body((Object)"No files provided".getBytes(StandardCharsets.UTF_8));
        }
        try {
            ArrayList<byte[]> sanitizedSvgs = new ArrayList<byte[]>();
            ArrayList<String> filenames = new ArrayList<String>();
            for (MultipartFile inputFile : inputFiles) {
                if (inputFile == null || inputFile.isEmpty()) {
                    log.warn("Skipping empty file in batch conversion");
                    continue;
                }
                String originalFilename = inputFile.getOriginalFilename();
                if (originalFilename == null || originalFilename.trim().isEmpty()) {
                    log.warn("Skipping file with null or empty filename");
                    continue;
                }
                String lowerFilename = originalFilename.toLowerCase(Locale.ROOT);
                if (!lowerFilename.endsWith(".svg")) {
                    log.warn("Skipping non-SVG file: {}", (Object)originalFilename);
                    continue;
                }
                try {
                    byte[] fileBytes = inputFile.getBytes();
                    byte[] sanitizedBytes = this.svgSanitizer.sanitize(fileBytes);
                    sanitizedSvgs.add(sanitizedBytes);
                    filenames.add(Filenames.toSimpleFileName((String)originalFilename));
                }
                catch (IOException e) {
                    log.error("SVG sanitization/reading failed for {}: {}", (Object)originalFilename, (Object)e.getMessage());
                }
            }
            if (sanitizedSvgs.isEmpty()) {
                log.error("No valid SVG files were found");
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"No valid SVG files were found".getBytes(StandardCharsets.UTF_8));
            }
            if (combineIntoSinglePdf) {
                return this.handleCombinedConversion(sanitizedSvgs, filenames);
            }
            return this.handleSeparateConversion(sanitizedSvgs, filenames);
        }
        catch (Exception e) {
            log.error("Unexpected error during SVG to PDF conversion", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An unexpected error occurred during conversion".getBytes(StandardCharsets.UTF_8));
        }
    }

    private ResponseEntity<byte[]> handleCombinedConversion(List<byte[]> sanitizedSvgs, List<String> filenames) {
        try {
            log.info("Combining {} SVG files into single PDF", (Object)sanitizedSvgs.size());
            byte[] pdfBytes = SvgToPdf.combineIntoPdf(sanitizedSvgs);
            if (pdfBytes == null || pdfBytes.length == 0) {
                log.error("PDF conversion failed - empty output");
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"PDF conversion failed - empty output".getBytes(StandardCharsets.UTF_8));
            }
            pdfBytes = this.pdfDocumentFactory.createNewBytesBasedOnOldDocument(pdfBytes);
            String outputFilename = filenames.isEmpty() ? "combined_svgs.pdf" : GeneralUtils.generateFilename((String)filenames.get(0), (String)"_combined.pdf");
            log.info("Successfully combined {} SVGs into single PDF", (Object)sanitizedSvgs.size());
            return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
        }
        catch (IOException e) {
            log.error("Error combining SVGs into PDF", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Conversion failed: " + e.getMessage()).getBytes(StandardCharsets.UTF_8));
        }
    }

    private ResponseEntity<byte[]> handleSeparateConversion(List<byte[]> sanitizedSvgs, List<String> filenames) {
        ArrayList<ConvertedPdf> convertedPdfs = new ArrayList<ConvertedPdf>();
        for (int i = 0; i < sanitizedSvgs.size(); ++i) {
            byte[] sanitizedBytes = sanitizedSvgs.get(i);
            String baseFilename = filenames.get(i);
            try {
                byte[] pdfBytes = SvgToPdf.convert((byte[])sanitizedBytes);
                if (pdfBytes == null || pdfBytes.length == 0) {
                    log.error("PDF conversion failed - empty output for {}", (Object)baseFilename);
                    continue;
                }
                pdfBytes = this.pdfDocumentFactory.createNewBytesBasedOnOldDocument(pdfBytes);
                String outputFilename = GeneralUtils.generateFilename((String)baseFilename, (String)".pdf");
                convertedPdfs.add(new ConvertedPdf(outputFilename, pdfBytes));
                log.info("Successfully converted SVG to PDF: {}", (Object)baseFilename);
                continue;
            }
            catch (IOException e) {
                log.error("File processing error for SVG to PDF: {}", (Object)baseFilename, (Object)e);
            }
        }
        if (convertedPdfs.isEmpty()) {
            log.error("No files were successfully converted");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"No files were successfully converted".getBytes(StandardCharsets.UTF_8));
        }
        try {
            if (convertedPdfs.size() == 1) {
                ConvertedPdf pdf = (ConvertedPdf)convertedPdfs.get(0);
                return WebResponseUtils.bytesToWebResponse((byte[])pdf.content, (String)pdf.filename, (MediaType)MediaType.APPLICATION_PDF);
            }
            String zipFilename = filenames.isEmpty() ? "converted_svgs.zip" : GeneralUtils.generateFilename((String)filenames.get(0), (String)"_converted_svgs.zip");
            byte[] zipBytes = this.createZipFromPdfs(convertedPdfs);
            return WebResponseUtils.bytesToWebResponse((byte[])zipBytes, (String)zipFilename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
        }
        catch (IOException e) {
            log.error("Failed to create response", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to create response".getBytes(StandardCharsets.UTF_8));
        }
    }

    private byte[] createZipFromPdfs(List<ConvertedPdf> pdfs) throws IOException {
        try (TempFile tempZipFile = new TempFile(this.tempFileManager, ".zip");){
            Object object;
            try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(tempZipFile.getPath(), new OpenOption[0]));){
                for (ConvertedPdf pdf : pdfs) {
                    ZipEntry pdfEntry = new ZipEntry(pdf.filename);
                    zipOut.putNextEntry(pdfEntry);
                    zipOut.write(pdf.content);
                    zipOut.closeEntry();
                    log.debug("Added {} to ZIP", (Object)pdf.filename);
                }
                object = Files.readAllBytes(tempZipFile.getPath());
            }
            return object;
        }
    }

    @Generated
    public ConvertSvgToPDF(CustomPDFDocumentFactory pdfDocumentFactory, SvgSanitizer svgSanitizer, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.svgSanitizer = svgSanitizer;
        this.tempFileManager = tempFileManager;
    }
}

