/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.model.api.converters.ConvertEbookToPdfRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertEbookToPDFController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertEbookToPDFController.class);
    private static final Set<String> SUPPORTED_EXTENSIONS = Set.of("epub", "mobi", "azw3", "fb2", "txt", "docx");
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;

    private boolean isCalibreEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Calibre");
    }

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    /*
     * Loose catch block
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/ebook/pdf"})
    @Operation(summary="Convert an eBook file to PDF", description="This endpoint converts common eBook formats (EPUB, MOBI, AZW3, FB2, TXT, DOCX) to PDF using Calibre. Input:BOOK Output:PDF Type:SISO")
    public ResponseEntity<byte[]> convertEbookToPdf(@ModelAttribute ConvertEbookToPdfRequest request) throws Exception {
        String extension;
        if (!this.isCalibreEnabled()) {
            throw new IllegalStateException("Calibre support is disabled");
        }
        MultipartFile inputFile = request.getFileInput();
        if (inputFile == null || inputFile.isEmpty()) {
            throw new IllegalArgumentException("No input file provided");
        }
        boolean optimizeForEbook = Boolean.TRUE.equals(request.getOptimizeForEbook());
        if (optimizeForEbook && !this.isGhostscriptEnabled()) {
            log.warn("Ghostscript optimization requested but Ghostscript is not enabled/available for ebook conversion");
            optimizeForEbook = false;
        }
        boolean embedAllFonts = Boolean.TRUE.equals(request.getEmbedAllFonts());
        boolean includeTableOfContents = Boolean.TRUE.equals(request.getIncludeTableOfContents());
        boolean includePageNumbers = Boolean.TRUE.equals(request.getIncludePageNumbers());
        String originalFilename = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFilename == null || originalFilename.isBlank()) {
            originalFilename = "document";
        }
        if ((extension = FilenameUtils.getExtension((String)originalFilename)) == null || extension.isBlank()) {
            throw new IllegalArgumentException("Unable to determine file type");
        }
        String lowerExtension = extension.toLowerCase(Locale.ROOT);
        if (!SUPPORTED_EXTENSIONS.contains(lowerExtension)) {
            throw new IllegalArgumentException("Unsupported eBook file extension: " + extension);
        }
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        if (baseName == null || baseName.isBlank()) {
            baseName = "document";
        }
        Path workingDirectory = this.tempFileManager.createTempDirectory();
        Path inputPath = workingDirectory.resolve(baseName + "." + lowerExtension);
        Path outputPath = workingDirectory.resolve(baseName + ".pdf");
        try (InputStream inputStream = inputFile.getInputStream();){
            Files.copy(inputStream, inputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        List command = this.buildCalibreCommand(inputPath, outputPath, embedAllFonts, includeTableOfContents, includePageNumbers);
        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.CALIBRE).runCommandWithOutputHandling(command, workingDirectory.toFile());
        if (result == null) {
            throw new IllegalStateException("Calibre conversion returned no result");
        }
        if (result.getRc() != 0) {
            String errorMessage = result.getMessages();
            if (errorMessage == null || errorMessage.isBlank()) {
                errorMessage = "Calibre conversion failed";
            }
            throw new IllegalStateException(errorMessage);
        }
        if (!Files.exists(outputPath, new LinkOption[0]) || Files.size(outputPath) == 0L) {
            throw new IllegalStateException("Calibre did not produce a PDF output");
        }
        String outputFilename = GeneralUtils.generateFilename((String)originalFilename, (String)"_convertedToPDF.pdf");
        try {
            ResponseEntity responseEntity;
            block32: {
                if (optimizeForEbook) {
                    byte[] pdfBytes = Files.readAllBytes(outputPath);
                    try {
                        byte[] optimizedPdf = GeneralUtils.optimizePdfWithGhostscript((byte[])pdfBytes);
                        ResponseEntity responseEntity2 = WebResponseUtils.bytesToWebResponse((byte[])optimizedPdf, (String)outputFilename);
                        return responseEntity2;
                    }
                    catch (IOException e) {
                        log.warn("Ghostscript optimization failed for ebook conversion, returning original PDF", (Throwable)e);
                        ResponseEntity responseEntity3 = WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)outputFilename);
                        this.cleanupTempFiles(workingDirectory, inputPath, outputPath);
                        return responseEntity3;
                    }
                }
                PDDocument document = this.pdfDocumentFactory.load(outputPath.toFile());
                try {
                    responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)outputFilename);
                    if (document == null) break block32;
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                    {
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
                document.close();
            }
            return responseEntity;
        }
        finally {
            this.cleanupTempFiles(workingDirectory, inputPath, outputPath);
        }
    }

    private List<String> buildCalibreCommand(Path inputPath, Path outputPath, boolean embedAllFonts, boolean includeTableOfContents, boolean includePageNumbers) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("ebook-convert");
        command.add(inputPath.toString());
        command.add(outputPath.toString());
        if (embedAllFonts) {
            command.add("--embed-all-fonts");
        }
        if (includeTableOfContents) {
            command.add("--pdf-add-toc");
        }
        if (includePageNumbers) {
            command.add("--pdf-page-numbers");
        }
        return command;
    }

    private void cleanupTempFiles(Path workingDirectory, Path inputPath, Path outputPath) {
        ArrayList<Path> pathsToDelete = new ArrayList<Path>();
        pathsToDelete.add(inputPath);
        pathsToDelete.add(outputPath);
        for (Path path : pathsToDelete) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                log.warn("Failed to delete temporary file: {}", (Object)path, (Object)e);
            }
        }
        this.tempFileManager.deleteTempDirectory(workingDirectory);
    }

    @Generated
    public ConvertEbookToPDFController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
    }
}

