/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SettingsApi;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.GeneralUtils;

@SettingsApi
@Hidden
public class SettingsController {
    private final ApplicationProperties applicationProperties;
    private final EndpointConfiguration endpointConfiguration;

    @AutoJobPostMapping(value={"/update-enable-analytics"})
    @Hidden
    public ResponseEntity<Map<String, Object>> updateApiKey(@RequestParam Boolean enabled) throws IOException {
        if (this.applicationProperties.getSystem().getEnableAnalytics() != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ALREADY_REPORTED).body(Map.of("message", "Setting has already been set, To adjust please edit " + InstallationPathConfig.getSettingsPath()));
        }
        GeneralUtils.saveKeyToSettings((String)"system.enableAnalytics", (Object)enabled);
        this.applicationProperties.getSystem().setEnableAnalytics(enabled);
        return ResponseEntity.ok(Map.of("message", "Updated"));
    }

    @GetMapping(value={"/get-endpoints-status"})
    @Hidden
    public ResponseEntity<Map<String, Boolean>> getDisabledEndpoints() {
        return ResponseEntity.ok((Object)this.endpointConfiguration.getEndpointStatuses());
    }

    @Generated
    public SettingsController(ApplicationProperties applicationProperties, EndpointConfiguration endpointConfiguration) {
        this.applicationProperties = applicationProperties;
        this.endpointConfiguration = endpointConfiguration;
    }
}

