/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.EditTableOfContentsController;
import stirling.software.SPDF.model.api.EditTableOfContentsRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class EditTableOfContentsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EditTableOfContentsController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final ObjectMapper objectMapper;

    @AutoJobPostMapping(value={"/extract-bookmarks"}, consumes={"multipart/form-data"})
    @Operation(summary="Extract PDF Bookmarks", description="Extracts bookmarks/table of contents from a PDF document as JSON.")
    @ResponseBody
    public List<Map<String, Object>> extractBookmarks(@RequestParam(value="file") MultipartFile file) throws Exception {
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
            if (outline == null) {
                log.info("No outline/bookmarks found in PDF");
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                return arrayList;
            }
            List list = this.extractBookmarkItems(document, outline);
            return list;
        }
    }

    private List<Map<String, Object>> extractBookmarkItems(PDDocument document, PDDocumentOutline outline) throws Exception {
        ArrayList<Map<String, Object>> bookmarks = new ArrayList<Map<String, Object>>();
        for (PDOutlineItem current = outline.getFirstChild(); current != null; current = current.getNextSibling()) {
            PDOutlineItem child;
            HashMap<String, Object> bookmark = new HashMap<String, Object>();
            String title = current.getTitle();
            bookmark.put("title", title);
            PDPage page = current.findDestinationPage(document);
            if (page != null) {
                int pageIndex = document.getPages().indexOf(page);
                bookmark.put("pageNumber", pageIndex + 1);
            } else {
                bookmark.put("pageNumber", 1);
            }
            if (child != null) {
                ArrayList<Map> children = new ArrayList<Map>();
                for (child = current.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Map childBookmark = this.processChild(document, child);
                    children.add(childBookmark);
                }
                bookmark.put("children", children);
            } else {
                bookmark.put("children", new ArrayList());
            }
            bookmarks.add(bookmark);
        }
        return bookmarks;
    }

    private Map<String, Object> processChild(PDDocument document, PDOutlineItem item) throws Exception {
        PDOutlineItem child;
        HashMap<String, Object> bookmark = new HashMap<String, Object>();
        String title = item.getTitle();
        bookmark.put("title", title);
        PDPage page = item.findDestinationPage(document);
        if (page != null) {
            int pageIndex = document.getPages().indexOf(page);
            bookmark.put("pageNumber", pageIndex + 1);
        } else {
            bookmark.put("pageNumber", 1);
        }
        if (child != null) {
            ArrayList<Map> children = new ArrayList<Map>();
            for (child = item.getFirstChild(); child != null; child = child.getNextSibling()) {
                Map childBookmark = this.processChild(document, child);
                children.add(childBookmark);
            }
            bookmark.put("children", children);
        } else {
            bookmark.put("children", new ArrayList());
        }
        return bookmark;
    }

    @AutoJobPostMapping(value={"/edit-table-of-contents"}, consumes={"multipart/form-data"})
    @Operation(summary="Edit Table of Contents", description="Add or edit bookmarks/table of contents in a PDF document.")
    public ResponseEntity<byte[]> editTableOfContents(@ModelAttribute EditTableOfContentsRequest request) throws Exception {
        MultipartFile file = request.getFileInput();
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            ResponseEntity responseEntity;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                List bookmarks = (List)this.objectMapper.readValue(request.getBookmarkData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                PDDocumentOutline outline = new PDDocumentOutline();
                document.getDocumentCatalog().setDocumentOutline(outline);
                this.addBookmarksToOutline(document, outline, bookmarks);
                document.save((OutputStream)baos);
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])baos.toByteArray(), (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_with_toc.pdf"), (MediaType)MediaType.APPLICATION_PDF);
            }
            return responseEntity;
        }
    }

    private void addBookmarksToOutline(PDDocument document, PDDocumentOutline outline, List<BookmarkItem> bookmarks) {
        for (BookmarkItem bookmark : bookmarks) {
            PDOutlineItem item = this.createOutlineItem(document, bookmark);
            outline.addLast(item);
            if (bookmark.getChildren() == null || bookmark.getChildren().isEmpty()) continue;
            this.addChildBookmarks(document, item, bookmark.getChildren());
        }
    }

    private void addChildBookmarks(PDDocument document, PDOutlineItem parent, List<BookmarkItem> children) {
        for (BookmarkItem child : children) {
            PDOutlineItem item = this.createOutlineItem(document, child);
            parent.addLast(item);
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.addChildBookmarks(document, item, child.getChildren());
        }
    }

    private PDOutlineItem createOutlineItem(PDDocument document, BookmarkItem bookmark) {
        PDOutlineItem item = new PDOutlineItem();
        item.setTitle(bookmark.getTitle());
        int pageIndex = bookmark.getPageNumber() - 1;
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex >= document.getNumberOfPages()) {
            pageIndex = document.getNumberOfPages() - 1;
        }
        PDPage page = document.getPage(pageIndex);
        item.setDestination(page);
        return item;
    }

    @Generated
    public EditTableOfContentsController(CustomPDFDocumentFactory pdfDocumentFactory, ObjectMapper objectMapper) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.objectMapper = objectMapper;
    }
}

