/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.BookletImpositionController;
import stirling.software.SPDF.model.api.general.BookletImpositionRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class BookletImpositionController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(value={"/booklet-imposition"}, consumes={"multipart/form-data"})
    @Operation(summary="Create a booklet with proper page imposition", description="This operation combines page reordering for booklet printing with multi-page layout. It rearranges pages in the correct order for booklet printing and places multiple pages on each sheet for proper folding and binding. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> createBookletImposition(@ModelAttribute BookletImpositionRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        int pagesPerSheet = request.getPagesPerSheet();
        boolean addBorder = Boolean.TRUE.equals(request.getAddBorder());
        String spineLocation = request.getSpineLocation() != null ? request.getSpineLocation() : "LEFT";
        boolean addGutter = Boolean.TRUE.equals(request.getAddGutter());
        float gutterSize = request.getGutterSize();
        boolean doubleSided = Boolean.TRUE.equals(request.getDoubleSided());
        String duplexPass = request.getDuplexPass() != null ? request.getDuplexPass() : "BOTH";
        boolean flipOnShortEdge = Boolean.TRUE.equals(request.getFlipOnShortEdge());
        if (pagesPerSheet != 2) {
            throw new IllegalArgumentException("Booklet printing uses 2 pages per side (landscape). For 4-up, use the N-up feature.");
        }
        try (PDDocument sourceDocument = this.pdfDocumentFactory.load(file);){
            ResponseEntity responseEntity;
            block13: {
                int totalPages = sourceDocument.getNumberOfPages();
                PDDocument newDocument = this.createSaddleBooklet(sourceDocument, totalPages, addBorder, spineLocation, addGutter, gutterSize, doubleSided, duplexPass, flipOnShortEdge);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newDocument.save((OutputStream)baos);
                    byte[] result = baos.toByteArray();
                    responseEntity = WebResponseUtils.bytesToWebResponse((byte[])result, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)file.getOriginalFilename()), (String)"_booklet.pdf"));
                    if (newDocument == null) break block13;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    private static int padToMultipleOf4(int n) {
        return (n + 3) / 4 * 4;
    }

    private static List<Side> saddleStitchSides(int totalPagesOriginal, boolean doubleSided, String duplexPass, boolean flipOnShortEdge) {
        int N = BookletImpositionController.padToMultipleOf4((int)totalPagesOriginal);
        ArrayList<Side> out = new ArrayList<Side>();
        int sheets = N / 4;
        for (int s = 0; s < sheets; ++s) {
            boolean includeBack;
            int a = N - 1 - s * 2;
            int b = s * 2;
            int c = s * 2 + 1;
            int d = N - 2 - s * 2;
            a = a < totalPagesOriginal ? a : -1;
            b = b < totalPagesOriginal ? b : -1;
            c = c < totalPagesOriginal ? c : -1;
            d = d < totalPagesOriginal ? d : -1;
            boolean includeFront = "BOTH".equals(duplexPass) || "FIRST".equals(duplexPass);
            boolean bl = includeBack = "BOTH".equals(duplexPass) || "SECOND".equals(duplexPass);
            if (includeFront) {
                out.add(new Side(a, b, false));
            }
            if (!includeBack) continue;
            if (doubleSided && flipOnShortEdge) {
                out.add(new Side(d, c, true));
                continue;
            }
            out.add(new Side(c, d, true));
        }
        return out;
    }

    private PDDocument createSaddleBooklet(PDDocument src, int totalPages, boolean addBorder, String spineLocation, boolean addGutter, float gutterSize, boolean doubleSided, String duplexPass, boolean flipOnShortEdge) throws IOException {
        PDDocument dst = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(src);
        PDRectangle srcBox = src.getPage(0).getCropBox();
        PDRectangle portraitPaper = new PDRectangle(srcBox.getWidth(), srcBox.getHeight());
        PDRectangle pageSize = new PDRectangle(portraitPaper.getHeight(), portraitPaper.getWidth());
        if (gutterSize < 0.0f) {
            gutterSize = 0.0f;
        }
        if (gutterSize >= pageSize.getWidth() / 2.0f) {
            gutterSize = pageSize.getWidth() / 2.0f - 1.0f;
        }
        List sides = BookletImpositionController.saddleStitchSides((int)totalPages, (boolean)doubleSided, (String)duplexPass, (boolean)flipOnShortEdge);
        for (Side side : sides) {
            PDPage out = new PDPage(pageSize);
            dst.addPage(out);
            float cellW = pageSize.getWidth() / 2.0f;
            float cellH = pageSize.getHeight();
            boolean rtl = "RIGHT".equalsIgnoreCase(spineLocation);
            boolean leftCol = rtl;
            boolean rightCol = !rtl;
            float g = addGutter ? gutterSize : 0.0f;
            float leftCellX = (float)leftCol * cellW + g / 2.0f;
            float rightCellX = (float)rightCol * cellW - g / 2.0f;
            float leftCellW = cellW - g / 2.0f;
            float rightCellW = cellW - g / 2.0f;
            LayerUtility layerUtility = new LayerUtility(dst);
            try (PDPageContentStream cs = new PDPageContentStream(dst, out, PDPageContentStream.AppendMode.APPEND, true, true);){
                if (addBorder) {
                    cs.setLineWidth(1.5f);
                    cs.setStrokingColor(Color.BLACK);
                }
                this.drawCell(src, dst, cs, layerUtility, side.left, leftCellX, 0.0f, leftCellW, cellH, addBorder);
                this.drawCell(src, dst, cs, layerUtility, side.right, rightCellX, 0.0f, rightCellW, cellH, addBorder);
            }
        }
        return dst;
    }

    private void drawCell(PDDocument src, PDDocument dst, PDPageContentStream cs, LayerUtility layerUtility, int pageIndex, float cellX, float cellY, float cellW, float cellH, boolean addBorder) throws IOException {
        if (pageIndex < 0) {
            if (addBorder) {
                cs.addRect(cellX, cellY, cellW, cellH);
                cs.stroke();
            }
            return;
        }
        PDPage srcPage = src.getPage(pageIndex);
        PDRectangle r = srcPage.getCropBox();
        int rot = (srcPage.getRotation() + 360) % 360;
        float sx = cellW / r.getWidth();
        float sy = cellH / r.getHeight();
        float s = Math.min(sx, sy);
        if (rot == 90 || rot == 270) {
            sx = cellW / r.getHeight();
            sy = cellH / r.getWidth();
            s = Math.min(sx, sy);
        }
        float drawnW = rot == 90 || rot == 270 ? r.getHeight() * s : r.getWidth() * s;
        float drawnH = rot == 90 || rot == 270 ? r.getWidth() * s : r.getHeight() * s;
        float tx = cellX + (cellW - drawnW) / 2.0f - r.getLowerLeftX() * s;
        float ty = cellY + (cellH - drawnH) / 2.0f - r.getLowerLeftY() * s;
        cs.saveGraphicsState();
        cs.transform(Matrix.getTranslateInstance((float)tx, (float)ty));
        cs.transform(Matrix.getScaleInstance((float)s, (float)s));
        switch (rot) {
            case 90: {
                cs.transform(Matrix.getRotateInstance((double)1.5707963267948966, (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)0.0f, (float)(-r.getWidth())));
                break;
            }
            case 180: {
                cs.transform(Matrix.getRotateInstance((double)Math.PI, (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-r.getWidth()), (float)(-r.getHeight())));
                break;
            }
            case 270: {
                cs.transform(Matrix.getRotateInstance((double)4.71238898038469, (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-r.getHeight()), (float)0.0f));
                break;
            }
        }
        PDFormXObject form = layerUtility.importPageAsForm(src, pageIndex);
        cs.drawForm(form);
        cs.restoreGraphicsState();
        if (addBorder) {
            cs.addRect(cellX, cellY, cellW, cellH);
            cs.stroke();
        }
    }

    @Generated
    public BookletImpositionController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

