/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import java.util.Locale;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import stirling.software.SPDF.config.CleanUrlInterceptor;
import stirling.software.common.model.ApplicationProperties;

@Configuration
public class LocaleConfiguration
implements WebMvcConfigurer {
    private final ApplicationProperties applicationProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
        registry.addInterceptor((HandlerInterceptor)new CleanUrlInterceptor());
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver slr = new SessionLocaleResolver();
        String appLocaleEnv = this.applicationProperties.getSystem().getDefaultLocale();
        Locale defaultLocale = Locale.UK;
        if (appLocaleEnv != null && !appLocaleEnv.isEmpty()) {
            Locale tempLocale = Locale.forLanguageTag(appLocaleEnv);
            String tempLanguageTag = tempLocale.toLanguageTag();
            if (appLocaleEnv.equalsIgnoreCase(tempLanguageTag)) {
                defaultLocale = tempLocale;
            } else {
                tempLocale = Locale.forLanguageTag(appLocaleEnv.replace("_", "-"));
                tempLanguageTag = tempLocale.toLanguageTag();
                if (appLocaleEnv.equalsIgnoreCase(tempLanguageTag)) {
                    defaultLocale = tempLocale;
                } else {
                    System.err.println("Invalid SYSTEM_DEFAULTLOCALE environment variable value. Falling back to default en-GB.");
                }
            }
        }
        slr.setDefaultLocale(defaultLocale);
        return slr;
    }

    @Generated
    public LocaleConfiguration(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

