/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.utils.text;

import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.encoding.DictionaryEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stirling.software.common.util.RegexPatternUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextEncodingHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextEncodingHelper.class);

    public static boolean canEncodeCharacters(PDFont font, String text) {
        if (font == null || text == null || text.isEmpty()) {
            return false;
        }
        try {
            byte[] encoded = font.encode(text);
            if (encoded.length > 0) {
                log.debug("Text '{}' has good full-string encoding for font {} - permissively allowing", (Object)text, (Object)(font.getName() != null ? font.getName() : "Unknown"));
                return true;
            }
            log.debug("Full encoding failed for '{}' - using array-based fallback for font {}", (Object)text, (Object)(font.getName() != null ? font.getName() : "Unknown"));
            return TextEncodingHelper.validateAsCodePointArray((PDFont)font, (String)text);
        }
        catch (IOException | IllegalArgumentException e) {
            log.debug("Encoding exception for text '{}' with font {} - trying array fallback: {}", new Object[]{text, font.getName() != null ? font.getName() : "Unknown", e.getMessage()});
            if (TextEncodingHelper.isFontSubset((String)font.getName()) || TextEncodingHelper.hasCustomEncoding((PDFont)font)) {
                return TextEncodingHelper.validateAsCodePointArray((PDFont)font, (String)text);
            }
            return false;
        }
    }

    private static boolean validateAsCodePointArray(PDFont font, String text) {
        int codePoint;
        int totalCodePoints = 0;
        int successfulCodePoints = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            String charStr = new String(Character.toChars(codePoint));
            ++totalCodePoints;
            try {
                byte[] charEncoded = font.encode(charStr);
                if (charEncoded.length > 0) {
                    float charWidth = font.getStringWidth(charStr);
                    if (charWidth >= 0.0f) {
                        ++successfulCodePoints;
                        log.debug("Code point '{}' (U+{}) encoded successfully", (Object)charStr, (Object)Integer.toHexString(codePoint).toUpperCase());
                        continue;
                    }
                    log.debug("Code point '{}' (U+{}) has invalid width: {}", new Object[]{charStr, Integer.toHexString(codePoint).toUpperCase(), Float.valueOf(charWidth)});
                    continue;
                }
                log.debug("Code point '{}' (U+{}) encoding failed - empty result", (Object)charStr, (Object)Integer.toHexString(codePoint).toUpperCase());
                continue;
            }
            catch (IOException | IllegalArgumentException e) {
                log.debug("Code point '{}' (U+{}) validation failed: {}", new Object[]{charStr, Integer.toHexString(codePoint).toUpperCase(), e.getMessage()});
            }
        }
        double successRate = totalCodePoints > 0 ? (double)successfulCodePoints / (double)totalCodePoints : 0.0;
        boolean isAcceptable = successRate >= 0.95;
        log.debug("Array validation for '{}': {}/{} code points successful ({:.1f}%) - {}", new Object[]{text, successfulCodePoints, totalCodePoints, successRate * 100.0, isAcceptable ? "ALLOWING" : "rejecting"});
        return isAcceptable;
    }

    public static boolean isTextSegmentRemovable(PDFont font, String text) {
        if (font == null || text == null || text.isEmpty()) {
            return false;
        }
        log.debug("Evaluating text segment for removal: '{}' with font {}", (Object)text, (Object)(font.getName() != null ? font.getName() : "Unknown Font"));
        if (TextEncodingHelper.isSimpleCharacter((String)text)) {
            try {
                font.encode(text);
                font.getStringWidth(text);
                log.debug("Text '{}' is a simple character and passed validation - allowing removal", (Object)text);
                return true;
            }
            catch (Exception e) {
                log.debug("Simple character '{}' failed basic validation with font {}: {}", new Object[]{text, font.getName() != null ? font.getName() : "Unknown", e.getMessage()});
                return false;
            }
        }
        return TextEncodingHelper.isTextFullyRemovable((PDFont)font, (String)text);
    }

    public static boolean isTextFullyRemovable(PDFont font, String text) {
        if (font == null || text == null || text.isEmpty()) {
            return false;
        }
        try {
            if (!TextEncodingHelper.canEncodeCharacters((PDFont)font, (String)text)) {
                log.debug("Text '{}' failed encoding validation for font {}", (Object)text, (Object)(font.getName() != null ? font.getName() : "Unknown"));
                return false;
            }
            float width = font.getStringWidth(text);
            if (width < 0.0f) {
                log.debug("Text '{}' has invalid width {} for font {}", new Object[]{text, Float.valueOf(width), font.getName() != null ? font.getName() : "Unknown"});
                return false;
            }
            if (font.getFontDescriptor() == null) {
                log.debug("Missing font descriptor for font {}", (Object)(font.getName() != null ? font.getName() : "Unknown"));
                return false;
            }
            try {
                font.getFontDescriptor().getFontBoundingBox();
            }
            catch (IllegalArgumentException e) {
                log.debug("Font bounding box unavailable for font {}: {}", (Object)(font.getName() != null ? font.getName() : "Unknown"), (Object)e.getMessage());
                return false;
            }
            log.debug("Text '{}' passed comprehensive validation for font {}", (Object)text, (Object)(font.getName() != null ? font.getName() : "Unknown"));
            return true;
        }
        catch (IOException e) {
            log.debug("Text '{}' failed validation for font {} due to IO error: {}", new Object[]{text, font.getName() != null ? font.getName() : "Unknown", e.getMessage()});
            return false;
        }
        catch (IllegalArgumentException e) {
            log.debug("Text '{}' failed validation for font {} due to argument error: {}", new Object[]{text, font.getName() != null ? font.getName() : "Unknown", e.getMessage()});
            return false;
        }
    }

    private static boolean isSimpleCharacter(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (text.length() > 20) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c >= ' ' && c <= '~' && ".,!?;:()-[]{}\"'/@#$%&*+=<>|\\~`".indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCustomEncoding(PDFont font) {
        try {
            if (font instanceof PDSimpleFont) {
                PDSimpleFont simpleFont = (PDSimpleFont)font;
                try {
                    Encoding encoding = simpleFont.getEncoding();
                    if (encoding != null) {
                        if (encoding instanceof DictionaryEncoding) {
                            log.debug("Font {} uses DictionaryEncoding (custom)", (Object)font.getName());
                            return true;
                        }
                        String encodingName = encoding.getClass().getSimpleName();
                        if (encodingName.contains("Custom") || encodingName.contains("Dictionary")) {
                            log.debug("Font {} uses custom encoding: {}", (Object)font.getName(), (Object)encodingName);
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("Encoding detection failed for font {}: {}", (Object)font.getName(), (Object)e.getMessage());
                    return true;
                }
            }
            if (font instanceof PDType0Font) {
                log.debug("Font {} is Type0 (CID) - generally uses standard CMaps", (Object)(font.getName() != null ? font.getName() : "Unknown"));
                return false;
            }
            log.debug("Font {} type {} - assuming standard encoding", (Object)(font.getName() != null ? font.getName() : "Unknown"), (Object)font.getClass().getSimpleName());
            return false;
        }
        catch (IllegalArgumentException e) {
            log.debug("Custom encoding detection failed for font {}: {}", (Object)(font.getName() != null ? font.getName() : "Unknown"), (Object)e.getMessage());
            return false;
        }
    }

    public static boolean fontSupportsCharacter(PDFont font, String character) {
        if (font == null || character == null || character.isEmpty()) {
            return false;
        }
        try {
            byte[] encoded = font.encode(character);
            if (encoded.length == 0) {
                return false;
            }
            float width = font.getStringWidth(character);
            return width > 0.0f;
        }
        catch (IOException | IllegalArgumentException e) {
            log.debug("Character '{}' not supported by font {}: {}", new Object[]{character, font.getName() != null ? font.getName() : "Unknown", e.getMessage()});
            return false;
        }
    }

    public static boolean isFontSubset(String fontName) {
        if (fontName == null) {
            return false;
        }
        return RegexPatternUtils.getInstance().getFontNamePattern().matcher(fontName).matches();
    }

    public static boolean canCalculateBasicWidths(PDFont font) {
        try {
            String[] testChars;
            float spaceWidth = font.getStringWidth(" ");
            if (spaceWidth <= 0.0f) {
                return false;
            }
            for (String ch : testChars = new String[]{"a", "A", "0", ".", "e", "!"}) {
                try {
                    float width = font.getStringWidth(ch);
                    if (!(width > 0.0f)) continue;
                    return true;
                }
                catch (IOException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (IOException | IllegalArgumentException e) {
            return false;
        }
    }
}

