/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import stirling.software.SPDF.model.SignatureFile;
import stirling.software.SPDF.model.api.signature.SavedSignatureRequest;
import stirling.software.SPDF.model.api.signature.SavedSignatureResponse;
import stirling.software.common.configuration.InstallationPathConfig;

@Service
public class SharedSignatureService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SharedSignatureService.class);
    private final String SIGNATURE_BASE_PATH = InstallationPathConfig.getSignaturesPath();
    private final String ALL_USERS_FOLDER = "ALL_USERS";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public boolean hasAccessToFile(String username, String fileName) throws IOException {
        this.validateFileName(fileName);
        Path userPath = Paths.get(this.SIGNATURE_BASE_PATH, username, fileName);
        Path allUsersPath = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS", fileName);
        return Files.exists(userPath, new LinkOption[0]) || Files.exists(allUsersPath, new LinkOption[0]);
    }

    public List<SignatureFile> getAvailableSignatures(String username) {
        Path allUsersFolder;
        Path userFolder;
        ArrayList<SignatureFile> signatures = new ArrayList<SignatureFile>();
        if (StringUtils.hasText((String)username) && Files.exists(userFolder = Paths.get(this.SIGNATURE_BASE_PATH, username), new LinkOption[0])) {
            try {
                signatures.addAll(this.getSignaturesFromFolder(userFolder, "Personal"));
            }
            catch (IOException e) {
                log.error("Error reading user signatures folder", (Throwable)e);
            }
        }
        if (Files.exists(allUsersFolder = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS"), new LinkOption[0])) {
            try {
                signatures.addAll(this.getSignaturesFromFolder(allUsersFolder, "Shared"));
            }
            catch (IOException e) {
                log.error("Error reading shared signatures folder", (Throwable)e);
            }
        }
        return signatures;
    }

    private List<SignatureFile> getSignaturesFromFolder(Path folder, String category) throws IOException {
        try (Stream<Path> stream = Files.list(folder);){
            List<SignatureFile> list = stream.filter(arg_0 -> this.isImageFile(arg_0)).map(path -> new SignatureFile(path.getFileName().toString(), category)).toList();
            return list;
        }
    }

    public byte[] getSharedSignatureBytes(String fileName) throws IOException {
        this.validateFileName(fileName);
        Path allUsersPath = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS", fileName);
        if (!Files.exists(allUsersPath, new LinkOption[0])) {
            throw new FileNotFoundException("Shared signature file not found");
        }
        return Files.readAllBytes(allUsersPath);
    }

    private boolean isImageFile(Path path) {
        String fileName = path.getFileName().toString().toLowerCase();
        return fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png");
    }

    private void validateFileName(String fileName) {
        if (fileName.contains("..") || fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Invalid filename");
        }
        if (!fileName.matches("^[a-zA-Z0-9_.-]+$")) {
            throw new IllegalArgumentException("Filename contains invalid characters");
        }
    }

    private String validateAndNormalizeExtension(String extension) {
        String normalized = extension.toLowerCase().trim();
        if (normalized.equals("png") || normalized.equals("jpg") || normalized.equals("jpeg")) {
            return normalized;
        }
        throw new IllegalArgumentException("Unsupported image extension: " + extension);
    }

    private void verifyPathWithinDirectory(Path resolvedPath, Path targetDirectory) throws IOException {
        Path canonicalTarget = targetDirectory.toAbsolutePath().normalize();
        Path canonicalResolved = resolvedPath.toAbsolutePath().normalize();
        if (!canonicalResolved.startsWith(canonicalTarget)) {
            throw new IOException("Resolved path is outside the target directory");
        }
    }

    public SavedSignatureResponse saveSignature(String username, SavedSignatureRequest request) throws IOException {
        this.validateFileName(request.getId());
        String scope = request.getScope();
        if (scope == null || scope.isEmpty()) {
            scope = "personal";
        }
        String folderName = "shared".equals(scope) ? "ALL_USERS" : username;
        Path targetFolder = Paths.get(this.SIGNATURE_BASE_PATH, folderName);
        Files.createDirectories(targetFolder, new FileAttribute[0]);
        long timestamp = System.currentTimeMillis();
        SavedSignatureResponse response = new SavedSignatureResponse();
        response.setId(request.getId());
        response.setLabel(request.getLabel());
        response.setType(request.getType());
        response.setScope(scope);
        response.setCreatedAt(Long.valueOf(timestamp));
        response.setUpdatedAt(Long.valueOf(timestamp));
        String dataUrl = request.getDataUrl();
        if (dataUrl != null && dataUrl.startsWith("data:image/")) {
            String base64Data = dataUrl.substring(dataUrl.indexOf(",") + 1);
            byte[] imageBytes = Base64.getDecoder().decode(base64Data);
            String mimeType = dataUrl.substring(dataUrl.indexOf(":") + 1, dataUrl.indexOf(";"));
            String rawExtension = mimeType.substring(mimeType.indexOf("/") + 1);
            String extension = this.validateAndNormalizeExtension(rawExtension);
            String imageFileName = request.getId() + "." + extension;
            Path imagePath = targetFolder.resolve(imageFileName);
            this.verifyPathWithinDirectory(imagePath, targetFolder);
            Files.write(imagePath, imageBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            response.setDataUrl("/api/v1/general/signatures/" + imageFileName);
        }
        log.info("Saved signature {} for user {}", (Object)request.getId(), (Object)username);
        return response;
    }

    public List<SavedSignatureResponse> getSavedSignatures(String username) throws IOException {
        Path sharedFolder;
        ArrayList<SavedSignatureResponse> signatures = new ArrayList<SavedSignatureResponse>();
        Path personalFolder = Paths.get(this.SIGNATURE_BASE_PATH, username);
        if (Files.exists(personalFolder, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(personalFolder);){
                stream.filter(arg_0 -> this.isImageFile(arg_0)).forEach(path -> {
                    try {
                        String fileName = path.getFileName().toString();
                        String id = fileName.substring(0, fileName.lastIndexOf(46));
                        SavedSignatureResponse sig = new SavedSignatureResponse();
                        sig.setId(id);
                        sig.setLabel(id);
                        sig.setType("image");
                        sig.setScope("personal");
                        sig.setDataUrl("/api/v1/general/signatures/" + fileName);
                        sig.setCreatedAt(Long.valueOf(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
                        sig.setUpdatedAt(Long.valueOf(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
                        signatures.add(sig);
                    }
                    catch (IOException e) {
                        log.error("Error reading signature file: " + String.valueOf(path), (Throwable)e);
                    }
                });
            }
        }
        if (Files.exists(sharedFolder = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(sharedFolder);){
                stream.filter(arg_0 -> this.isImageFile(arg_0)).forEach(path -> {
                    try {
                        String fileName = path.getFileName().toString();
                        String id = fileName.substring(0, fileName.lastIndexOf(46));
                        SavedSignatureResponse sig = new SavedSignatureResponse();
                        sig.setId(id);
                        sig.setLabel(id);
                        sig.setType("image");
                        sig.setScope("shared");
                        sig.setDataUrl("/api/v1/general/signatures/" + fileName);
                        sig.setCreatedAt(Long.valueOf(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
                        sig.setUpdatedAt(Long.valueOf(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
                        signatures.add(sig);
                    }
                    catch (IOException e) {
                        log.error("Error reading signature file: " + String.valueOf(path), (Throwable)e);
                    }
                });
            }
        }
        return signatures;
    }

    public void deleteSignature(String username, String signatureId) throws IOException {
        Path sharedFolder;
        this.validateFileName(signatureId);
        Path personalFolder = Paths.get(this.SIGNATURE_BASE_PATH, username);
        boolean deleted = false;
        if (Files.exists(personalFolder, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(personalFolder);){
                List<Path> matchingFiles = stream.filter(path -> path.getFileName().toString().startsWith(signatureId + ".")).toList();
                for (Path file : matchingFiles) {
                    Files.delete(file);
                    deleted = true;
                }
            }
        }
        if (!deleted && Files.exists(sharedFolder = Paths.get(this.SIGNATURE_BASE_PATH, "ALL_USERS"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(sharedFolder);){
                List<Path> matchingFiles = stream.filter(path -> path.getFileName().toString().startsWith(signatureId + ".")).toList();
                for (Path file : matchingFiles) {
                    Files.delete(file);
                    deleted = true;
                }
            }
        }
        if (!deleted) {
            throw new FileNotFoundException("Signature not found");
        }
        log.info("Deleted signature {} for user {}", (Object)signatureId, (Object)username);
    }
}

