/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import stirling.software.SPDF.SPDFApplication;
import stirling.software.SPDF.model.ApiEndpoint;
import stirling.software.common.model.enumeration.Role;
import stirling.software.common.service.UserServiceInterface;
import stirling.software.common.util.RegexPatternUtils;

@Service
public class ApiDocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDocService.class);
    private final Map<String, ApiEndpoint> apiDocumentation = new HashMap();
    private final ServletContext servletContext;
    private final UserServiceInterface userService;
    Map<String, List<String>> outputToFileTypes = new HashMap();
    JsonNode apiDocsJsonRootNode;

    public ApiDocService(ServletContext servletContext, @Autowired(required=false) UserServiceInterface userService) {
        this.servletContext = servletContext;
        this.userService = userService;
    }

    private String getApiDocsUrl() {
        String contextPath = this.servletContext.getContextPath();
        String port = SPDFApplication.getStaticPort();
        return "http://localhost:" + port + contextPath + "/v1/api-docs";
    }

    public List<String> getExtensionTypes(boolean output, String operationName) {
        if (this.outputToFileTypes.isEmpty()) {
            this.outputToFileTypes.put("PDF", List.of("pdf"));
            this.outputToFileTypes.put("IMAGE", Arrays.asList("png", "jpg", "jpeg", "gif", "webp", "bmp", "tif", "tiff", "svg", "psd", "ai", "eps"));
            this.outputToFileTypes.put("ZIP", Arrays.asList("zip", "rar", "7z", "tar", "gz", "bz2", "xz", "lz", "lzma", "z"));
            this.outputToFileTypes.put("WORD", Arrays.asList("doc", "docx", "odt", "rtf"));
            this.outputToFileTypes.put("CSV", List.of("csv"));
            this.outputToFileTypes.put("JS", Arrays.asList("js", "jsx"));
            this.outputToFileTypes.put("HTML", Arrays.asList("html", "htm", "xhtml"));
            this.outputToFileTypes.put("JSON", List.of("json"));
            this.outputToFileTypes.put("TXT", Arrays.asList("txt", "text", "md", "markdown"));
            this.outputToFileTypes.put("PPT", Arrays.asList("ppt", "pptx", "odp"));
            this.outputToFileTypes.put("XML", Arrays.asList("xml", "xsd", "xsl"));
            this.outputToFileTypes.put("BOOK", Arrays.asList("epub", "mobi", "azw3", "fb2", "txt", "docx"));
        }
        if (this.apiDocsJsonRootNode == null || this.apiDocumentation.isEmpty()) {
            this.loadApiDocumentation();
        }
        if (!this.apiDocumentation.containsKey(operationName)) {
            return null;
        }
        ApiEndpoint endpoint = (ApiEndpoint)this.apiDocumentation.get(operationName);
        String description = endpoint.getDescription();
        Matcher matcher = (output ? RegexPatternUtils.getInstance().getApiDocOutputTypePattern() : RegexPatternUtils.getInstance().getApiDocInputTypePattern()).matcher(description);
        while (matcher.find()) {
            String type = matcher.group(1).toUpperCase();
            if (!this.outputToFileTypes.containsKey(type)) continue;
            return (List)this.outputToFileTypes.get(type);
        }
        return null;
    }

    private String getApiKeyForUser() {
        if (this.userService == null) {
            return "";
        }
        return this.userService.getApiKeyForUser(Role.INTERNAL_API_USER.getRoleId());
    }

    private synchronized void loadApiDocumentation() {
        String apiDocsJson = "";
        try {
            HttpHeaders headers = new HttpHeaders();
            String apiKey = this.getApiKeyForUser();
            if (!apiKey.isEmpty()) {
                headers.set("X-API-KEY", apiKey);
            }
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(this.getApiDocsUrl(), HttpMethod.GET, entity, String.class, new Object[0]);
            apiDocsJson = (String)response.getBody();
            ObjectMapper mapper = new ObjectMapper();
            this.apiDocsJsonRootNode = mapper.readTree(apiDocsJson);
            JsonNode paths = this.apiDocsJsonRootNode.path("paths");
            paths.propertyStream().forEach(entry -> {
                String path = (String)entry.getKey();
                JsonNode pathNode = (JsonNode)entry.getValue();
                if (pathNode.has("post")) {
                    JsonNode postNode = pathNode.get("post");
                    ApiEndpoint endpoint = new ApiEndpoint(path, postNode);
                    this.apiDocumentation.put(path, endpoint);
                }
            });
        }
        catch (Exception e) {
            log.error("Error grabbing swagger doc, body result {}", (Object)apiDocsJson);
        }
    }

    public boolean isValidOperation(String operationName, Map<String, Object> parameters) {
        if (this.apiDocumentation.isEmpty()) {
            this.loadApiDocumentation();
        }
        if (!this.apiDocumentation.containsKey(operationName)) {
            return false;
        }
        ApiEndpoint endpoint = (ApiEndpoint)this.apiDocumentation.get(operationName);
        return endpoint.areParametersValid(parameters);
    }

    public boolean isMultiInput(String operationName) {
        if (this.apiDocsJsonRootNode == null || this.apiDocumentation.isEmpty()) {
            this.loadApiDocumentation();
        }
        if (!this.apiDocumentation.containsKey(operationName)) {
            return false;
        }
        ApiEndpoint endpoint = (ApiEndpoint)this.apiDocumentation.get(operationName);
        String description = endpoint.getDescription();
        Matcher matcher = RegexPatternUtils.getInstance().getApiDocTypePattern().matcher(description);
        if (matcher.find()) {
            String type = matcher.group(1);
            return type.startsWith("MI");
        }
        return false;
    }
}

