/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class ReactRoutingController {
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;
    private String cachedIndexHtml;
    private boolean indexHtmlExists = false;

    @PostConstruct
    public void init() {
        ClassPathResource resource = new ClassPathResource("static/index.html");
        if (resource.exists()) {
            try {
                this.cachedIndexHtml = this.processIndexHtml();
                this.indexHtmlExists = true;
            }
            catch (IOException e) {
                this.indexHtmlExists = false;
            }
        }
    }

    private String processIndexHtml() throws IOException {
        ClassPathResource resource = new ClassPathResource("static/index.html");
        try (InputStream inputStream = resource.getInputStream();){
            String html = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            Object baseUrl = this.contextPath.endsWith("/") ? this.contextPath : this.contextPath + "/";
            html = html.replace("%BASE_URL%", (CharSequence)baseUrl);
            html = html.replaceFirst("<base href=\\\"[^\\\"]*\\\"\\s*/?>", "<base href=\\\"" + (String)baseUrl + "\\\" />");
            String contextPathScript = "<script>window.STIRLING_PDF_API_BASE_URL = '" + (String)baseUrl + "';</script>";
            String string = html = html.replace("</head>", contextPathScript + "</head>");
            return string;
        }
    }

    @GetMapping(value={"/", "/index.html"}, produces={"text/html"})
    public ResponseEntity<String> serveIndexHtml(HttpServletRequest request) throws IOException {
        if (this.indexHtmlExists && this.cachedIndexHtml != null) {
            return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.cachedIndexHtml);
        }
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.processIndexHtml());
    }

    @GetMapping(value={"/{path:^(?!api|static|robots\\.txt|favicon\\.ico|manifest.*\\.json|pipeline|pdfjs|pdfjs-legacy|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*$}"})
    public ResponseEntity<String> forwardRootPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }

    @GetMapping(value={"/{path:^(?!api|static|pipeline|pdfjs|pdfjs-legacy|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*}/{subpath:^(?!.*\\.).*$}"})
    public ResponseEntity<String> forwardNestedPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }
}

