/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDJavascriptNameTreeNode;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.JavaScriptResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class ShowJavascript {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/show-javascript"})
    @JavaScriptResponse
    @Operation(summary="Grabs all JS from a PDF and returns a single JS file with all code", description="desc. Input:PDF Output:JS Type:SISO")
    public ResponseEntity<byte[]> extractHeader(@ModelAttribute PDFFile file) throws Exception {
        MultipartFile inputFile = file.getFileInput();
        StringBuilder script = new StringBuilder();
        boolean foundScript = false;
        try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
            PDJavascriptNameTreeNode jsTree;
            if (document.getDocumentCatalog() != null && document.getDocumentCatalog().getNames() != null && (jsTree = document.getDocumentCatalog().getNames().getJavaScript()) != null) {
                Map jsEntries = jsTree.getNames();
                for (Map.Entry entry : jsEntries.entrySet()) {
                    String name = (String)entry.getKey();
                    PDActionJavaScript jsAction = (PDActionJavaScript)entry.getValue();
                    String jsCodeStr = jsAction.getAction();
                    if (jsCodeStr == null || jsCodeStr.trim().isEmpty()) continue;
                    script.append("// File: ").append(Filenames.toSimpleFileName((String)inputFile.getOriginalFilename())).append(", Script: ").append(name).append("\n").append(jsCodeStr).append("\n");
                    foundScript = true;
                }
            }
            if (!foundScript) {
                script = new StringBuilder("PDF '").append(Filenames.toSimpleFileName((String)inputFile.getOriginalFilename())).append("' does not contain Javascript");
            }
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])script.toString().getBytes(StandardCharsets.UTF_8), (String)(Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()) + ".js"), (MediaType)MediaType.TEXT_PLAIN);
            return responseEntity;
        }
    }

    @Generated
    public ShowJavascript(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

