/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.misc.ScannerEffectController;
import stirling.software.SPDF.model.api.misc.ScannerEffectRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class ScannerEffectController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScannerEffectController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private static final Random RANDOM = new Random();
    private static final int MAX_IMAGE_WIDTH = 8192;
    private static final int MAX_IMAGE_HEIGHT = 8192;
    private static final long MAX_IMAGE_PIXELS = 0x1000000L;

    @AutoJobPostMapping(value={"/scanner-effect"}, consumes={"multipart/form-data"})
    @Operation(summary="Apply scanner effect to PDF", description="Applies various effects to simulate a scanned document, including rotation, noise, and edge softening. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> scannerEffect(@Valid @ModelAttribute ScannerEffectRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        if (!request.isAdvancedEnabled()) {
            switch (1.$SwitchMap$stirling$software$SPDF$model$api$misc$ScannerEffectRequest$Quality[request.getQuality().ordinal()]) {
                case 1: {
                    request.applyHighQualityPreset();
                    break;
                }
                case 2: {
                    request.applyMediumQualityPreset();
                    break;
                }
                case 3: {
                    request.applyLowQualityPreset();
                }
            }
        }
        int baseRotation = request.getRotationValue() + request.getRotate();
        int rotateVariance = request.getRotateVariance();
        int borderPx = request.getBorder();
        float brightness = request.getBrightness();
        float contrast = request.getContrast();
        float blur = request.getBlur();
        float noise = request.getNoise();
        boolean yellowish = request.isYellowish();
        int resolution = request.getResolution();
        ScannerEffectRequest.Colorspace colorspace = request.getColorspace();
        int maxSafeDpi = 500;
        ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
        if (properties != null && properties.getSystem() != null) {
            maxSafeDpi = properties.getSystem().getMaxDPI();
        }
        if (resolution > maxSafeDpi) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.dpiExceedsLimit", (String)"DPI value {0} exceeds maximum safe limit of {1}. High DPI values can cause memory issues and crashes. Please use a lower DPI value.", (Object[])new Object[]{resolution, maxSafeDpi});
        }
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            PDDocument outputDocument = new PDDocument();
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage rotated;
                BufferedImage processed;
                BufferedImage image;
                PDRectangle pageSize = document.getPage(i).getMediaBox();
                float pageWidthPts = pageSize.getWidth();
                float pageHeightPts = pageSize.getHeight();
                int projectedWidth = (int)Math.ceil((double)(pageWidthPts * (float)resolution) / 72.0);
                int projectedHeight = (int)Math.ceil((double)(pageHeightPts * (float)resolution) / 72.0);
                long projectedPixels = (long)projectedWidth * (long)projectedHeight;
                int safeResolution = resolution;
                if (projectedWidth > 8192 || projectedHeight > 8192 || projectedPixels > 0x1000000L) {
                    double widthScale = 8192.0 / (double)projectedWidth;
                    double heightScale = 8192.0 / (double)projectedHeight;
                    double pixelScale = Math.sqrt(1.6777216E7 / (double)projectedPixels);
                    double minScale = Math.min(Math.min(widthScale, heightScale), pixelScale);
                    safeResolution = (int)Math.max(72.0, (double)resolution * minScale);
                    log.warn("Page {} would be too large at {}dpi ({}x{} pixels). Reducing to {}dpi", new Object[]{i + 1, resolution, projectedWidth, projectedHeight, safeResolution});
                }
                try {
                    image = pdfRenderer.renderImageWithDPI(i, (float)safeResolution);
                }
                catch (OutOfMemoryError e) {
                    throw ExceptionUtils.createOutOfMemoryDpiException((int)(i + 1), (int)safeResolution, (OutOfMemoryError)e);
                }
                catch (NegativeArraySizeException e) {
                    throw ExceptionUtils.createOutOfMemoryDpiException((int)(i + 1), (int)safeResolution, (Throwable)e);
                }
                log.debug("Processing page {} with dimensions {}x{} ({} pixels) at {}dpi", new Object[]{i + 1, image.getWidth(), image.getHeight(), (long)image.getWidth() * (long)image.getHeight(), safeResolution});
                if (colorspace == ScannerEffectRequest.Colorspace.grayscale) {
                    processed = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics2D gGray = processed.createGraphics();
                    gGray.setColor(Color.BLACK);
                    gGray.fillRect(0, 0, image.getWidth(), image.getHeight());
                    gGray.drawImage((Image)image, 0, 0, null);
                    gGray.dispose();
                    for (int y = 0; y < processed.getHeight(); ++y) {
                        for (int x = 0; x < processed.getWidth(); ++x) {
                            int rgb = processed.getRGB(x, y);
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb & 0xFF;
                            int gray = (r + g + b) / 3;
                            int grayRGB = gray << 16 | gray << 8 | gray;
                            processed.setRGB(x, y, grayRGB);
                        }
                    }
                } else {
                    processed = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics2D gCol = processed.createGraphics();
                    gCol.drawImage((Image)image, 0, 0, null);
                    gCol.dispose();
                }
                int baseW = processed.getWidth() + 2 * borderPx;
                int baseH = processed.getHeight() + 2 * borderPx;
                boolean vertical = RANDOM.nextBoolean();
                float startGrey = 0.6f + 0.3f * RANDOM.nextFloat();
                float endGrey = 0.6f + 0.3f * RANDOM.nextFloat();
                Color startColor = new Color(Math.round(startGrey * 255.0f), Math.round(startGrey * 255.0f), Math.round(startGrey * 255.0f));
                Color endColor = new Color(Math.round(endGrey * 255.0f), Math.round(endGrey * 255.0f), Math.round(endGrey * 255.0f));
                BufferedImage composed = new BufferedImage(baseW, baseH, processed.getType());
                Graphics2D gBg = composed.createGraphics();
                for (int y = 0; y < baseH; ++y) {
                    for (int x = 0; x < baseW; ++x) {
                        float frac = vertical ? (float)y / (float)(baseH - 1) : (float)x / (float)(baseW - 1);
                        int r = Math.round((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * frac);
                        int g = Math.round((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * frac);
                        int b = Math.round((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * frac);
                        composed.setRGB(x, y, new Color(r, g, b).getRGB());
                    }
                }
                gBg.drawImage((Image)processed, borderPx, borderPx, null);
                gBg.dispose();
                double pageRotation = baseRotation;
                if (baseRotation != 0 || rotateVariance != 0) {
                    pageRotation += (RANDOM.nextDouble() * 2.0 - 1.0) * (double)rotateVariance;
                }
                int w = composed.getWidth();
                int h = composed.getHeight();
                int rotW = w;
                int rotH = h;
                if (pageRotation == 0.0) {
                    rotated = composed;
                } else {
                    double radians = Math.toRadians(pageRotation);
                    double sin = Math.abs(Math.sin(radians));
                    double cos = Math.abs(Math.cos(radians));
                    rotW = (int)Math.floor((double)w * cos + (double)h * sin);
                    rotH = (int)Math.floor((double)h * cos + (double)w * sin);
                    BufferedImage rotatedBg = new BufferedImage(rotW, rotH, composed.getType());
                    Graphics2D gBgRot = rotatedBg.createGraphics();
                    for (int y = 0; y < rotH; ++y) {
                        for (int x = 0; x < rotW; ++x) {
                            float frac = vertical ? (float)y / (float)(rotH - 1) : (float)x / (float)(rotW - 1);
                            int r = Math.round((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * frac);
                            int g = Math.round((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * frac);
                            int b = Math.round((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * frac);
                            rotatedBg.setRGB(x, y, new Color(r, g, b).getRGB());
                        }
                    }
                    gBgRot.dispose();
                    rotated = new BufferedImage(rotW, rotH, composed.getType());
                    Graphics2D g2d = rotated.createGraphics();
                    g2d.drawImage((Image)rotatedBg, 0, 0, null);
                    AffineTransform at = new AffineTransform();
                    at.translate((double)(rotW - w) / 2.0, (double)(rotH - h) / 2.0);
                    at.rotate(radians, (double)w / 2.0, (double)h / 2.0);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.drawImage(composed, at, null);
                    g2d.dispose();
                }
                PDRectangle origPageSize = document.getPage(i).getMediaBox();
                float origW = origPageSize.getWidth();
                float origH = origPageSize.getHeight();
                float scale = Math.max(origW / (float)rotW, origH / (float)rotH);
                float drawW = (float)rotW * scale;
                float drawH = (float)rotH * scale;
                float offsetX = (origW - drawW) / 2.0f;
                float offsetY = (origH - drawH) / 2.0f;
                BufferedImage softened = this.softenEdges(rotated, Math.max(10, Math.round((float)Math.min(rotW, rotH) * 0.02f)), startColor, endColor, vertical);
                BufferedImage blurred = this.applyGaussianBlur(softened, (double)blur);
                BufferedImage adjusted = this.adjustBrightnessContrast(blurred, brightness, contrast);
                if (yellowish) {
                    this.applyYellowishEffect(adjusted);
                }
                this.addGaussianNoise(adjusted, (double)noise);
                PDPage newPage = new PDPage(new PDRectangle(origW, origH));
                outputDocument.addPage(newPage);
                try (PDPageContentStream contentStream = new PDPageContentStream(outputDocument, newPage);){
                    PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)outputDocument, (BufferedImage)adjusted);
                    contentStream.drawImage(pdImage, offsetX, offsetY, drawW, drawH);
                    continue;
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputDocument.save((OutputStream)outputStream);
            outputDocument.close();
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])outputStream.toByteArray(), (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_scanner_effect.pdf"));
            return responseEntity;
        }
    }

    private BufferedImage softenEdges(BufferedImage image, int featherRadius, Color startColor, Color endColor, boolean vertical) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage output = new BufferedImage(width, height, image.getType());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int dx = Math.min(x, width - 1 - x);
                int dy = Math.min(y, height - 1 - y);
                int d = Math.min(dx, dy);
                float frac = vertical ? (float)y / (float)(height - 1) : (float)x / (float)(width - 1);
                int rBg = Math.round((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * frac);
                int gBg = Math.round((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * frac);
                int bBg = Math.round((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * frac);
                int bgVal = new Color(rBg, gBg, bBg).getRGB();
                int fgVal = image.getRGB(x, y);
                float alpha = d < featherRadius ? (float)d / (float)featherRadius : 1.0f;
                int blended = this.blendColors(fgVal, bgVal, alpha);
                output.setRGB(x, y, blended);
            }
        }
        return output;
    }

    private int blendColors(int fg, int bg, float alpha) {
        int r = Math.round((float)(fg >> 16 & 0xFF) * alpha + (float)(bg >> 16 & 0xFF) * (1.0f - alpha));
        int g = Math.round((float)(fg >> 8 & 0xFF) * alpha + (float)(bg >> 8 & 0xFF) * (1.0f - alpha));
        int b = Math.round((float)(fg & 0xFF) * alpha + (float)(bg & 0xFF) * (1.0f - alpha));
        return r << 16 | g << 8 | b;
    }

    private BufferedImage applyGaussianBlur(BufferedImage image, double sigma) {
        int i;
        if (sigma <= 0.0) {
            return image;
        }
        double scaledSigma = sigma * (double)Math.min(image.getWidth(), image.getHeight()) / 1000.0;
        int radius = Math.max(1, (int)Math.ceil(scaledSigma * 3.0));
        int size = 2 * radius + 1;
        float[] data = new float[size * size];
        double sum = 0.0;
        for (i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                double xDistance = (double)i * (double)i;
                double yDistance = (double)j * (double)j;
                double g = Math.exp(-(xDistance + yDistance) / (2.0 * scaledSigma * scaledSigma));
                data[(i + radius) * size + j + radius] = (float)g;
                sum += g;
            }
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / (float)sum;
        }
        Kernel kernel = new Kernel(size, size, data);
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage((Image)op.filter(image, null), 0, 0, null);
        g2d.dispose();
        return result;
    }

    private void applyYellowishEffect(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                float brightness = (float)(r + g + b) / 765.0f;
                r = Math.min(255, (int)((float)r + (float)(255 - r) * 0.18f * brightness));
                g = Math.min(255, (int)((float)g + (float)(255 - g) * 0.12f * brightness));
                b = Math.max(0, (int)((float)b * (1.0f - 0.25f * brightness)));
                image.setRGB(x, y, r << 16 | g << 8 | b);
            }
        }
    }

    private void addGaussianNoise(BufferedImage image, double strength) {
        if (strength <= 0.0) {
            return;
        }
        double scaledStrength = strength * (double)Math.min(image.getWidth(), image.getHeight()) / 1000.0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                double noiseR = RANDOM.nextGaussian() * scaledStrength;
                double noiseG = RANDOM.nextGaussian() * scaledStrength;
                double noiseB = RANDOM.nextGaussian() * scaledStrength;
                r = Math.min(255, Math.max(0, r + (int)noiseR));
                g = Math.min(255, Math.max(0, g + (int)noiseG));
                b = Math.min(255, Math.max(0, b + (int)noiseB));
                image.setRGB(x, y, r << 16 | g << 8 | b);
            }
        }
    }

    private BufferedImage adjustBrightnessContrast(BufferedImage image, float brightness, float contrast) {
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int r = (int)(((float)((rgb >> 16 & 0xFF) - 128) * contrast + 128.0f) * brightness);
                int g = (int)(((float)((rgb >> 8 & 0xFF) - 128) * contrast + 128.0f) * brightness);
                int b = (int)(((float)((rgb & 0xFF) - 128) * contrast + 128.0f) * brightness);
                r = Math.min(255, Math.max(0, r));
                g = Math.min(255, Math.max(0, g));
                b = Math.min(255, Math.max(0, b));
                output.setRGB(x, y, r << 16 | g << 8 | b);
            }
        }
        return output;
    }

    @Generated
    public ScannerEffectController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

