/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.AddPageNumbersRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class PageNumbersController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(value={"/add-page-numbers"}, consumes={"multipart/form-data"})
    @StandardPdfResponse
    @Operation(summary="Add page numbers to a PDF document", description="This operation takes an input PDF file and adds page numbers to it. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> addPageNumbers(@ModelAttribute AddPageNumbersRequest request) throws IOException {
        float marginFactor;
        MultipartFile file = request.getFileInput();
        String customMargin = request.getCustomMargin();
        int position = request.getPosition();
        int pageNumber = request.getStartingNumber();
        String pagesToNumber = request.getPagesToNumber();
        String customText = request.getCustomText();
        float fontSize = request.getFontSize();
        String fontType = request.getFontType();
        String fontColor = request.getFontColor();
        Color color = Color.BLACK;
        if (fontColor != null && !fontColor.trim().isEmpty()) {
            try {
                color = Color.decode(fontColor);
            }
            catch (NumberFormatException e) {
                color = Color.BLACK;
            }
        }
        PDDocument document = this.pdfDocumentFactory.load(file);
        switch (customMargin == null ? "" : customMargin.toLowerCase(Locale.ROOT)) {
            case "small": {
                float f = 0.02f;
                break;
            }
            case "large": {
                float f = 0.05f;
                break;
            }
            case "x-large": {
                float f = 0.075f;
                break;
            }
            case "medium": {
                float f = 0.035f;
                break;
            }
            default: {
                float f = marginFactor = 0.035f;
            }
        }
        if (pagesToNumber == null || pagesToNumber.isEmpty()) {
            pagesToNumber = "all";
        }
        if (customText == null || customText.isEmpty()) {
            customText = "{n}";
        }
        String baseFilename = Filenames.toSimpleFileName((String)file.getOriginalFilename()).replaceFirst("[.][^.]+$", "");
        List pagesToNumberList = GeneralUtils.parsePageList((String[])pagesToNumber.split(","), (int)document.getNumberOfPages());
        int pos = Math.max(1, Math.min(9, position));
        Iterator iterator = pagesToNumberList.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            PDPage page = document.getPage(i);
            PDRectangle pageSize = page.getMediaBox();
            String text = customText.replace("{n}", String.valueOf(pageNumber)).replace("{total}", String.valueOf(document.getNumberOfPages())).replace("{filename}", GeneralUtils.removeExtension((String)Filenames.toSimpleFileName((String)file.getOriginalFilename())));
            PDType1Font currentFont = switch (fontType == null ? "" : fontType.toLowerCase(Locale.ROOT)) {
                case "courier" -> new PDType1Font(Standard14Fonts.FontName.COURIER);
                case "times" -> new PDType1Font(Standard14Fonts.FontName.TIMES_ROMAN);
                default -> new PDType1Font(Standard14Fonts.FontName.HELVETICA);
            };
            float textWidth = currentFont.getStringWidth(text) / 1000.0f * fontSize;
            float ascent = currentFont.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            float descent = currentFont.getFontDescriptor().getDescent() / 1000.0f * fontSize;
            int col = (pos - 1) % 3 + 1;
            int row = (pos - 1) / 3 + 1;
            float leftX = pageSize.getLowerLeftX() + marginFactor * pageSize.getWidth();
            float midX = pageSize.getLowerLeftX() + pageSize.getWidth() / 2.0f;
            float rightX = pageSize.getUpperRightX() - marginFactor * pageSize.getWidth();
            float botY = pageSize.getLowerLeftY() + marginFactor * pageSize.getHeight();
            float midY = pageSize.getLowerLeftY() + pageSize.getHeight() / 2.0f;
            float topY = pageSize.getUpperRightY() - marginFactor * pageSize.getHeight();
            float x = switch (col) {
                case 1 -> leftX;
                case 2 -> midX - textWidth / 2.0f;
                default -> rightX - textWidth;
            };
            float y = switch (row) {
                case 1 -> topY - ascent;
                case 2 -> midY - (ascent + descent) / 2.0f;
                default -> botY;
            };
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                contentStream.beginText();
                contentStream.setFont((PDFont)currentFont, fontSize);
                contentStream.setNonStrokingColor(color);
                contentStream.newLineAtOffset(x, y);
                contentStream.showText(text);
                contentStream.endText();
            }
            ++pageNumber;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.save((OutputStream)baos);
        document.close();
        return WebResponseUtils.bytesToWebResponse((byte[])baos.toByteArray(), (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_page_numbers_added.pdf"));
    }

    @Generated
    public PageNumbersController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

