/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SettingsApi;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.util.GeneralUtils;

@SettingsApi
@Hidden
public class SettingsController {
    private final ApplicationProperties applicationProperties;
    private final EndpointConfiguration endpointConfiguration;

    @AutoJobPostMapping(value={"/update-enable-analytics"})
    @Hidden
    public ResponseEntity<String> updateApiKey(@RequestParam Boolean enabled) throws IOException {
        if (this.applicationProperties.getSystem().getEnableAnalytics() != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ALREADY_REPORTED).body((Object)("Setting has already been set, To adjust please edit " + InstallationPathConfig.getSettingsPath()));
        }
        GeneralUtils.saveKeyToSettings((String)"system.enableAnalytics", (Object)enabled);
        this.applicationProperties.getSystem().setEnableAnalytics(enabled);
        return ResponseEntity.ok((Object)"Updated");
    }

    @GetMapping(value={"/get-endpoints-status"})
    @Hidden
    public ResponseEntity<Map<String, Boolean>> getDisabledEndpoints() {
        return ResponseEntity.ok((Object)this.endpointConfiguration.getEndpointStatuses());
    }

    @GetMapping(value={"/admin/settings/general"})
    @Hidden
    public ResponseEntity<Map<String, Object>> getGeneralSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("ui", this.applicationProperties.getUi());
        settings.put("system", Map.of("defaultLocale", this.applicationProperties.getSystem().getDefaultLocale(), "showUpdate", this.applicationProperties.getSystem().isShowUpdate(), "showUpdateOnlyAdmin", this.applicationProperties.getSystem().getShowUpdateOnlyAdmin(), "customHTMLFiles", this.applicationProperties.getSystem().isCustomHTMLFiles(), "fileUploadLimit", this.applicationProperties.getSystem().getFileUploadLimit()));
        return ResponseEntity.ok(settings);
    }

    @PostMapping(value={"/admin/settings/general"})
    @Hidden
    public ResponseEntity<String> updateGeneralSettings(@RequestBody Map<String, Object> settings) throws IOException {
        Map ui;
        if (settings.containsKey("ui") && (ui = (Map)settings.get("ui")).containsKey("appNameNavbar")) {
            GeneralUtils.saveKeyToSettings((String)"ui.appNameNavbar", ui.get("appNameNavbar"));
            this.applicationProperties.getUi().setAppNameNavbar((String)ui.get("appNameNavbar"));
        }
        if (settings.containsKey("system")) {
            Map system = (Map)settings.get("system");
            if (system.containsKey("defaultLocale")) {
                GeneralUtils.saveKeyToSettings((String)"system.defaultLocale", system.get("defaultLocale"));
                this.applicationProperties.getSystem().setDefaultLocale((String)system.get("defaultLocale"));
            }
            if (system.containsKey("showUpdate")) {
                GeneralUtils.saveKeyToSettings((String)"system.showUpdate", system.get("showUpdate"));
                this.applicationProperties.getSystem().setShowUpdate(((Boolean)system.get("showUpdate")).booleanValue());
            }
            if (system.containsKey("showUpdateOnlyAdmin")) {
                GeneralUtils.saveKeyToSettings((String)"system.showUpdateOnlyAdmin", system.get("showUpdateOnlyAdmin"));
                this.applicationProperties.getSystem().setShowUpdateOnlyAdmin((Boolean)system.get("showUpdateOnlyAdmin"));
            }
            if (system.containsKey("fileUploadLimit")) {
                GeneralUtils.saveKeyToSettings((String)"system.fileUploadLimit", system.get("fileUploadLimit"));
                this.applicationProperties.getSystem().setFileUploadLimit((String)system.get("fileUploadLimit"));
            }
        }
        return ResponseEntity.ok((Object)"General settings updated. Restart required for changes to take effect.");
    }

    @GetMapping(value={"/admin/settings/security"})
    @Hidden
    public ResponseEntity<Map<String, Object>> getSecuritySettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ApplicationProperties.Security security = this.applicationProperties.getSecurity();
        settings.put("enableLogin", security.getEnableLogin());
        settings.put("loginMethod", security.getLoginMethod());
        settings.put("loginAttemptCount", security.getLoginAttemptCount());
        settings.put("loginResetTimeMinutes", security.getLoginResetTimeMinutes());
        settings.put("initialLogin", Map.of("username", security.getInitialLogin().getUsername() != null ? security.getInitialLogin().getUsername() : ""));
        ApplicationProperties.Security.Jwt jwt = security.getJwt();
        settings.put("jwt", Map.of("enableKeystore", jwt.isEnableKeystore(), "enableKeyRotation", jwt.isEnableKeyRotation(), "enableKeyCleanup", jwt.isEnableKeyCleanup(), "keyRetentionDays", jwt.getKeyRetentionDays()));
        return ResponseEntity.ok(settings);
    }

    @PostMapping(value={"/admin/settings/security"})
    @Hidden
    public ResponseEntity<String> updateSecuritySettings(@RequestBody Map<String, Object> settings) throws IOException {
        Map jwt;
        if (settings.containsKey("enableLogin")) {
            GeneralUtils.saveKeyToSettings((String)"security.enableLogin", (Object)settings.get("enableLogin"));
            this.applicationProperties.getSecurity().setEnableLogin((Boolean)settings.get("enableLogin"));
        }
        if (settings.containsKey("loginMethod")) {
            GeneralUtils.saveKeyToSettings((String)"security.loginMethod", (Object)settings.get("loginMethod"));
            this.applicationProperties.getSecurity().setLoginMethod((String)settings.get("loginMethod"));
        }
        if (settings.containsKey("loginAttemptCount")) {
            GeneralUtils.saveKeyToSettings((String)"security.loginAttemptCount", (Object)settings.get("loginAttemptCount"));
            this.applicationProperties.getSecurity().setLoginAttemptCount(((Integer)settings.get("loginAttemptCount")).intValue());
        }
        if (settings.containsKey("loginResetTimeMinutes")) {
            GeneralUtils.saveKeyToSettings((String)"security.loginResetTimeMinutes", (Object)settings.get("loginResetTimeMinutes"));
            this.applicationProperties.getSecurity().setLoginResetTimeMinutes(((Number)settings.get("loginResetTimeMinutes")).longValue());
        }
        if (settings.containsKey("jwt") && (jwt = (Map)settings.get("jwt")).containsKey("keyRetentionDays")) {
            GeneralUtils.saveKeyToSettings((String)"security.jwt.keyRetentionDays", jwt.get("keyRetentionDays"));
            this.applicationProperties.getSecurity().getJwt().setKeyRetentionDays(((Integer)jwt.get("keyRetentionDays")).intValue());
        }
        return ResponseEntity.ok((Object)"Security settings updated. Restart required for changes to take effect.");
    }

    @GetMapping(value={"/admin/settings/connections"})
    @Hidden
    public ResponseEntity<Map<String, Object>> getConnectionsSettings() {
        HashMap<String, Map<String, String>> settings = new HashMap<String, Map<String, String>>();
        ApplicationProperties.Security security = this.applicationProperties.getSecurity();
        ApplicationProperties.Security.OAUTH2 oauth2 = security.getOauth2();
        settings.put("oauth2", Map.of("enabled", oauth2.getEnabled(), "issuer", oauth2.getIssuer() != null ? oauth2.getIssuer() : "", "clientId", oauth2.getClientId() != null ? oauth2.getClientId() : "", "provider", oauth2.getProvider() != null ? oauth2.getProvider() : "", "autoCreateUser", oauth2.getAutoCreateUser(), "blockRegistration", oauth2.getBlockRegistration(), "useAsUsername", oauth2.getUseAsUsername() != null ? oauth2.getUseAsUsername() : ""));
        ApplicationProperties.Security.SAML2 saml2 = security.getSaml2();
        settings.put("saml2", Map.of("enabled", saml2.getEnabled(), "provider", saml2.getProvider() != null ? saml2.getProvider() : "", "autoCreateUser", saml2.getAutoCreateUser(), "blockRegistration", saml2.getBlockRegistration(), "registrationId", saml2.getRegistrationId()));
        return ResponseEntity.ok(settings);
    }

    @PostMapping(value={"/admin/settings/connections"})
    @Hidden
    public ResponseEntity<String> updateConnectionsSettings(@RequestBody Map<String, Object> settings) throws IOException {
        if (settings.containsKey("oauth2")) {
            Map oauth2 = (Map)settings.get("oauth2");
            if (oauth2.containsKey("enabled")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.enabled", oauth2.get("enabled"));
                this.applicationProperties.getSecurity().getOauth2().setEnabled((Boolean)oauth2.get("enabled"));
            }
            if (oauth2.containsKey("issuer")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.issuer", oauth2.get("issuer"));
                this.applicationProperties.getSecurity().getOauth2().setIssuer((String)oauth2.get("issuer"));
            }
            if (oauth2.containsKey("clientId")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.clientId", oauth2.get("clientId"));
                this.applicationProperties.getSecurity().getOauth2().setClientId((String)oauth2.get("clientId"));
            }
            if (oauth2.containsKey("clientSecret")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.clientSecret", oauth2.get("clientSecret"));
                this.applicationProperties.getSecurity().getOauth2().setClientSecret((String)oauth2.get("clientSecret"));
            }
            if (oauth2.containsKey("provider")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.provider", oauth2.get("provider"));
                this.applicationProperties.getSecurity().getOauth2().setProvider((String)oauth2.get("provider"));
            }
            if (oauth2.containsKey("autoCreateUser")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.autoCreateUser", oauth2.get("autoCreateUser"));
                this.applicationProperties.getSecurity().getOauth2().setAutoCreateUser((Boolean)oauth2.get("autoCreateUser"));
            }
            if (oauth2.containsKey("blockRegistration")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.blockRegistration", oauth2.get("blockRegistration"));
                this.applicationProperties.getSecurity().getOauth2().setBlockRegistration((Boolean)oauth2.get("blockRegistration"));
            }
            if (oauth2.containsKey("useAsUsername")) {
                GeneralUtils.saveKeyToSettings((String)"security.oauth2.useAsUsername", oauth2.get("useAsUsername"));
                this.applicationProperties.getSecurity().getOauth2().setUseAsUsername((String)oauth2.get("useAsUsername"));
            }
        }
        if (settings.containsKey("saml2")) {
            Map saml2 = (Map)settings.get("saml2");
            if (saml2.containsKey("enabled")) {
                GeneralUtils.saveKeyToSettings((String)"security.saml2.enabled", saml2.get("enabled"));
                this.applicationProperties.getSecurity().getSaml2().setEnabled((Boolean)saml2.get("enabled"));
            }
            if (saml2.containsKey("provider")) {
                GeneralUtils.saveKeyToSettings((String)"security.saml2.provider", saml2.get("provider"));
                this.applicationProperties.getSecurity().getSaml2().setProvider((String)saml2.get("provider"));
            }
            if (saml2.containsKey("autoCreateUser")) {
                GeneralUtils.saveKeyToSettings((String)"security.saml2.autoCreateUser", saml2.get("autoCreateUser"));
                this.applicationProperties.getSecurity().getSaml2().setAutoCreateUser((Boolean)saml2.get("autoCreateUser"));
            }
            if (saml2.containsKey("blockRegistration")) {
                GeneralUtils.saveKeyToSettings((String)"security.saml2.blockRegistration", saml2.get("blockRegistration"));
                this.applicationProperties.getSecurity().getSaml2().setBlockRegistration((Boolean)saml2.get("blockRegistration"));
            }
        }
        return ResponseEntity.ok((Object)"Connection settings updated. Restart required for changes to take effect.");
    }

    @GetMapping(value={"/admin/settings/privacy"})
    @Hidden
    public ResponseEntity<Map<String, Object>> getPrivacySettings() {
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        settings.put("enableAnalytics", this.applicationProperties.getSystem().getEnableAnalytics());
        settings.put("googleVisibility", this.applicationProperties.getSystem().getGooglevisibility());
        settings.put("metricsEnabled", this.applicationProperties.getMetrics().getEnabled());
        return ResponseEntity.ok(settings);
    }

    @PostMapping(value={"/admin/settings/privacy"})
    @Hidden
    public ResponseEntity<String> updatePrivacySettings(@RequestBody Map<String, Object> settings) throws IOException {
        if (settings.containsKey("enableAnalytics")) {
            GeneralUtils.saveKeyToSettings((String)"system.enableAnalytics", (Object)settings.get("enableAnalytics"));
            this.applicationProperties.getSystem().setEnableAnalytics((Boolean)settings.get("enableAnalytics"));
        }
        if (settings.containsKey("googleVisibility")) {
            GeneralUtils.saveKeyToSettings((String)"system.googlevisibility", (Object)settings.get("googleVisibility"));
            this.applicationProperties.getSystem().setGooglevisibility((Boolean)settings.get("googleVisibility"));
        }
        if (settings.containsKey("metricsEnabled")) {
            GeneralUtils.saveKeyToSettings((String)"metrics.enabled", (Object)settings.get("metricsEnabled"));
            this.applicationProperties.getMetrics().setEnabled((Boolean)settings.get("metricsEnabled"));
        }
        return ResponseEntity.ok((Object)"Privacy settings updated. Restart required for changes to take effect.");
    }

    @GetMapping(value={"/admin/settings/advanced"})
    @Hidden
    public ResponseEntity<Map<String, Object>> getAdvancedSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("endpoints", this.applicationProperties.getEndpoints());
        settings.put("enableAlphaFunctionality", this.applicationProperties.getSystem().getEnableAlphaFunctionality());
        settings.put("maxDPI", this.applicationProperties.getSystem().getMaxDPI());
        settings.put("enableUrlToPDF", this.applicationProperties.getSystem().getEnableUrlToPDF());
        settings.put("customPaths", this.applicationProperties.getSystem().getCustomPaths());
        settings.put("tempFileManagement", this.applicationProperties.getSystem().getTempFileManagement());
        return ResponseEntity.ok(settings);
    }

    @PostMapping(value={"/admin/settings/advanced"})
    @Hidden
    public ResponseEntity<String> updateAdvancedSettings(@RequestBody Map<String, Object> settings) throws IOException {
        if (settings.containsKey("enableAlphaFunctionality")) {
            GeneralUtils.saveKeyToSettings((String)"system.enableAlphaFunctionality", (Object)settings.get("enableAlphaFunctionality"));
            this.applicationProperties.getSystem().setEnableAlphaFunctionality((Boolean)settings.get("enableAlphaFunctionality"));
        }
        if (settings.containsKey("maxDPI")) {
            GeneralUtils.saveKeyToSettings((String)"system.maxDPI", (Object)settings.get("maxDPI"));
            this.applicationProperties.getSystem().setMaxDPI(((Integer)settings.get("maxDPI")).intValue());
        }
        if (settings.containsKey("enableUrlToPDF")) {
            GeneralUtils.saveKeyToSettings((String)"system.enableUrlToPDF", (Object)settings.get("enableUrlToPDF"));
            this.applicationProperties.getSystem().setEnableUrlToPDF((Boolean)settings.get("enableUrlToPDF"));
        }
        return ResponseEntity.ok((Object)"Advanced settings updated. Restart required for changes to take effect.");
    }

    @Generated
    public SettingsController(ApplicationProperties applicationProperties, EndpointConfiguration endpointConfiguration) {
        this.applicationProperties = applicationProperties;
        this.endpointConfiguration = endpointConfiguration;
    }
}

