/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.controller.api.RearrangePagesPDFController;
import stirling.software.SPDF.model.SortTypes;
import stirling.software.SPDF.model.api.PDFWithPageNums;
import stirling.software.SPDF.model.api.general.RearrangePagesRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class RearrangePagesPDFController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RearrangePagesPDFController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/remove-pages"})
    @StandardPdfResponse
    @Operation(summary="Remove pages from a PDF file", description="This endpoint removes specified pages from a given PDF file. Users can provide a comma-separated list of page numbers or ranges to delete. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> deletePages(@ModelAttribute PDFWithPageNums request) throws IOException {
        MultipartFile pdfFile = request.getFileInput();
        String pagesToDelete = request.getPageNumbers();
        PDDocument document = this.pdfDocumentFactory.load(pdfFile);
        String[] pageOrderArr = pagesToDelete.split(",");
        List pagesToRemove = GeneralUtils.parsePageList((String[])pageOrderArr, (int)document.getNumberOfPages(), (boolean)false);
        Collections.sort(pagesToRemove);
        for (int i = pagesToRemove.size() - 1; i >= 0; --i) {
            int pageIndex = (Integer)pagesToRemove.get(i);
            document.removePage(pageIndex);
        }
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_removed_pages.pdf"));
    }

    private List<Integer> removeFirst(int totalPages) {
        if (totalPages <= 1) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = 2; i <= totalPages; ++i) {
            newPageOrder.add(i - 1);
        }
        return newPageOrder;
    }

    private List<Integer> removeLast(int totalPages) {
        if (totalPages <= 1) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = 1; i < totalPages; ++i) {
            newPageOrder.add(i - 1);
        }
        return newPageOrder;
    }

    private List<Integer> removeFirstAndLast(int totalPages) {
        if (totalPages <= 2) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = 2; i < totalPages; ++i) {
            newPageOrder.add(i - 1);
        }
        return newPageOrder;
    }

    private List<Integer> reverseOrder(int totalPages) {
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = totalPages; i >= 1; --i) {
            newPageOrder.add(i - 1);
        }
        return newPageOrder;
    }

    private List<Integer> duplexSort(int totalPages) {
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        int half = (totalPages + 1) / 2;
        for (int i = 1; i <= half; ++i) {
            newPageOrder.add(i - 1);
            if (i > totalPages - half) continue;
            newPageOrder.add(totalPages - i);
        }
        return newPageOrder;
    }

    private List<Integer> bookletSort(int totalPages) {
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = 0; i < totalPages / 2; ++i) {
            newPageOrder.add(i);
            newPageOrder.add(totalPages - i - 1);
        }
        return newPageOrder;
    }

    private List<Integer> sideStitchBooklet(int totalPages) {
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (int i = 0; i < (totalPages + 3) / 4; ++i) {
            int begin = i * 4;
            newPageOrder.add(Math.min(begin + 3, totalPages - 1));
            newPageOrder.add(Math.min(begin, totalPages - 1));
            newPageOrder.add(Math.min(begin + 1, totalPages - 1));
            newPageOrder.add(Math.min(begin + 2, totalPages - 1));
        }
        return newPageOrder;
    }

    private List<Integer> oddEvenSplit(int totalPages) {
        int i;
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        for (i = 1; i <= totalPages; i += 2) {
            newPageOrder.add(i - 1);
        }
        for (i = 2; i <= totalPages; i += 2) {
            newPageOrder.add(i - 1);
        }
        return newPageOrder;
    }

    List<Integer> oddEvenMerge(int totalPages) {
        ArrayList<Integer> newPageOrderZeroBased = new ArrayList<Integer>();
        int numberOfOddPages = (totalPages + 1) / 2;
        for (int oneBasedIndex = 1; oneBasedIndex < numberOfOddPages + 1; ++oneBasedIndex) {
            newPageOrderZeroBased.add(oneBasedIndex - 1);
            if (numberOfOddPages + oneBasedIndex > totalPages) continue;
            newPageOrderZeroBased.add(numberOfOddPages + oneBasedIndex - 1);
        }
        return newPageOrderZeroBased;
    }

    private List<Integer> duplicate(int totalPages, String pageOrder) {
        int duplicateCount;
        ArrayList<Integer> newPageOrder = new ArrayList<Integer>();
        try {
            duplicateCount = pageOrder != null && !pageOrder.isEmpty() ? Integer.parseInt(pageOrder.trim()) : 2;
        }
        catch (NumberFormatException e) {
            log.error("Invalid duplicate count specified", (Throwable)e);
            duplicateCount = 2;
        }
        if (duplicateCount < 1) {
            duplicateCount = 2;
        }
        for (int pageNum = 0; pageNum < totalPages; ++pageNum) {
            for (int dupCount = 0; dupCount < duplicateCount; ++dupCount) {
                newPageOrder.add(pageNum);
            }
        }
        return newPageOrder;
    }

    private List<Integer> processSortTypes(String sortTypes, int totalPages, String pageOrder) {
        try {
            SortTypes mode = SortTypes.valueOf((String)sortTypes.toUpperCase());
            return switch (1.$SwitchMap$stirling$software$SPDF$model$SortTypes[mode.ordinal()]) {
                case 1 -> this.reverseOrder(totalPages);
                case 2 -> this.duplexSort(totalPages);
                case 3 -> this.bookletSort(totalPages);
                case 4 -> this.sideStitchBooklet(totalPages);
                case 5 -> this.oddEvenSplit(totalPages);
                case 6 -> this.oddEvenMerge(totalPages);
                case 7 -> this.removeFirst(totalPages);
                case 8 -> this.removeLast(totalPages);
                case 9 -> this.removeFirstAndLast(totalPages);
                case 10 -> this.duplicate(totalPages, pageOrder);
                default -> throw new IllegalArgumentException("Unsupported custom mode");
            };
        }
        catch (IllegalArgumentException e) {
            log.error("Unsupported custom mode", (Throwable)e);
            return null;
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/rearrange-pages"})
    @StandardPdfResponse
    @Operation(summary="Rearrange pages in a PDF file", description="This endpoint rearranges pages in a given PDF file based on the specified page order or custom mode. Users can provide a page order as a comma-separated list of page numbers or page ranges, or a custom mode. Input:PDF Output:PDF")
    public ResponseEntity<byte[]> rearrangePages(@ModelAttribute RearrangePagesRequest request) throws IOException {
        MultipartFile pdfFile = request.getFileInput();
        String pageOrder = request.getPageNumbers();
        String sortType = request.getCustomMode();
        try {
            int i;
            PDDocument document = this.pdfDocumentFactory.load(pdfFile);
            String[] pageOrderArr = pageOrder != null ? pageOrder.split(",") : new String[]{};
            int totalPages = document.getNumberOfPages();
            List newPageOrder = sortType != null && !sortType.isEmpty() && !"custom".equals(sortType.toLowerCase()) ? this.processSortTypes(sortType, totalPages, pageOrder) : GeneralUtils.parsePageList((String[])pageOrderArr, (int)totalPages, (boolean)false);
            log.info("newPageOrder = {}", (Object)newPageOrder);
            log.info("totalPages = {}", (Object)totalPages);
            ArrayList<PDPage> newPages = new ArrayList<PDPage>();
            for (i = 0; i < newPageOrder.size(); ++i) {
                newPages.add(document.getPage(((Integer)newPageOrder.get(i)).intValue()));
            }
            for (i = document.getNumberOfPages() - 1; i >= 0; --i) {
                document.removePage(i);
            }
            for (PDPage page : newPages) {
                document.addPage(page);
            }
            return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_rearranged.pdf"));
        }
        catch (IOException e) {
            ExceptionUtils.logException((String)"document rearrangement", (Exception)e);
            throw e;
        }
    }

    @Generated
    public RearrangePagesPDFController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

