/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.CropPdfForm;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class CropController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CropController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final EndpointConfiguration endpointConfiguration;

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    @AutoJobPostMapping(value={"/crop"}, consumes={"multipart/form-data"})
    @StandardPdfResponse
    @Operation(summary="Crops a PDF document", description="This operation takes an input PDF file and crops it according to the given coordinates. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> cropPdf(@ModelAttribute CropPdfForm request) throws IOException {
        if (request.isRemoveDataOutsideCrop() && this.isGhostscriptEnabled()) {
            return this.cropWithGhostscript(request);
        }
        if (request.isRemoveDataOutsideCrop()) {
            log.warn("Ghostscript not available - 'removeDataOutsideCrop' option requires Ghostscript. Falling back to visual crop only.");
        }
        return this.cropWithPDFBox(request);
    }

    private ResponseEntity<byte[]> cropWithPDFBox(@ModelAttribute CropPdfForm request) throws IOException {
        PDDocument sourceDocument = this.pdfDocumentFactory.load((PDFFile)request);
        PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
        int totalPages = sourceDocument.getNumberOfPages();
        LayerUtility layerUtility = new LayerUtility(newDocument);
        for (int i = 0; i < totalPages; ++i) {
            PDPage sourcePage = sourceDocument.getPage(i);
            PDPage newPage = new PDPage(sourcePage.getMediaBox());
            newDocument.addPage(newPage);
            PDPageContentStream contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.OVERWRITE, true, true);
            PDFormXObject formXObject = layerUtility.importPageAsForm(sourceDocument, i);
            contentStream.saveGraphicsState();
            contentStream.addRect(request.getX(), request.getY(), request.getWidth(), request.getHeight());
            contentStream.clip();
            contentStream.drawForm(formXObject);
            contentStream.restoreGraphicsState();
            contentStream.close();
            newPage.setMediaBox(new PDRectangle(request.getX(), request.getY(), request.getWidth(), request.getHeight()));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        newDocument.save((OutputStream)baos);
        newDocument.close();
        sourceDocument.close();
        byte[] pdfContent = baos.toByteArray();
        return WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_cropped.pdf"));
    }

    private ResponseEntity<byte[]> cropWithGhostscript(@ModelAttribute CropPdfForm request) throws IOException {
        PDDocument sourceDocument = this.pdfDocumentFactory.load((PDFFile)request);
        for (int i = 0; i < sourceDocument.getNumberOfPages(); ++i) {
            PDPage page = sourceDocument.getPage(i);
            PDRectangle cropBox = new PDRectangle(request.getX(), request.getY(), request.getWidth(), request.getHeight());
            page.setCropBox(cropBox);
        }
        Path tempInputFile = Files.createTempFile("crop_input", ".pdf", new FileAttribute[0]);
        Path tempOutputFile = Files.createTempFile("crop_output", ".pdf", new FileAttribute[0]);
        try {
            sourceDocument.save(tempInputFile.toFile());
            sourceDocument.close();
            ProcessExecutor processExecutor = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT);
            List<String> command = List.of("gs", "-sDEVICE=pdfwrite", "-dUseCropBox", "-o", tempOutputFile.toString(), tempInputFile.toString());
            processExecutor.runCommandWithOutputHandling(command);
            byte[] pdfContent = Files.readAllBytes(tempOutputFile);
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfContent, (String)(request.getFileInput().getOriginalFilename().replaceFirst("[.][^.]+$", "") + "_cropped.pdf"));
            return responseEntity;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Ghostscript processing was interrupted", e);
        }
        finally {
            try {
                Files.deleteIfExists(tempInputFile);
                Files.deleteIfExists(tempOutputFile);
            }
            catch (IOException e) {
                log.debug("Failed to delete temporary files", (Throwable)e);
            }
        }
    }

    @Generated
    public CropController(CustomPDFDocumentFactory pdfDocumentFactory, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.endpointConfiguration = endpointConfiguration;
    }
}

