/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.util.RegexPatternUtils;

@Configuration
public class ExternalAppDepConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalAppDepConfig.class);
    private final EndpointConfiguration endpointConfiguration;
    private final String weasyprintPath;
    private final String unoconvPath;
    private final Map<String, List<String>> commandToGroupMapping;
    private volatile boolean dependenciesChecked = false;

    public ExternalAppDepConfig(EndpointConfiguration endpointConfiguration, RuntimePathConfig runtimePathConfig) {
        this.endpointConfiguration = endpointConfiguration;
        this.weasyprintPath = runtimePathConfig.getWeasyPrintPath();
        this.unoconvPath = runtimePathConfig.getUnoConvertPath();
        this.commandToGroupMapping = new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean isCommandAvailable(String command) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                processBuilder.command("where", command);
            } else {
                processBuilder.command("which", command);
            }
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            log.debug("Error checking for command {}: {}", (Object)command, (Object)e.getMessage());
            return false;
        }
    }

    private List<String> getAffectedFeatures(String group) {
        return this.endpointConfiguration.getEndpointsForGroup(group).stream().map(endpoint -> this.formatEndpointAsFeature(endpoint)).toList();
    }

    private String formatEndpointAsFeature(String endpoint) {
        String feature = endpoint.replace("-", " ").replace("pdf", "PDF").replace("img", "image");
        return Arrays.stream(RegexPatternUtils.getInstance().getWordSplitPattern().split(feature)).map(word -> this.capitalizeWord(word)).collect(Collectors.joining(" "));
    }

    private String capitalizeWord(String word) {
        if (word.isEmpty()) {
            return word;
        }
        if ("pdf".equalsIgnoreCase(word)) {
            return "PDF";
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
    }

    private void checkDependencyAndDisableGroup(String command) {
        List affectedGroups;
        boolean isAvailable = this.isCommandAvailable(command);
        if (!isAvailable && (affectedGroups = (List)this.commandToGroupMapping.get(command)) != null) {
            for (String group : affectedGroups) {
                List affectedFeatures = this.getAffectedFeatures(group);
                this.endpointConfiguration.disableGroup(group, EndpointConfiguration.DisableReason.DEPENDENCY);
                log.warn("Missing dependency: {} - Disabling group: {} (Affected features: {})", new Object[]{command, group, !affectedFeatures.isEmpty() ? String.join((CharSequence)", ", affectedFeatures) : "unknown"});
            }
        }
    }

    public boolean isDependenciesChecked() {
        return this.dependenciesChecked;
    }

    @PostConstruct
    public void checkDependencies() {
        boolean pythonAvailable;
        this.checkDependencyAndDisableGroup("gs");
        this.checkDependencyAndDisableGroup("ocrmypdf");
        this.checkDependencyAndDisableGroup("tesseract");
        this.checkDependencyAndDisableGroup("soffice");
        this.checkDependencyAndDisableGroup("qpdf");
        this.checkDependencyAndDisableGroup(this.weasyprintPath);
        this.checkDependencyAndDisableGroup("pdftohtml");
        this.checkDependencyAndDisableGroup(this.unoconvPath);
        this.checkDependencyAndDisableGroup("rar");
        boolean bl = pythonAvailable = this.isCommandAvailable("python3") || this.isCommandAvailable("python");
        if (!pythonAvailable) {
            List pythonFeatures = this.getAffectedFeatures("Python");
            List openCVFeatures = this.getAffectedFeatures("OpenCV");
            this.endpointConfiguration.disableGroup("Python", EndpointConfiguration.DisableReason.DEPENDENCY);
            this.endpointConfiguration.disableGroup("OpenCV", EndpointConfiguration.DisableReason.DEPENDENCY);
            log.warn("Missing dependency: Python - Disabling Python features: {} and OpenCV features: {}", (Object)String.join((CharSequence)", ", pythonFeatures), (Object)String.join((CharSequence)", ", openCVFeatures));
        } else {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    processBuilder.command("python", "-c", "import cv2");
                } else {
                    processBuilder.command("python3", "-c", "import cv2");
                }
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    List openCVFeatures = this.getAffectedFeatures("OpenCV");
                    this.endpointConfiguration.disableGroup("OpenCV", EndpointConfiguration.DisableReason.DEPENDENCY);
                    log.warn("OpenCV not available in Python - Disabling OpenCV features: {}", (Object)String.join((CharSequence)", ", openCVFeatures));
                }
            }
            catch (Exception e) {
                List openCVFeatures = this.getAffectedFeatures("OpenCV");
                this.endpointConfiguration.disableGroup("OpenCV", EndpointConfiguration.DisableReason.DEPENDENCY);
                log.warn("Error checking OpenCV: {} - Disabling OpenCV features: {}", (Object)e.getMessage(), (Object)String.join((CharSequence)", ", openCVFeatures));
            }
        }
        this.endpointConfiguration.logDisabledEndpointsSummary();
        this.dependenciesChecked = true;
        log.info("Dependency checks completed");
    }
}

