/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import sun.misc.Unsafe;

final class ByteBufferWindow
extends ByteWindow {
    private static final Unsafe UNSAFE;
    private final ByteBuffer buffer;
    private volatile boolean closed;

    ByteBufferWindow(PackFile pack, long o, ByteBuffer b) {
        super(pack, o, b.capacity());
        this.buffer = b;
    }

    @Override
    protected int copy(int p, byte[] b, int o, int n) {
        this.assertOpen();
        ByteBuffer s = this.buffer.slice();
        s.position(p);
        n = Math.min(s.remaining(), n);
        s.get(b, o, n);
        return n;
    }

    @Override
    void write(PackOutputStream out, long pos, int cnt) throws IOException {
        this.assertOpen();
        ByteBuffer s = this.buffer.slice();
        s.position((int)(pos - this.start));
        while (0 < cnt) {
            byte[] buf = out.getCopyBuffer();
            int n = Math.min(cnt, buf.length);
            s.get(buf, 0, n);
            out.write(buf, 0, n);
            cnt -= n;
        }
    }

    @Override
    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        this.assertOpen();
        ByteBuffer s = this.buffer.slice();
        s.position(pos);
        byte[] tmp = new byte[Math.min(s.remaining(), 512)];
        s.get(tmp, 0, tmp.length);
        inf.setInput(tmp, 0, tmp.length);
        return tmp.length;
    }

    public void close() {
        this.closed = true;
        UNSAFE.invokeCleaner(this.buffer);
    }

    private void assertOpen() {
        if (this.closed) {
            throw new RuntimeException();
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

