/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head = subRepo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return Repository.shortenRefName(head.getLeaf().getName());
        }
        return null;
    }

    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
        try {
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, String> synced = new HashMap<String, String>();
            StoredConfig config = this.repo.getConfig();
            while (generator.next()) {
                String remoteUrl = generator.getRemoteUrl();
                if (remoteUrl == null) continue;
                String path = generator.getPath();
                config.setString("submodule", path, "url", remoteUrl);
                synced.put(path, remoteUrl);
                Repository subRepo = generator.getRepository();
                try {
                    if (subRepo == null) continue;
                    StoredConfig subConfig = subRepo.getConfig();
                    String branch = this.getHeadBranch(subRepo);
                    String remote = null;
                    if (branch != null) {
                        remote = subConfig.getString("branch", branch, "remote");
                    }
                    if (remote == null) {
                        remote = "origin";
                    }
                    subConfig.setString("remote", remote, "url", remoteUrl);
                    subConfig.save();
                }
                finally {
                    if (subRepo == null) continue;
                    subRepo.close();
                }
            }
            if (!synced.isEmpty()) {
                config.save();
            }
            HashMap<String, String> hashMap = synced;
            if (generator != null) {
                generator.close();
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                if (generator != null) {
                    try {
                        generator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | ConfigInvalidException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
    }
}

