/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.channels.BufferedChannelKt;
import kotlinx.coroutines.channels.ChannelSegment;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.SystemPropsKt;

public final class BufferedChannelKt {
    private static final ChannelSegment<Object> NULL_SEGMENT = new ChannelSegment(-1L, null, null, 0);
    public static final int SEGMENT_SIZE = SystemPropsKt.systemProp$default("kotlinx.coroutines.bufferedChannel.segmentSize", 32, 0, 0, 12, null);
    private static final int EXPAND_BUFFER_COMPLETION_WAIT_ITERATIONS = SystemPropsKt.systemProp$default("kotlinx.coroutines.bufferedChannel.expandBufferCompletionWaitIterations", 10000, 0, 0, 12, null);
    public static final Symbol BUFFERED = new Symbol("BUFFERED");
    private static final Symbol IN_BUFFER = new Symbol("SHOULD_BUFFER");
    private static final Symbol RESUMING_BY_RCV = new Symbol("S_RESUMING_BY_RCV");
    private static final Symbol RESUMING_BY_EB = new Symbol("RESUMING_BY_EB");
    private static final Symbol POISONED = new Symbol("POISONED");
    private static final Symbol DONE_RCV = new Symbol("DONE_RCV");
    private static final Symbol INTERRUPTED_SEND = new Symbol("INTERRUPTED_SEND");
    private static final Symbol INTERRUPTED_RCV = new Symbol("INTERRUPTED_RCV");
    private static final Symbol CHANNEL_CLOSED = new Symbol("CHANNEL_CLOSED");
    private static final Symbol SUSPEND = new Symbol("SUSPEND");
    private static final Symbol SUSPEND_NO_WAITER = new Symbol("SUSPEND_NO_WAITER");
    private static final Symbol FAILED = new Symbol("FAILED");
    private static final Symbol NO_RECEIVE_RESULT = new Symbol("NO_RECEIVE_RESULT");
    private static final Symbol CLOSE_HANDLER_CLOSED = new Symbol("CLOSE_HANDLER_CLOSED");
    private static final Symbol CLOSE_HANDLER_INVOKED = new Symbol("CLOSE_HANDLER_INVOKED");
    private static final Symbol NO_CLOSE_CAUSE = new Symbol("NO_CLOSE_CAUSE");

    public static final <E> KFunction<ChannelSegment<E>> createSegmentFunction() {
        return createSegmentFunction.1.INSTANCE;
    }

    private static final <E> ChannelSegment<E> createSegment(long id, ChannelSegment<E> prev) {
        return new ChannelSegment<E>(id, prev, prev.getChannel(), 0);
    }

    private static final <T> boolean tryResume0(CancellableContinuation<? super T> $this$tryResume0, T value, Function1<? super Throwable, Unit> onCancellation) {
        boolean bl;
        Object token = $this$tryResume0.tryResume(value, null, onCancellation);
        boolean bl2 = false;
        if (token != null) {
            $this$tryResume0.completeResume(token);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean tryResume0$default(CancellableContinuation cancellableContinuation, Object object, Function1 function1, int n, Object object2) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return BufferedChannelKt.tryResume0(cancellableContinuation, object, function1);
    }

    private static final long initialBufferEnd(int capacity) {
        long l;
        switch (capacity) {
            case 0: {
                l = 0L;
                break;
            }
            case 0x7FFFFFFF: {
                l = Long.MAX_VALUE;
                break;
            }
            default: {
                l = capacity;
            }
        }
        return l;
    }

    public static final Symbol getCHANNEL_CLOSED() {
        return CHANNEL_CLOSED;
    }

    private static final long constructSendersAndCloseStatus(long counter, int closeStatus) {
        return ((long)closeStatus << 60) + counter;
    }

    private static final long constructEBCompletedAndPauseFlag(long counter, boolean pauseEB) {
        return (pauseEB ? 0x4000000000000000L : 0L) + counter;
    }

    public static final /* synthetic */ long access$initialBufferEnd(int capacity) {
        return BufferedChannelKt.initialBufferEnd(capacity);
    }

    public static final /* synthetic */ ChannelSegment access$getNULL_SEGMENT$p() {
        return NULL_SEGMENT;
    }

    public static final /* synthetic */ Symbol access$getNO_CLOSE_CAUSE$p() {
        return NO_CLOSE_CAUSE;
    }

    public static final /* synthetic */ Symbol access$getINTERRUPTED_SEND$p() {
        return INTERRUPTED_SEND;
    }

    public static final /* synthetic */ Symbol access$getDONE_RCV$p() {
        return DONE_RCV;
    }

    public static final /* synthetic */ Symbol access$getINTERRUPTED_RCV$p() {
        return INTERRUPTED_RCV;
    }

    public static final /* synthetic */ Symbol access$getIN_BUFFER$p() {
        return IN_BUFFER;
    }

    public static final /* synthetic */ Symbol access$getPOISONED$p() {
        return POISONED;
    }

    public static final /* synthetic */ boolean access$tryResume0(CancellableContinuation $receiver, Object value, Function1 onCancellation) {
        return BufferedChannelKt.tryResume0($receiver, value, onCancellation);
    }

    public static final /* synthetic */ Symbol access$getFAILED$p() {
        return FAILED;
    }

    public static final /* synthetic */ Symbol access$getSUSPEND$p() {
        return SUSPEND;
    }

    public static final /* synthetic */ Symbol access$getSUSPEND_NO_WAITER$p() {
        return SUSPEND_NO_WAITER;
    }

    public static final /* synthetic */ Symbol access$getRESUMING_BY_EB$p() {
        return RESUMING_BY_EB;
    }

    public static final /* synthetic */ Symbol access$getRESUMING_BY_RCV$p() {
        return RESUMING_BY_RCV;
    }

    public static final /* synthetic */ int access$getEXPAND_BUFFER_COMPLETION_WAIT_ITERATIONS$p() {
        return EXPAND_BUFFER_COMPLETION_WAIT_ITERATIONS;
    }

    public static final /* synthetic */ long access$constructEBCompletedAndPauseFlag(long counter, boolean pauseEB) {
        return BufferedChannelKt.constructEBCompletedAndPauseFlag(counter, pauseEB);
    }

    public static final /* synthetic */ Symbol access$getNO_RECEIVE_RESULT$p() {
        return NO_RECEIVE_RESULT;
    }

    public static final /* synthetic */ Symbol access$getCLOSE_HANDLER_CLOSED$p() {
        return CLOSE_HANDLER_CLOSED;
    }

    public static final /* synthetic */ Symbol access$getCLOSE_HANDLER_INVOKED$p() {
        return CLOSE_HANDLER_INVOKED;
    }

    public static final /* synthetic */ long access$constructSendersAndCloseStatus(long counter, int closeStatus) {
        return BufferedChannelKt.constructSendersAndCloseStatus(counter, closeStatus);
    }

    public static final /* synthetic */ ChannelSegment access$createSegment(long id, ChannelSegment prev) {
        return BufferedChannelKt.createSegment(id, prev);
    }
}

