/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public abstract class BooleanExpression<T> {
    private BooleanExpression() {
    }

    public /* synthetic */ BooleanExpression(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class And<T>
    extends BooleanExpression<T> {
        private final Set<BooleanExpression<T>> operands;

        public final Set<BooleanExpression<T>> getOperands() {
            return this.operands;
        }

        public String toString() {
            return "And(operands=" + this.operands + ')';
        }

        public int hashCode() {
            return ((Object)this.operands).hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof And)) {
                return false;
            }
            And and = (And)other;
            return Intrinsics.areEqual(this.operands, and.operands);
        }
    }

    public static final class Element<T>
    extends BooleanExpression<T> {
        private final T value;

        public Element(T value) {
            Intrinsics.checkNotNullParameter(value, "value");
            super(null);
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        public String toString() {
            return "Element(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element element = (Element)other;
            return Intrinsics.areEqual(this.value, element.value);
        }
    }

    public static final class False
    extends BooleanExpression {
        public static final False INSTANCE = new False();

        private False() {
            super(null);
        }
    }

    public static final class Not<T>
    extends BooleanExpression<T> {
        private final BooleanExpression<T> operand;

        public final BooleanExpression<T> getOperand() {
            return this.operand;
        }

        public String toString() {
            return "Not(operand=" + this.operand + ')';
        }

        public int hashCode() {
            return this.operand.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Not)) {
                return false;
            }
            Not not = (Not)other;
            return Intrinsics.areEqual(this.operand, not.operand);
        }
    }

    public static final class Or<T>
    extends BooleanExpression<T> {
        private final Set<BooleanExpression<T>> operands;

        public final Set<BooleanExpression<T>> getOperands() {
            return this.operands;
        }

        public String toString() {
            return CollectionsKt.joinToString$default(this.operands, " | ", null, null, 0, null, null, 62, null);
        }

        public int hashCode() {
            return ((Object)this.operands).hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Or)) {
                return false;
            }
            Or or = (Or)other;
            return Intrinsics.areEqual(this.operands, or.operands);
        }
    }

    public static final class True
    extends BooleanExpression {
        public static final True INSTANCE = new True();

        private True() {
            super(null);
        }
    }
}

