/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;

class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    private final JsonObject value;
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(Json json, JsonObject value, String polymorphicDiscriminator, SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(value, "value");
        super(json, value, polymorphicDiscriminator, null);
        this.value = value;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor, int index, String tag) {
        boolean bl;
        boolean it;
        Json $this$tryCoerceValue_u24default$iv = this.getJson();
        boolean $i$f$tryCoerceValue = false;
        boolean isOptional$iv = descriptor.isElementOptional(index);
        SerialDescriptor elementDescriptor$iv = descriptor.getElementDescriptor(index);
        if (isOptional$iv && !elementDescriptor$iv.isNullable()) {
            it = true;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return false;
            }
        }
        boolean bl2 = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) return false;
        String string = JsonElementKt.getContentOrNull(jsonPrimitive);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue_u24default$iv, enumValue$iv);
        boolean coerceToNull$iv = !$this$tryCoerceValue_u24default$iv.getConfiguration().getExplicitNulls() && elementDescriptor$iv.isNullable();
        if (enumIndex$iv != -3) return false;
        if (isOptional$iv) return true;
        if (!coerceToNull$iv) return false;
        return true;
    }

    @Override
    public int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        while (this.position < descriptor.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor, index, name)) continue;
            return index;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor descriptor, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor.isElementOptional(index) && descriptor.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @Override
    protected String elementName(SerialDescriptor descriptor, int index) {
        Object v1;
        String baseName;
        JsonNamingStrategy strategy;
        block6: {
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
            baseName = descriptor.getElementName(index);
            if (strategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return baseName;
                }
                if (this.getValue().keySet().contains(baseName)) {
                    return baseName;
                }
            }
            Map<String, Integer> deserializationNamesMap = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor);
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = deserializationNamesMap.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        JsonNamingStrategy jsonNamingStrategy = strategy;
        String fallbackName = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson(descriptor, index, baseName) : null;
        String string2 = fallbackName;
        if (string2 == null) {
            string2 = baseName;
        }
        return string2;
    }

    @Override
    protected JsonElement currentElement(String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return (JsonElement)MapsKt.getValue(this.getValue(), tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (descriptor == this.polyDescriptor) {
            void value$iv;
            AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
            JsonElement jsonElement = this.currentObject();
            SerialDescriptor descriptor$iv = this.polyDescriptor;
            boolean $i$f$cast = false;
            String serialName$iv$iv = descriptor$iv.getSerialName();
            boolean $i$f$cast2 = false;
            if (!(value$iv instanceof JsonObject)) {
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = AbstractJsonTreeDecoder.access$renderTagStack((AbstractJsonTreeDecoder)this_$iv);
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv.toString());
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)value$iv, this.getPolymorphicDiscriminator(), this.polyDescriptor);
        }
        return super.beginStructure(descriptor);
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Set<String> set;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
        if (strategy == null && !this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor);
        } else if (strategy != null) {
            set = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor).keySet();
        } else {
            Set<String> set2 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor);
            Map<String, Integer> map2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set<String> set3 = map2 != null ? map2.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus(set2, (Iterable)set3);
        }
        Set<String> names = set;
        for (String key : this.getValue().keySet()) {
            if (names.contains(key) || Intrinsics.areEqual(key, this.getPolymorphicDiscriminator())) continue;
            throw JsonExceptionsKt.UnknownKeyException(key, this.getValue().toString());
        }
    }
}

