/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;

public final class NothingSerialDescriptor
implements SerialDescriptor {
    public static final NothingSerialDescriptor INSTANCE = new NothingSerialDescriptor();
    private static final SerialKind kind = StructureKind.OBJECT.INSTANCE;
    private static final String serialName = "kotlin.Nothing";

    private NothingSerialDescriptor() {
    }

    @Override
    public SerialKind getKind() {
        return kind;
    }

    @Override
    public String getSerialName() {
        return serialName;
    }

    @Override
    public int getElementsCount() {
        return 0;
    }

    @Override
    public String getElementName(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public int getElementIndex(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean isElementOptional(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public SerialDescriptor getElementDescriptor(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public List<Annotation> getElementAnnotations(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    public String toString() {
        return "NothingSerialDescriptor";
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.getSerialName().hashCode() + 31 * this.getKind().hashCode();
    }

    private final Void error() {
        throw new IllegalStateException("Descriptor for type `kotlin.Nothing` does not have elements");
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return SerialDescriptor.DefaultImpls.getAnnotations(this);
    }
}

