/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.LinkedHashMapClassDesc;
import kotlinx.serialization.internal.MapLikeSerializer;

public final class LinkedHashMapSerializer<K, V>
extends MapLikeSerializer<K, V, Map<K, ? extends V>, LinkedHashMap<K, V>> {
    private final SerialDescriptor descriptor;

    public LinkedHashMapSerializer(KSerializer<K> kSerializer, KSerializer<V> vSerializer) {
        Intrinsics.checkNotNullParameter(kSerializer, "kSerializer");
        Intrinsics.checkNotNullParameter(vSerializer, "vSerializer");
        super(kSerializer, vSerializer, null);
        this.descriptor = new LinkedHashMapClassDesc(kSerializer.getDescriptor(), vSerializer.getDescriptor());
    }

    @Override
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected int collectionSize(Map<K, ? extends V> $this$collectionSize) {
        Intrinsics.checkNotNullParameter($this$collectionSize, "<this>");
        return $this$collectionSize.size();
    }

    @Override
    protected Iterator<Map.Entry<K, V>> collectionIterator(Map<K, ? extends V> $this$collectionIterator) {
        Intrinsics.checkNotNullParameter($this$collectionIterator, "<this>");
        return $this$collectionIterator.entrySet().iterator();
    }

    @Override
    protected LinkedHashMap<K, V> builder() {
        return new LinkedHashMap();
    }

    @Override
    protected int builderSize(LinkedHashMap<K, V> $this$builderSize) {
        Intrinsics.checkNotNullParameter($this$builderSize, "<this>");
        return $this$builderSize.size() * 2;
    }

    @Override
    protected Map<K, V> toResult(LinkedHashMap<K, V> $this$toResult) {
        Intrinsics.checkNotNullParameter($this$toResult, "<this>");
        return $this$toResult;
    }

    @Override
    protected LinkedHashMap<K, V> toBuilder(Map<K, ? extends V> $this$toBuilder) {
        Intrinsics.checkNotNullParameter($this$toBuilder, "<this>");
        LinkedHashMap linkedHashMap = $this$toBuilder instanceof LinkedHashMap ? (LinkedHashMap)$this$toBuilder : null;
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<K, V>($this$toBuilder);
        }
        return linkedHashMap;
    }

    @Override
    protected void checkCapacity(LinkedHashMap<K, V> $this$checkCapacity, int size) {
        Intrinsics.checkNotNullParameter($this$checkCapacity, "<this>");
    }
}

