/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v1.tokens;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.snakeyaml.engine.v1.exceptions.Mark;
import org.snakeyaml.engine.v1.exceptions.YamlEngineException;
import org.snakeyaml.engine.v1.tokens.Token;

public final class DirectiveToken<T>
extends Token {
    private final String name;
    private final Optional<List<T>> value;
    public static final String YAML_DIRECTIVE = "YAML";
    public static final String TAG_DIRECTIVE = "TAG";

    public DirectiveToken(String name, Optional<List<T>> value, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(startMark, endMark);
        this.name = name;
        Objects.requireNonNull(value);
        if (value.isPresent() && value.get().size() != 2) {
            throw new YamlEngineException("Two strings/integers must be provided instead of " + String.valueOf(value.get().size()));
        }
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<T>> getValue() {
        return this.value;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Directive;
    }
}

