/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GtkTargetEntry;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    int drag_motion_handler;
    int drag_leave_handler;
    int drag_data_received_handler;
    int drag_drop_handler;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback Drag_Motion = new Callback(DropTarget.class, "Drag_Motion", 5);
    static Callback Drag_Leave = new Callback(DropTarget.class, "Drag_Leave", 3);
    static Callback Drag_Data_Received = new Callback(DropTarget.class, "Drag_Data_Received", 7);
    static Callback Drag_Drop = new Callback(DropTarget.class, "Drag_Drop", 5);
    long dropController;

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (GTK.GTK4) {
            int actions = this.opToOsOp(style);
            this.dropController = GTK4.gtk_drop_target_async_new(0L, actions);
            GTK4.gtk_widget_add_controller(control.handle, this.dropController);
        } else {
            if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
                DND.error(2001);
            }
            if (control.getData("DropTarget") != null) {
                DND.error(2001);
            }
            control.setData("DropTarget", this);
            this.drag_motion_handler = OS.g_signal_connect(control.handle, OS.drag_motion, Drag_Motion.getAddress(), 0L);
            this.drag_leave_handler = OS.g_signal_connect(control.handle, OS.drag_leave, Drag_Leave.getAddress(), 0L);
            this.drag_data_received_handler = OS.g_signal_connect(control.handle, OS.drag_data_received, Drag_Data_Received.getAddress(), 0L);
            this.drag_drop_handler = OS.g_signal_connect(control.handle, OS.drag_drop, Drag_Drop.getAddress(), 0L);
            this.controlListener = event -> {
                if (!this.isDisposed()) {
                    this.dispose();
                }
            };
            control.addListener(12, this.controlListener);
            this.addListener(12, event -> this.onDispose());
            Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
            if (effect instanceof DropTargetEffect) {
                this.dropEffect = (DropTargetEffect)effect;
            } else if (control instanceof Table) {
                this.dropEffect = new TableDropTargetEffect((Table)control);
            } else if (control instanceof Tree) {
                this.dropEffect = new TreeDropTargetEffect((Tree)control);
            }
            this.dragOverHeartbeat = () -> {
                Control control1 = this.control;
                if (control1 == null || control1.isDisposed() || this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < this.dragOverStart) {
                    delay = (int)(this.dragOverStart - time);
                } else {
                    this.dragOverEvent.time += 50;
                    int allowedOperations = this.dragOverEvent.operations;
                    TransferData[] allowedTypes = this.dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = this.dragOverEvent.widget;
                    event.x = this.dragOverEvent.x;
                    event.y = this.dragOverEvent.y;
                    event.time = this.dragOverEvent.time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = this.selectedDataType;
                    event.operations = this.dragOverEvent.operations;
                    event.detail = this.selectedOperation;
                    if (this.dropEffect != null) {
                        event.item = this.dropEffect.getItem(this.dragOverEvent.x, this.dragOverEvent.y);
                    }
                    this.selectedDataType = null;
                    this.selectedOperation = 0;
                    this.notifyListeners(2004, event);
                    if (event.dataType != null) {
                        for (int i = 0; i < allowedTypes.length; ++i) {
                            if (allowedTypes[i].type != event.dataType.type) continue;
                            this.selectedDataType = event.dataType;
                            break;
                        }
                    }
                    if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        this.selectedOperation = event.detail;
                    }
                }
                control1 = this.control;
                if (control1 == null || control1.isDisposed()) {
                    return;
                }
                control1.getDisplay().timerExec(delay, this.dragOverHeartbeat);
            };
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static long Drag_Data_Received(long widget, long context, long x, long y, long data, long info, long time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0L;
        }
        target.drag_data_received(widget, context, (int)x, (int)y, data, (int)info, (int)time);
        return 0L;
    }

    static long Drag_Drop(long widget, long context, long x, long y, long time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0L;
        }
        return target.drag_drop(widget, context, (int)x, (int)y, (int)time) ? 1L : 0L;
    }

    static long Drag_Leave(long widget, long context, long time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0L;
        }
        target.drag_leave(widget, context, (int)time);
        return 0L;
    }

    static long Drag_Motion(long widget, long context, long x, long y, long time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0L;
        }
        return target.drag_motion(widget, context, (int)x, (int)y, (int)time) ? 1L : 0L;
    }

    static DropTarget FindDropTarget(long handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    @Override
    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DropTarget.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    void drag_data_received(long widget, long context, int x, int y, long selection_data, int info, int time) {
        DNDEvent event = new DNDEvent();
        if (selection_data == 0L || !this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        int length = GTK3.gtk_selection_data_get_length(selection_data);
        int format = GTK3.gtk_selection_data_get_format(selection_data);
        long data = GTK3.gtk_selection_data_get_data(selection_data);
        long type = GTK3.gtk_selection_data_get_data_type(selection_data);
        if (data != 0L) {
            transferData.type = type;
            transferData.length = length;
            transferData.pValue = data;
            transferData.format = format;
            for (int i = 0; i < this.transferAgents.length; ++i) {
                Transfer transfer = this.transferAgents[i];
                if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                object = transfer.nativeToJava(transferData);
                break;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.detail = this.selectedOperation;
        event.dataType = transferData;
        event.data = object;
        this.selectedOperation = 0;
        this.notifyListeners(2006, event);
        if ((allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        OS.g_signal_stop_emission_by_name(widget, OS.drag_data_received);
        GTK3.gtk_drag_finish(context, this.selectedOperation != 0, this.selectedOperation == 2, time);
    }

    boolean drag_drop(long widget, long context, int x, int y, int time) {
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, event);
        if (event.dataType != null) {
            for (int i = 0; i < allowedDataTypes.length; ++i) {
                if (allowedDataTypes[i].type != event.dataType.type) continue;
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
        }
        if (this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        GTK3.gtk_drag_get_data(widget, context, this.selectedDataType.type, time);
        return true;
    }

    void drag_leave(long widget, long context, int time) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.detail = 0;
        this.notifyListeners(2003, event);
    }

    boolean drag_motion(long widget, long context, int x, int y, int time) {
        DNDEvent event;
        int oldKeyOperation = this.keyOperation;
        if (oldKeyOperation == -1 || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(context, x, y, time, event = new DNDEvent())) {
            this.keyOperation = -1;
            GDK.gdk_drag_status(context, 0, time);
            return false;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        if (oldKeyOperation == -1) {
            event.type = 2002;
        } else if (this.keyOperation == oldKeyOperation) {
            event.type = 2004;
            event.dataType = this.selectedDataType;
            event.detail = this.selectedOperation;
        } else {
            event.type = 2005;
            event.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, event);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(event.type, event);
        if (event.detail == 16) {
            int n = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        if (event.dataType != null) {
            for (int i = 0; i < allowedDataTypes.length; ++i) {
                if (allowedDataTypes[i].type != event.dataType.type) continue;
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
        }
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        switch (this.selectedOperation) {
            case 0: {
                GDK.gdk_drag_status(context, 0, time);
                break;
            }
            case 1: {
                GDK.gdk_drag_status(context, 2, time);
                break;
            }
            case 2: {
                GDK.gdk_drag_status(context, 4, time);
                break;
            }
            case 4: {
                GDK.gdk_drag_status(context, 8, time);
            }
        }
        if (oldKeyOperation == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        return (DropTargetListener[])this.getTypedListeners(2002, DropTargetListener.class).toArray(DropTargetListener[]::new);
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean shift;
        int[] state = new int[1];
        long pointer = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
        if (!GTK.GTK4) {
            long root = GDK.gdk_get_default_root_window();
            GDK.gdk_window_get_device_position(root, pointer, null, null, state);
        }
        boolean ctrl = (state[0] & 4) != 0;
        boolean bl = shift = (state[0] & 1) != 0;
        if (ctrl && shift) {
            return 4;
        }
        if (ctrl) {
            return 1;
        }
        if (shift) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_motion_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_leave_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_data_received_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            GTK3.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData("DropTarget", null);
        this.control = null;
        this.controlListener = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeTypedListener(2002, listener);
        this.removeTypedListener(2003, listener);
        this.removeTypedListener(2004, listener);
        this.removeTypedListener(2005, listener);
        this.removeTypedListener(2006, listener);
        this.removeTypedListener(2007, listener);
    }

    public void setTransfer(Transfer ... transferAgents) {
        if (GTK.GTK4) {
            this.transferAgents = transferAgents;
            long contentFormatsBuilder = GTK4.gdk_content_formats_builder_new();
            for (Transfer agent : transferAgents) {
                for (String typeName : agent.getTypeNames()) {
                    GTK4.gdk_content_formats_builder_add_mime_type(contentFormatsBuilder, Converter.javaStringToCString(typeName));
                }
            }
            GTK4.gtk_drop_target_async_set_formats(this.dropController, contentFormatsBuilder);
        } else {
            long entryHandle;
            if (transferAgents == null) {
                DND.error(4);
            }
            if (this.transferAgents.length != 0) {
                GTK3.gtk_drag_dest_unset(this.control.handle);
            }
            this.transferAgents = transferAgents;
            GtkTargetEntry[] targets = new GtkTargetEntry[]{};
            for (int i = 0; i < transferAgents.length; ++i) {
                Transfer transfer = transferAgents[i];
                if (transfer == null) continue;
                int[] typeIds = transfer.getTypeIds();
                String[] typeNames = transfer.getTypeNames();
                for (int j = 0; j < typeIds.length; ++j) {
                    GtkTargetEntry entry = new GtkTargetEntry();
                    byte[] buffer = Converter.wcsToMbcs(typeNames[j], true);
                    entry.target = OS.g_malloc(buffer.length);
                    C.memmove(entry.target, buffer, (long)buffer.length);
                    entry.info = typeIds[j];
                    GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                    System.arraycopy(targets, 0, newTargets, 0, targets.length);
                    newTargets[targets.length] = entry;
                    targets = newTargets;
                }
            }
            long pTargets = OS.g_malloc(targets.length * GtkTargetEntry.sizeof);
            for (int i = 0; i < targets.length; ++i) {
                GTK3.memmove(pTargets + (long)(i * GtkTargetEntry.sizeof), targets[i], (long)GtkTargetEntry.sizeof);
            }
            int actions = this.opToOsOp(this.getStyle());
            if (this.control instanceof Combo && (this.control.getStyle() & 8) == 0 && (entryHandle = GTK3.gtk_bin_get_child(this.control.handle)) != 0L) {
                GTK3.gtk_drag_dest_unset(entryHandle);
            }
            GTK3.gtk_drag_dest_set(this.control.handle, 0, pTargets, targets.length, actions);
            for (int i = 0; i < targets.length; ++i) {
                OS.g_free(targets[i].target);
            }
        }
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    boolean setEventData(long context, int x, int y, int time, DNDEvent event) {
        int operation;
        if (context == 0L) {
            return false;
        }
        long targets = GDK.gdk_drag_context_list_targets(context);
        int actions = GDK.gdk_drag_context_get_actions(context);
        if (targets == 0L) {
            return false;
        }
        int style = this.getStyle();
        int operations = this.osOpToOp(actions) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState();
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        TransferData[] dataTypes = new TransferData[]{};
        while (targets != 0L) {
            long pData = OS.g_list_data(targets);
            TransferData data = new TransferData();
            data.type = pData;
            for (int j = 0; j < this.transferAgents.length; ++j) {
                Transfer transfer = this.transferAgents[j];
                if (transfer == null || !transfer.isSupportedType(data)) continue;
                TransferData[] newDataTypes = new TransferData[dataTypes.length + 1];
                System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
                newDataTypes[dataTypes.length] = data;
                dataTypes = newDataTypes;
                break;
            }
            targets = OS.g_list_next(targets);
        }
        if (dataTypes.length == 0) {
            return false;
        }
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        if (!GTK.GTK4) {
            long window = GTK3.gtk_widget_get_window(this.control.handle);
            GDK.gdk_window_get_origin(window, origin_x, origin_y);
        }
        Point coordinates = DPIUtil.autoScaleDown(new Point(origin_x[0] + x, origin_y[0] + y));
        event.widget = this;
        event.x = coordinates.x;
        event.y = coordinates.y;
        event.time = time;
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        if (this.dropEffect != null) {
            event.item = this.dropEffect.getItem(coordinates.x, coordinates.y);
        }
        return true;
    }

    void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        TransferData[] dataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, dataTypes, 0, dataTypes.length);
        this.dragOverEvent.dataTypes = dataTypes;
        this.dragOverEvent.operations = event.operations;
        this.dragOverEvent.time = event.time;
    }
}

