"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workspaces = void 0;
var headers_1 = require("../shared/headers");
var client_1 = require("../shared/http/client");
var Workspaces = /** @class */ (function () {
    function Workspaces(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Workspaces.client = function (apiUrl, appDetails, apiSecurity) {
        return new Workspaces(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Workspaces.prototype.headers = function () {
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    Workspaces.prototype.getRequestHeaders = function (token) {
        var headers = __assign({}, this.headers());
        if (token) {
            headers.Authorization = 'Bearer ' + token;
        }
        return headers;
    };
    Workspaces.prototype.getWorkspaces = function () {
        return this.client.get('workspaces/', this.headers());
    };
    Workspaces.prototype.getPendingWorkspaces = function () {
        return this.client.get('workspaces/pending-setup', this.headers());
    };
    Workspaces.prototype.getPendingInvites = function () {
        var limitQuery = '?limit=25';
        var offsetQuery = '&offset=0';
        var query = "".concat(limitQuery).concat(offsetQuery);
        return this.client.get("workspaces/invitations/".concat(query), this.headers());
    };
    Workspaces.prototype.validateWorkspaceInvite = function (inviteId) {
        return this.client.get("workspaces/invitations/".concat(inviteId, "validate"), this.headers());
    };
    /**
     * Uploads an avatar for a specific workspace.
     * @param workspaceId The UUID of the workspace to upload the avatar for.
     * @param avatar The avatar to upload.
     * @returns The response from the server.
     */
    Workspaces.prototype.uploadWorkspaceAvatar = function (workspaceId, avatar) {
        return this.client.postForm("workspaces/".concat(workspaceId, "/avatar"), {
            file: avatar,
        }, this.headers());
    };
    Workspaces.prototype.deleteWorkspaceAvatar = function (workspaceId) {
        return this.client.delete("workspaces/".concat(workspaceId, "/avatar"), this.headers());
    };
    Workspaces.prototype.setupWorkspace = function (_a) {
        var workspaceId = _a.workspaceId, name = _a.name, address = _a.address, description = _a.description, encryptedMnemonic = _a.encryptedMnemonic;
        return this.client.patch("workspaces/".concat(workspaceId, "/setup"), { name: name, address: address, description: description, encryptedMnemonic: encryptedMnemonic }, this.headers());
    };
    Workspaces.prototype.getWorkspaceUsage = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId, "/usage"), this.headers());
    };
    Workspaces.prototype.editWorkspace = function (workspaceId, details) {
        return this.client.patch("workspaces/".concat(workspaceId), details, this.headers());
    };
    Workspaces.prototype.updateAvatar = function (workspaceId, payload) {
        return this.client.postForm("workspaces/".concat(workspaceId, "/avatar"), {
            file: payload.avatar,
        }, this.headers());
    };
    Workspaces.prototype.deleteAvatar = function (workspaceId) {
        return this.client.delete("workspaces/".concat(workspaceId, "/avatar"), this.headers());
    };
    Workspaces.prototype.createTeam = function (_a) {
        var workspaceId = _a.workspaceId, name = _a.name, managerId = _a.managerId;
        return this.client.post("workspaces/".concat(workspaceId, "/teams"), {
            name: name,
            managerId: managerId,
        }, this.headers());
    };
    Workspaces.prototype.getWorkspacesMembers = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId, "/members"), this.headers());
    };
    Workspaces.prototype.getWorkspacesTeams = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId, "/teams"), this.headers());
    };
    Workspaces.prototype.editTeam = function (_a) {
        var teamId = _a.teamId, name = _a.name;
        return this.client.patch("workspaces/teams/".concat(teamId), {
            name: name,
        }, this.headers());
    };
    Workspaces.prototype.deleteTeam = function (_a) {
        var workspaceId = _a.workspaceId, teamId = _a.teamId;
        return this.client.delete("workspaces/".concat(workspaceId, "/teams/").concat(teamId), this.headers());
    };
    Workspaces.prototype.getWorkspacesTeamMembers = function (teamId) {
        return this.client.get("workspaces/teams/".concat(teamId, "/members"), this.headers());
    };
    Workspaces.prototype.addTeamUser = function (teamId, userUuid) {
        return this.client.post("/workspaces/teams/".concat(teamId, "/user/").concat(userUuid), {}, this.headers());
    };
    Workspaces.prototype.removeTeamUser = function (teamId, userUuid) {
        return this.client.delete("/workspaces/teams/".concat(teamId, "/user/").concat(userUuid), this.headers());
    };
    Workspaces.prototype.changeTeamManager = function (workspaceId, teamId, userUuid) {
        return this.client.patch("/workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/manager"), { managerId: userUuid }, this.headers());
    };
    Workspaces.prototype.getPersonalTrash = function (workspaceId, type, offset, limit) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var typeQuery = "&type=".concat(type);
        var query = "".concat(offsetQuery).concat(limitQuery).concat(typeQuery);
        return this.client.get("/workspaces/".concat(workspaceId, "/trash").concat(query), this.headers());
    };
    Workspaces.prototype.emptyPersonalTrash = function (workspaceId) {
        return this.client.delete("/workspaces/".concat(workspaceId, "/trash"), this.headers());
    };
    Workspaces.prototype.changeUserRole = function (teamId, memberId, role) {
        return this.client.patch("/api/workspaces/teams/".concat(teamId, "/members/").concat(memberId, "/role"), {
            role: role,
        }, this.headers());
    };
    Workspaces.prototype.inviteMemberToWorkspace = function (_a) {
        var workspaceId = _a.workspaceId, invitedUserEmail = _a.invitedUserEmail, spaceLimitBytes = _a.spaceLimitBytes, encryptedMnemonicInBase64 = _a.encryptedMnemonicInBase64, _b = _a.encryptionAlgorithm, encryptionAlgorithm = _b === void 0 ? 'aes-256-gcm' : _b, message = _a.message;
        return this.client.post("workspaces/".concat(workspaceId, "/members/invite"), {
            invitedUser: invitedUserEmail,
            spaceLimit: spaceLimitBytes,
            encryptionKey: encryptedMnemonicInBase64,
            encryptionAlgorithm: encryptionAlgorithm,
            message: message,
        }, this.headers());
    };
    Workspaces.prototype.leaveWorkspace = function (workspaceId) {
        return this.client.delete("workspaces/".concat(workspaceId, "/members/leave"), this.headers());
    };
    Workspaces.prototype.getMemberDetails = function (workspaceId, memberId) {
        return this.client.get("workspaces/".concat(workspaceId, "/members/").concat(memberId), this.headers());
    };
    Workspaces.prototype.modifyMemberUsage = function (workspaceId, memberId, spaceLimitBytes) {
        return this.client.patch("workspaces/".concat(workspaceId, "/members/").concat(memberId, "/usage"), {
            spaceLimit: spaceLimitBytes,
        }, this.headers());
    };
    Workspaces.prototype.getMemberUsage = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId, "/usage/member"), this.headers());
    };
    Workspaces.prototype.deactivateMember = function (workspaceId, memberId) {
        return this.client.patch("workspaces/".concat(workspaceId, "/members/").concat(memberId, "/deactivate"), {}, this.headers());
    };
    Workspaces.prototype.activateMember = function (workspaceId, memberId) {
        return this.client.patch("workspaces/".concat(workspaceId, "/members/").concat(memberId, "/activate"), {}, this.headers());
    };
    Workspaces.prototype.removeMember = function (workspaceId, memberId) {
        return this.client.delete("workspaces/".concat(workspaceId, "/members/").concat(memberId), this.headers());
    };
    Workspaces.prototype.acceptInvitation = function (inviteId, token) {
        return this.client.post('workspaces/invitations/accept', {
            inviteId: inviteId,
        }, this.getRequestHeaders(token));
    };
    Workspaces.prototype.declineInvitation = function (inviteId, token) {
        return this.client.delete("workspaces/invitations/".concat(inviteId), this.getRequestHeaders(token));
    };
    Workspaces.prototype.getWorkspaceCredentials = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId, "/credentials"), this.headers());
    };
    Workspaces.prototype.createFileEntry = function (fileEntry, workspaceId, resourcesToken) {
        return this.client.post("/workspaces/".concat(workspaceId, "/files"), {
            name: fileEntry.name,
            bucket: fileEntry.bucket,
            fileId: fileEntry.fileId,
            encryptVersion: fileEntry.encryptVersion,
            folderUuid: fileEntry.folderUuid,
            size: fileEntry.size,
            plainName: fileEntry.plainName,
            type: fileEntry.type,
            modificationTime: fileEntry.modificationTime,
            date: fileEntry.date,
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Creates a new folder in the specified workspace.
     *
     * @param {CreateFolderPayload} options - The options for creating the folder.
     * @param {string} options.workspaceId - The ID of the workspace.
     * @param {string} options.plainName - The plain name of the folder.
     * @param {string} options.parentFolderUuid - The UUID of the parent folder.
     * @return {[Promise<CreateFolderResponse>, RequestCanceler]} A tuple containing a promise to get the API response and a function to cancel the request.
     */
    Workspaces.prototype.createFolder = function (_a) {
        var workspaceId = _a.workspaceId, plainName = _a.plainName, parentFolderUuid = _a.parentFolderUuid;
        var _b = this.client.postCancellable("/workspaces/".concat(workspaceId, "/folders"), {
            name: plainName,
            parentFolderUuid: parentFolderUuid,
        }, this.headers()), promise = _b.promise, requestCanceler = _b.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Retrieves a paginated list of folders within a specific folder in a workspace.
     *
     * @param {string} workspaceId - The ID of the workspace.
     * @param {string} folderUUID - The UUID of the folder.
     * @param {number} [offset=0] - The position of the first file to return.
     * @param {number} [limit=50] - The max number of files to be returned.
     * @param {string} [sort=''] - The reference column to sort it.
     * @param {string} [order=''] - The order to be followed.
     * @return {[Promise<FetchPaginatedFolderContentResponse>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Workspaces.prototype.getFolders = function (workspaceId, folderUUID, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/folders/").concat(folderUUID, "/folders/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Retrieves a paginated list of files within a specific folder in a workspace.
     *
     * @param {string} workspaceId - The ID of the workspace.
     * @param {string} folderUUID - The UUID of the folder.
     * @param {number} [offset=0] - The position of the first file to return.
     * @param {number} [limit=50] - The max number of files to be returned.
     * @param {string} [sort=''] - The reference column to sort it.
     * @param {string} [order=''] - The order to be followed.
     * @return {[Promise<FetchPaginatedFolderContentResponse>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Workspaces.prototype.getFiles = function (workspaceId, folderUUID, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/folders/").concat(folderUUID, "/files/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    Workspaces.prototype.getWorkspacePendingInvitations = function (workspaceId, limit, offset) {
        var limitQuery = "?limit=".concat(limit);
        var offsetQuery = "&offset=".concat(offset);
        var query = "".concat(limitQuery).concat(offsetQuery);
        return this.client.get("workspaces/".concat(workspaceId, "/invitations/").concat(query), this.headers());
    };
    /**
     * Creates a new sharing for a workspace item.
     *
     * @param {CreateWorkspaceSharingPayload} options - The options for creating the sharing.
     * @param {string} options.workspaceId - The ID of the workspace.
     * @param {string} options.teamUUID - The UUID of the team.
     * @param {...CreateSharingPayload} options.createSharingPayload - The payload for creating the sharing.
     * @returns {Promise<SharingMeta>} A promise that resolves to the sharing metadata.
     */
    Workspaces.prototype.shareItem = function (_a) {
        var workspaceId = _a.workspaceId, teamUUID = _a.teamUUID, createSharingPayload = __rest(_a, ["workspaceId", "teamUUID"]);
        return this.client.post("workspaces/".concat(workspaceId, "/shared"), __assign(__assign({}, createSharingPayload), { sharedWith: teamUUID }), this.headers());
    };
    Workspaces.prototype.validateWorkspaceInvitation = function (inviteId) {
        return this.client.get("workspaces/invitations/".concat(inviteId, "/validate"), this.headers());
    };
    /**
     * Returns shared files in teams.
     * @param orderBy
     * @deprecated use `getWorkspaceTeamSharedFilesV2` call instead.
     */
    Workspaces.prototype.getWorkspaceTeamSharedFiles = function (workspaceId, teamId, orderBy) {
        var orderByQueryParam = orderBy ? "?orderBy=".concat(orderBy) : '';
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/shared/files").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns shared files in teams.
     * @param orderBy
     */
    Workspaces.prototype.getWorkspaceTeamSharedFilesV2 = function (workspaceId, orderBy) {
        var orderByQueryParam = orderBy ? "?orderBy=".concat(orderBy) : '';
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/shared/files").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns shared folders in teams.
     * @param orderBy
     * @deprecated use `getWorkspaceTeamSharedFoldersV2` call instead.
     */
    Workspaces.prototype.getWorkspaceTeamSharedFolders = function (workspaceId, teamId, orderBy) {
        var orderByQueryParam = orderBy ? "?orderBy=".concat(orderBy) : '';
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/shared/folders").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns shared folders in teams.
     * @param orderBy
     */
    Workspaces.prototype.getWorkspaceTeamSharedFoldersV2 = function (workspaceId, orderBy) {
        var orderByQueryParam = orderBy ? "?orderBy=".concat(orderBy) : '';
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/shared/folders").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns files inside a shared folders with teams.
     * @param orderBy
     * @deprecated use `getWorkspaceTeamSharedFolderFilesV2` call instead.
     */
    Workspaces.prototype.getWorkspaceTeamSharedFolderFiles = function (workspaceId, teamId, sharedFolderUUID, page, perPage, token, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        var params = "?page=".concat(page, "&perPage=").concat(perPage);
        if (token)
            params = params + "&token=".concat(token);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/shared/").concat(sharedFolderUUID, "/files").concat(params, "\n      ").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns files inside a shared folders with teams.
     * @param orderBy
     */
    Workspaces.prototype.getWorkspaceTeamSharedFolderFilesV2 = function (workspaceId, sharedFolderUUID, page, perPage, token, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        var params = "?page=".concat(page, "&perPage=").concat(perPage);
        if (token)
            params = params + "&token=".concat(token);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/shared/").concat(sharedFolderUUID, "/files").concat(params, "\n      ").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns folders inside a shared folders with teams.
     * @param orderBy
     * @deprecated use `getWorkspaceTeamSharedFolderFoldersV2` call instead.
     */
    Workspaces.prototype.getWorkspaceTeamSharedFolderFolders = function (workspaceId, teamId, sharedFolderUUID, page, perPage, token, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        var params = "?page=".concat(page, "&perPage=").concat(perPage);
        if (token)
            params = params + "&token=".concat(token);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/teams/").concat(teamId, "/shared/").concat(sharedFolderUUID, "/folders").concat(params, "\n      ").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns folders inside a shared folders with teams.
     * @param orderBy
     */
    Workspaces.prototype.getWorkspaceTeamSharedFolderFoldersV2 = function (workspaceId, sharedFolderUUID, page, perPage, token, orderBy) {
        if (page === void 0) { page = 0; }
        if (perPage === void 0) { perPage = 50; }
        var orderByQueryParam = orderBy ? "&orderBy=".concat(orderBy) : '';
        var params = "?page=".concat(page, "&perPage=").concat(perPage);
        if (token)
            params = params + "&token=".concat(token);
        var _a = this.client.getCancellable("workspaces/".concat(workspaceId, "/shared/").concat(sharedFolderUUID, "/folders").concat(params, "\n      ").concat(orderByQueryParam), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns users and teams an item is shared with.
     */
    Workspaces.prototype.getUsersAndTeamsAnItemIsShareWidth = function (_a) {
        var workspaceId = _a.workspaceId, itemType = _a.itemType, itemId = _a.itemId;
        var _b = this.client.getCancellable("workspaces/".concat(workspaceId, "/shared/").concat(itemType, "/").concat(itemId, "/shared-with"), this.headers()), promise = _b.promise, requestCanceler = _b.requestCanceler;
        return [promise, requestCanceler];
    };
    Workspaces.prototype.getWorkspace = function (workspaceId) {
        return this.client.get("workspaces/".concat(workspaceId), this.headers());
    };
    Workspaces.prototype.getWorkspaceLogs = function (workspaceId, limit, offset, member, activity, lastDays, summary, orderBy) {
        if (limit === void 0) { limit = 50; }
        if (offset === void 0) { offset = 0; }
        if (summary === void 0) { summary = true; }
        var params = new URLSearchParams();
        params.append('limit', String(limit));
        params.append('offset', String(offset));
        params.append('summary', String(summary));
        if (member) {
            params.append('member', member);
        }
        if (activity && activity.length > 0) {
            activity.forEach(function (act, index) {
                params.append("activity[".concat(index, "]"), act);
            });
        }
        if (lastDays) {
            params.append('lastDays', String(lastDays));
        }
        if (orderBy) {
            params.append('orderBy', String(orderBy));
        }
        return this.client.get("workspaces/".concat(workspaceId, "/access/logs?").concat(params.toString()), this.headers());
    };
    return Workspaces;
}());
exports.Workspaces = Workspaces;
__exportStar(require("./types"), exports);
