import { Headers, Parameters, RequestCanceler, URL, UnauthorizedCallback } from './types';
export { RequestCanceler } from './types';
export declare class HttpClient {
    private readonly axios;
    private readonly unauthorizedCallback;
    static create(baseURL: URL, unauthorizedCallback?: UnauthorizedCallback): HttpClient;
    private constructor();
    /**
     * Requests a GET
     * @param url
     * @param headers
     */
    get<Response>(url: URL, headers: Headers): Promise<Response>;
    /**
     * Requests a GET
     * @param url
     * @param params
     * @param headers
     */
    getWithParams<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a GET with option to cancel
     * @param url
     * @param headers
     */
    getCancellable<Response>(url: URL, headers: Headers): {
        promise: Promise<Response>;
        requestCanceler: RequestCanceler;
    };
    /**
     * Requests a POST
     * @param url
     * @param params
     * @param headers
     */
    post<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a POST FORM
     * @param url
     * @param params
     * @param headers
     */
    postForm<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a POST with option to cancel
     * @param url
     * @param params
     * @param headers
     */
    postCancellable<Response>(url: URL, params: Parameters, headers: Headers): {
        promise: Promise<Response>;
        requestCanceler: RequestCanceler;
    };
    /**
     * Requests PATCH
     * @param url
     * @param params
     * @param headers
     */
    patch<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a PUT
     * @param url
     * @param params
     * @param headers
     */
    put<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a PUT FORM
     * @param url
     * @param params
     * @param headers
     */
    putForm<Response>(url: URL, params: Parameters, headers: Headers): Promise<Response>;
    /**
     * Requests a DELETE
     * @param url
     * @param headers
     * @param params
     */
    delete<Response>(url: URL, headers: Headers, params?: Parameters): Promise<Response>;
    /**
     * Sets middlewares into the client for common behaviour managing
     * @private
     */
    private initializeMiddleware;
    /**
     * Extracts the valuable data from the server's response
     * @param response
     * @private
     */
    private static extractData;
    /**
     * Converts the specific client error into a proprietary error for our apps
     * @param error
     * @private
     */
    private normalizeError;
}
