import { BasicAuth, Token } from '../../auth';
export interface CustomHeaders {
    [key: string]: string;
}
type InternxtHeaders = {
    'content-type': string;
    'internxt-version': string;
    'internxt-client': string;
    'x-share-password'?: string;
    Authorization?: string;
    'x-token'?: string;
    'internxt-resources-token'?: string;
    'x-internxt-desktop-header'?: string;
};
export declare function basicHeaders({ clientName, clientVersion, customHeaders, desktopToken, }: {
    clientName: string;
    clientVersion: string;
    customHeaders?: Record<string, string>;
    desktopToken?: Token;
}): InternxtHeaders;
export declare function basicHeadersWithPassword({ clientName, clientVersion, password, desktopToken, }: {
    clientName: string;
    clientVersion: string;
    password: string;
    desktopToken?: Token;
}): InternxtHeaders;
export declare function headersWithToken({ clientName, clientVersion, token, workspaceToken, desktopToken, customHeaders, }: {
    clientName: string;
    clientVersion: string;
    token: Token;
    workspaceToken?: Token;
    desktopToken?: Token;
    customHeaders?: CustomHeaders;
}): InternxtHeaders;
export declare function headersWithTokenAndPassword({ clientName, clientVersion, token, workspaceToken, desktopToken, password, }: {
    clientName: string;
    clientVersion: string;
    token: Token;
    workspaceToken: Token | undefined;
    desktopToken: Token | undefined;
    password: string;
}): InternxtHeaders;
export declare function headersWithBasicAuth({ clientName, clientVersion, auth, workspaceToken, desktopToken, customHeaders, }: {
    clientName: string;
    clientVersion: string;
    auth: BasicAuth;
    workspaceToken?: Token;
    desktopToken?: Token;
    customHeaders?: CustomHeaders;
}): InternxtHeaders;
export declare function headersWithAuthToken({ clientName, clientVersion, token, workspaceToken, desktopToken, customHeaders, }: {
    clientName: string;
    clientVersion: string;
    token: Token;
    workspaceToken?: Token;
    desktopToken?: Token;
    customHeaders?: CustomHeaders;
}): InternxtHeaders;
export declare function addResourcesTokenToHeaders(headers: InternxtHeaders, resourcesToken?: Token): InternxtHeaders;
export {};
