"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = exports.InvalidMultipartValueError = exports.FileTooSmallForMultipartError = exports.InvalidUploadSizeError = exports.InvalidUploadIndexError = exports.InvalidFileIndexError = exports.DuplicatedIndexesError = void 0;
var uuid_1 = require("uuid");
var index_1 = require("../shared/headers/index");
var client_1 = require("../shared/http/client");
var utils_1 = require("../utils");
__exportStar(require("./types"), exports);
var DuplicatedIndexesError = /** @class */ (function (_super) {
    __extends(DuplicatedIndexesError, _super);
    function DuplicatedIndexesError() {
        var _this = _super.call(this, 'Duplicated indexes found') || this;
        Object.setPrototypeOf(_this, DuplicatedIndexesError.prototype);
        return _this;
    }
    return DuplicatedIndexesError;
}(Error));
exports.DuplicatedIndexesError = DuplicatedIndexesError;
var InvalidFileIndexError = /** @class */ (function (_super) {
    __extends(InvalidFileIndexError, _super);
    function InvalidFileIndexError() {
        var _this = _super.call(this, 'Invalid file index') || this;
        Object.setPrototypeOf(_this, InvalidFileIndexError.prototype);
        return _this;
    }
    return InvalidFileIndexError;
}(Error));
exports.InvalidFileIndexError = InvalidFileIndexError;
var InvalidUploadIndexError = /** @class */ (function (_super) {
    __extends(InvalidUploadIndexError, _super);
    function InvalidUploadIndexError() {
        var _this = _super.call(this, 'Invalid upload index') || this;
        Object.setPrototypeOf(_this, InvalidUploadIndexError.prototype);
        return _this;
    }
    return InvalidUploadIndexError;
}(Error));
exports.InvalidUploadIndexError = InvalidUploadIndexError;
var InvalidUploadSizeError = /** @class */ (function (_super) {
    __extends(InvalidUploadSizeError, _super);
    function InvalidUploadSizeError() {
        var _this = _super.call(this, 'Invalid size') || this;
        Object.setPrototypeOf(_this, InvalidUploadSizeError.prototype);
        return _this;
    }
    return InvalidUploadSizeError;
}(Error));
exports.InvalidUploadSizeError = InvalidUploadSizeError;
var FileTooSmallForMultipartError = /** @class */ (function (_super) {
    __extends(FileTooSmallForMultipartError, _super);
    function FileTooSmallForMultipartError() {
        var _this = _super.call(this, 'File is too small for multipart upload') || this;
        Object.setPrototypeOf(_this, FileTooSmallForMultipartError.prototype);
        return _this;
    }
    return FileTooSmallForMultipartError;
}(Error));
exports.FileTooSmallForMultipartError = FileTooSmallForMultipartError;
var InvalidMultipartValueError = /** @class */ (function (_super) {
    __extends(InvalidMultipartValueError, _super);
    function InvalidMultipartValueError() {
        var _this = _super.call(this, 'Invalid multipart value') || this;
        Object.setPrototypeOf(_this, InvalidMultipartValueError.prototype);
        return _this;
    }
    return InvalidMultipartValueError;
}(Error));
exports.InvalidMultipartValueError = InvalidMultipartValueError;
var Network = /** @class */ (function () {
    function Network(apiUrl, appDetails, opts) {
        this.client = client_1.HttpClient.create(apiUrl);
        this.appDetails = appDetails;
        this.auth = {
            username: opts.bridgeUser,
            password: opts.userId,
        };
    }
    Network.client = function (apiUrl, appDetails, opts) {
        return new Network(apiUrl, appDetails, opts);
    };
    Object.defineProperty(Network.prototype, "credentials", {
        get: function () {
            return this.auth;
        },
        enumerable: false,
        configurable: true
    });
    Network.prototype.startUpload = function (bucketId, payload, parts) {
        if (parts === void 0) { parts = 1; }
        var totalSize = 0;
        for (var _i = 0, _a = payload.uploads; _i < _a.length; _i++) {
            var _b = _a[_i], index = _b.index, size = _b.size;
            if (index < 0) {
                throw new InvalidUploadIndexError();
            }
            if (size < 0) {
                throw new InvalidUploadSizeError();
            }
            totalSize += size;
        }
        var MB100 = 100 * 1024 * 1024;
        if (totalSize < MB100 && parts > 1) {
            throw new FileTooSmallForMultipartError();
        }
        if (!Number.isInteger(parts) || parts < 1) {
            throw new InvalidMultipartValueError();
        }
        var uploadIndexesWithoutDuplicates = new Set(payload.uploads.map(function (upload) { return upload.index; }));
        if (uploadIndexesWithoutDuplicates.size < payload.uploads.length) {
            throw new DuplicatedIndexesError();
        }
        return Network.startUpload(bucketId, payload, {
            client: this.client,
            appDetails: this.appDetails,
            auth: this.auth,
        }, parts);
    };
    Network.prototype.finishUpload = function (bucketId, payload) {
        var index = payload.index, shards = payload.shards;
        if (!(0, utils_1.isHexString)(index) || index.length !== 64) {
            throw new InvalidFileIndexError();
        }
        for (var _i = 0, shards_1 = shards; _i < shards_1.length; _i++) {
            var shard = shards_1[_i];
            if (!(0, uuid_1.validate)(shard.uuid)) {
                throw new Error('Invalid UUID');
            }
        }
        return Network.finishUpload(bucketId, payload, {
            client: this.client,
            appDetails: this.appDetails,
            auth: this.auth,
        });
    };
    Network.prototype.finishMultipartUpload = function (bucketId, payload) {
        var index = payload.index, shards = payload.shards;
        if (!(0, utils_1.isHexString)(index) || index.length !== 64) {
            throw new InvalidFileIndexError();
        }
        for (var _i = 0, shards_2 = shards; _i < shards_2.length; _i++) {
            var shard = shards_2[_i];
            if (!(0, uuid_1.validate)(shard.uuid)) {
                throw new Error('Invalid UUID');
            }
            if (!shard.UploadId) {
                throw new Error('Missing UploadId');
            }
            if (!shard.parts) {
                throw new Error('Missing parts');
            }
        }
        return Network.finishUpload(bucketId, payload, {
            client: this.client,
            appDetails: this.appDetails,
            auth: this.auth,
        });
    };
    Network.prototype.getDownloadLinks = function (bucketId, fileId, token) {
        return Network.getDownloadLinks(bucketId, fileId, {
            client: this.client,
            appDetails: this.appDetails,
            auth: this.auth,
        }, token);
    };
    Network.prototype.deleteFile = function (bucketId, fileId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Network.deleteFile(bucketId, fileId, {
                            client: this.client,
                            appDetails: this.appDetails,
                            auth: this.auth,
                        })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Creates entries for every upload in the request, returns the urls to upload
     * @param bucketId
     * @param uploads
     */
    Network.startUpload = function (bucketId, payload, _a, parts) {
        var client = _a.client, appDetails = _a.appDetails, auth = _a.auth;
        if (parts === void 0) { parts = 1; }
        var headers = Network.headersWithBasicAuth(appDetails, auth);
        return client.post("/v2/buckets/".concat(bucketId, "/files/start?multiparts=").concat(parts), payload, headers);
    };
    /**
     * Finishes the upload of a file
     * @param bucketId
     * @param index
     * @param shards
     */
    Network.finishUpload = function (bucketId, payload, _a) {
        var client = _a.client, appDetails = _a.appDetails, auth = _a.auth;
        var headers = Network.headersWithBasicAuth(appDetails, auth);
        return client.post("/v2/buckets/".concat(bucketId, "/files/finish"), payload, headers);
    };
    /**
     * Gets the download links for a file
     * @param bucketId
     * @param file
     */
    Network.getDownloadLinks = function (bucketId, fileId, _a, token) {
        var client = _a.client, appDetails = _a.appDetails, auth = _a.auth;
        // ES ESTE EL QUE FALLA AL INTENTAR DESCARGAR UN FILE
        var headers = token
            ? Network.headersWithAuthToken(appDetails, token)
            : Network.headersWithBasicAuth(appDetails, auth);
        return client.get("/buckets/".concat(bucketId, "/files/").concat(fileId, "/info"), __assign(__assign({}, headers), { 'x-api-version': '2' }));
    };
    /**
     * Deletes a file
     * @param bucketId
     * @param file
     */
    Network.deleteFile = function (bucketId, fileId, _a) {
        var client = _a.client, appDetails = _a.appDetails, auth = _a.auth;
        var headers = Network.headersWithBasicAuth(appDetails, auth);
        return client.delete("/v2/buckets/".concat(bucketId, "/files/").concat(fileId), headers);
    };
    /**
     * Gets headers with basic auth
     * @param appDetails
     * @param auth
     */
    Network.headersWithBasicAuth = function (appDetails, auth) {
        return (0, index_1.headersWithBasicAuth)({
            clientName: appDetails.clientName,
            clientVersion: appDetails.clientVersion,
            auth: auth,
            desktopToken: appDetails.desktopHeader,
            customHeaders: appDetails.customHeaders,
        });
    };
    Network.headersWithAuthToken = function (appDetails, token) {
        return (0, index_1.headersWithAuthToken)({
            clientName: appDetails.clientName,
            clientVersion: appDetails.clientVersion,
            token: token,
            desktopToken: appDetails.desktopHeader,
            customHeaders: appDetails.customHeaders,
        });
    };
    return Network;
}());
exports.Network = Network;
