/**
 * NETWORK ERROR CODES FORMAT: 1****
 * -UPLOAD ERRORS:              1***
 * -DOWNLOAD ERRORS:            2***
 * -CRYPTOGRAPHIC ERRORS:        1**
 *
 */
declare enum UploadErrorCode {
    InvalidMnemonic = 11100
}
declare enum DownloadErrorCode {
    InvalidMnemonic = 12100
}
type NetworkErrorCode = UploadErrorCode | DownloadErrorCode;
export declare class CodeError extends Error {
    code: NetworkErrorCode;
    message: string;
    constructor(code: NetworkErrorCode, message: string);
}
declare const _default: {
    Upload: typeof UploadErrorCode;
    Download: typeof DownloadErrorCode;
};
export default _default;
