import { ApiSecurity, ApiUrl, AppDetails } from '../shared';
import { CreateCallResponse, JoinCallPayload, JoinCallResponse, UsersInCallResponse } from './types';
export declare class Meet {
    private readonly client;
    private readonly appDetails;
    private readonly apiSecurity?;
    private constructor();
    static client(apiUrl: ApiUrl, appDetails: AppDetails, apiSecurity?: ApiSecurity): Meet;
    createCall(): Promise<CreateCallResponse>;
    joinCall(callId: string, payload: JoinCallPayload): Promise<JoinCallResponse>;
    leaveCall(callId: string): Promise<void>;
    getCurrentUsersInCall(callId: string): Promise<UsersInCallResponse[]>;
    private headersWithToken;
    private basicHeaders;
}
