"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Users = exports.UserTypes = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
exports.UserTypes = __importStar(require("./types"));
var Users = /** @class */ (function () {
    function Users(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity === null || apiSecurity === void 0 ? void 0 : apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Users.client = function (apiUrl, appDetails, apiSecurity) {
        return new Users(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Sends an invitation to the specified email
     * @param email
     */
    Users.prototype.sendInvitation = function (email) {
        return this.client.post('/user/invite', {
            email: email,
        }, this.headers());
    };
    /**
     * Initialize basic state of user and returns data after registration process
     * @param email
     * @param mnemonic
     */
    Users.prototype.initialize = function (email, mnemonic) {
        return this.client
            .post('/initialize', {
            email: email,
            mnemonic: mnemonic,
        }, this.headers())
            .then(function (data) {
            return data.user;
        });
    };
    /**
     * Returns fresh data of the user
     */
    Users.prototype.refreshUser = function () {
        return this.client.get('/users/refresh', this.headers());
    };
    /**
     * Returns fresh data of the user
     */
    Users.prototype.refreshUserCredentials = function () {
        return this.client.get('/users/cli/refresh', this.headers());
    };
    /**
     * Returns fresh avatar URL of the user
     */
    Users.prototype.refreshAvatarUser = function () {
        return this.client.get('/users/avatar/refresh', this.headers());
    };
    /**
     * @deprecated Use `refreshUser` instead.
     *
     * Retrieves the user data for a specific user identified by the uuid.
     *
     * @param {string} params.userUuid - The UUID of the user.
     * @return {Promise<Object>} A promise that resolves to an object containing the user data.
     * The object has the following properties:
     * - `newToken` (string): The new token of the user.
     * - `oldToken` (string): The old drive token of the user.
     * - `user` (UserSettings): The user data.
     */
    Users.prototype.getUserData = function (_a) {
        var userUuid = _a.userUuid;
        return this.client.get("/users/c/".concat(userUuid), this.headers());
    };
    /**
     * Updates the authentication credentials and invalidates previous tokens (Legacy backend (drive-server))
     * @param payload
     *
     * @returns {Promise<{token: string, newToken: string}>} A promise that returns new tokens for this user.
     */
    Users.prototype.changePasswordLegacy = function (payload) {
        return this.client.patch('/user/password', {
            currentPassword: payload.currentEncryptedPassword,
            newPassword: payload.newEncryptedPassword,
            newSalt: payload.newEncryptedSalt,
            mnemonic: payload.encryptedMnemonic,
            privateKey: payload.encryptedPrivateKey,
        }, this.headers());
    };
    /**
     * Updates the authentication credentials and invalidates previous tokens (New backend (drive-server-wip))
     * @param payload
     *
     * @returns {Promise<{token: string, newToken: string}>} A promise that returns new tokens for this user.
     */
    Users.prototype.changePassword = function (payload) {
        return this.client.patch('/users/password', {
            currentPassword: payload.currentEncryptedPassword,
            newPassword: payload.newEncryptedPassword,
            newSalt: payload.newEncryptedSalt,
            mnemonic: payload.encryptedMnemonic,
            privateKey: payload.keys.encryptedPrivateKey,
            privateKyberKey: payload.keys.encryptedPrivateKyberKey,
            encryptVersion: payload.encryptVersion,
        }, this.headers());
    };
    /**
     * Runs the first phase (out of 2) of the password change.
     * @param hmac - The HMAC to authenticate request.
     * @param sessionID - The current session ID.
     * @param registrationRequest - The opaque registration request.
     * @returns {Promise<string>} A promise that returns opaque registration response.
     */
    Users.prototype.changePwdOpaqueStart = function (hmac, sessionID, registrationRequest) {
        return this.client.patch('/users/password-opaque/start', {
            hmac: hmac,
            sessionID: sessionID,
            registrationRequest: registrationRequest,
        }, this.headers());
    };
    /**
     * Runs the second phase (out of 2) of the password change.
     * @param hmac - The HMAC to authenticate request.
     * @param sessionID - The current session ID.
     * @param registrationRecord - The opaque registration record.
     * @param mnemonic - The user's encrypted mnemonic.
     * @param keys - The user's encrypted keys.
     * @param startLoginRequest - The opaque start login request.
     * @returns {Promise<string>} A promise that returns opaque login response.
     */
    Users.prototype.changePwdOpaqueFinish = function (hmac, sessionID, registrationRecord, mnemonic, keys, startLoginRequest) {
        return this.client.patch('/users/password-opaque/finish', {
            hmac: hmac,
            sessionID: sessionID,
            keys: keys,
            mnemonic: mnemonic,
            registrationRecord: registrationRecord,
            startLoginRequest: startLoginRequest,
        }, this.headers());
    };
    /**
     * Pre registers an email
     * @param email
     * @returns {Promise<PreCreateUserResponse>} A promise that returns a public key for this user.
     */
    Users.prototype.preRegister = function (email) {
        return this.client.post('/users/pre-create', {
            email: email,
        }, this.headers());
    };
    /**
     * @deprecated Use `updateUserProfile` instead.
     * Updates a user profile
     * @param payload
     */
    Users.prototype.updateProfile = function (payload) {
        return this.client.patch('/user/profile', payload, this.headers());
    };
    /**
     * Updates a user profile
     * @param payload
     */
    Users.prototype.updateUserProfile = function (payload, token) {
        var _a;
        return this.client.patch('/users/profile', payload, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * @deprecated Use `updateUserAvatar` instead.
     * Updates a user avatar
     * @param payload
     */
    Users.prototype.updateAvatar = function (payload) {
        return this.client.putForm('/user/avatar', {
            avatar: payload.avatar,
        }, this.headers());
    };
    /**
     * Updates a user avatar
     * @param payload
     */
    Users.prototype.updateUserAvatar = function (payload, token) {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                return [2 /*return*/, this.client.putForm('/users/avatar', {
                        avatar: payload.avatar,
                    }, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token))];
            });
        });
    };
    /**
     * @deprecated Use `deleteUserAvatar` instead.
     * Delete current user avatar
     */
    Users.prototype.deleteAvatar = function () {
        return this.client.delete('/user/avatar', this.headers());
    };
    /**
     * Delete current user avatar
     */
    Users.prototype.deleteUserAvatar = function (token) {
        var _a;
        return this.client.delete('/users/avatar', this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * Gets all friend invites created by this user
     */
    Users.prototype.getFriendInvites = function () {
        return this.client.get('/user/invite', this.headers());
    };
    /**
     * Sends verification email
     */
    Users.prototype.sendVerificationEmail = function (token) {
        var _a;
        return this.client.post('/users/email-verification/send', {}, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * Verifies user email
     */
    Users.prototype.verifyEmail = function (payload) {
        return this.client.post('/users/email-verification', payload, this.headers());
    };
    /**
     * Change user email by new email
     *
     * @param {string} newEmail
     *
     * @returns {Promise<void>}
     */
    Users.prototype.changeUserEmail = function (newEmail) {
        return this.client.post('users/attempt-change-email', {
            newEmail: newEmail,
        }, this.headers());
    };
    /**
     * Verify user email change
     *
     * @param {string} encryptedAttemptChangeEmailId
     *
     * @returns {Promise<VerifyEmailChangeResponse>}
     */
    Users.prototype.verifyEmailChange = function (encryptedAttemptChangeEmailId) {
        return this.client.post("users/attempt-change-email/".concat(encryptedAttemptChangeEmailId, "/accept"), {}, this.headers());
    };
    /**
     * Check if user email change verification link is expired
     *
     * @param {string} encryptedAttemptChangeEmailId
     *
     * @returns {Promise<CheckChangeEmailExpirationResponse>}
     */
    Users.prototype.checkChangeEmailExpiration = function (encryptedAttemptChangeEmailId) {
        return this.client.get("users/attempt-change-email/".concat(encryptedAttemptChangeEmailId, "/verify-expiration"), this.headers());
    };
    /**
     * Get public key of given email
     */
    Users.prototype.getPublicKeyByEmail = function (_a) {
        var email = _a.email;
        return this.client.get("/users/public-key/".concat(email), this.headers());
    };
    /**
     * Get public key of given email, if not exists it pre-create user with this email
     * and returns public key
     * @param email
     * @returns {Promise<UserPublicKeyWithCreationResponse>} A promise that returns the public keys of given user
     */
    Users.prototype.getPublicKeyWithPrecreation = function (_a) {
        var email = _a.email;
        return this.client.put("/users/public-key/".concat(email), {}, this.headers());
    };
    /**
     * Generate mnemonic
     */
    Users.prototype.generateMnemonic = function () {
        return this.client.get('/users/generate-mnemonic', this.basicHeaders());
    };
    Users.prototype.basicHeaders = function () {
        return (0, headers_1.basicHeaders)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    Users.prototype.headers = function () {
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    Users.prototype.headersWithToken = function (token) {
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    return Users;
}());
exports.Users = Users;
