"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Payments = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
var types_1 = require("./types/types");
var Payments = /** @class */ (function () {
    function Payments(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Payments.client = function (apiUrl, appDetails, apiSecurity) {
        return new Payments(apiUrl, appDetails, apiSecurity);
    };
    Payments.prototype.createCustomer = function (name, email, country, companyVatId) {
        return this.client.post('/create-customer', { name: name, email: email, country: country, companyVatId: companyVatId }, this.headers());
    };
    Payments.prototype.createSubscription = function (customerId, priceId, token, quantity, currency, promoCodeId) {
        return this.client.post('/create-subscription', {
            customerId: customerId,
            priceId: priceId,
            token: token,
            quantity: quantity,
            currency: currency,
            promoCodeId: promoCodeId,
        }, this.headers());
    };
    Payments.prototype.createPaymentIntent = function (customerId, amount, planId, token, currency, promoCodeName) {
        var query = new URLSearchParams();
        query.set('customerId', customerId);
        query.set('amount', String(amount));
        query.set('planId', planId);
        query.set('token', token);
        if (currency !== undefined)
            query.set('currency', currency);
        if (promoCodeName !== undefined)
            query.set('promoCodeName', promoCodeName);
        return this.client.get("/payment-intent?".concat(query.toString()), this.headers());
    };
    /**
     * Fetches the existing products and its details
     */
    Payments.prototype.getProducts = function () {
        return this.client.get('/v3/stripe/products', this.headers());
    };
    /**
     * Creates and returns a new session identifier for the client to go to payment platform
     * @param payload
     */
    Payments.prototype.createSession = function (payload) {
        return this.client.post('/v2/stripe/session', {
            test: payload.test,
            lifetime_tier: payload.lifetime_tier,
            mode: payload.mode,
            priceId: payload.priceId,
            successUrl: payload.successUrl,
            canceledUrl: payload.canceledUrl,
        }, this.headers());
    };
    Payments.prototype.getSetupIntent = function (userType) {
        var query = new URLSearchParams();
        if (userType)
            query.set('userType', userType);
        return this.client.get("/setup-intent?".concat(query.toString()), this.headers());
    };
    Payments.prototype.getDefaultPaymentMethod = function (userType) {
        var query = new URLSearchParams();
        if (userType)
            query.set('userType', userType);
        return this.client.get("/default-payment-method?".concat(query.toString()), this.headers());
    };
    Payments.prototype.getInvoices = function (_a) {
        var subscriptionId = _a.subscriptionId, _b = _a.userType, userType = _b === void 0 ? types_1.UserType.Individual : _b, startingAfter = _a.startingAfter, limit = _a.limit;
        var query = new URLSearchParams();
        if (subscriptionId !== undefined)
            query.set('subscription', subscriptionId);
        if (startingAfter !== undefined)
            query.set('starting_after', startingAfter);
        if (userType !== undefined)
            query.set('userType', userType);
        if (limit !== undefined)
            query.set('limit', limit.toString());
        return this.client.get("/invoices?".concat(query.toString()), this.headers());
    };
    Payments.prototype.isCouponUsedByUser = function (_a) {
        var couponCode = _a.couponCode;
        var query = new URLSearchParams();
        if (couponCode !== undefined)
            query.set('code', couponCode);
        return this.client.get("/coupon-in-use?".concat(query.toString()), this.headers());
    };
    Payments.prototype.getPromoCodesUsedByUser = function () {
        return this.client.get('/customer/redeemed-promotion-codes', this.headers());
    };
    Payments.prototype.getUserSubscription = function (userType) {
        var query = new URLSearchParams();
        if (userType)
            query.set('userType', userType);
        return this.client.get("/subscriptions?".concat(query.toString()), this.headers()).catch(function (err) {
            var error = err;
            if (error.status === 404)
                return { type: 'free' };
            else
                throw err;
        });
    };
    Payments.prototype.getPrices = function (currency, userType) {
        return __awaiter(this, void 0, void 0, function () {
            var query;
            return __generator(this, function (_a) {
                query = new URLSearchParams();
                if (currency !== undefined)
                    query.set('currency', currency);
                if (userType)
                    query.set('userType', userType);
                return [2 /*return*/, this.client.get("/prices?".concat(query.toString()), this.headers())];
            });
        });
    };
    Payments.prototype.requestPreventCancellation = function () {
        return this.client.get('/request-prevent-cancellation', this.headers());
    };
    Payments.prototype.preventCancellation = function () {
        return this.client.put('/prevent-cancellation', {}, this.headers());
    };
    Payments.prototype.applyRedeemCode = function (payload) {
        return this.client.post('/licenses', { code: payload.code, provider: payload.provider }, this.headers());
    };
    Payments.prototype.updateSubscriptionPaymentMethod = function (payload) {
        return this.client.post('/subscriptions/update-payment-method', __assign({}, payload), this.headers());
    };
    Payments.prototype.updateSubscriptionPrice = function (_a) {
        var priceId = _a.priceId, couponCode = _a.couponCode, userType = _a.userType;
        return this.client.put('/subscriptions', { price_id: priceId, couponCode: couponCode, userType: userType }, this.headers());
    };
    Payments.prototype.updateWorkspaceMembers = function (workspaceId, subscriptionId, updatedSeats) {
        return this.client.patch('/business/subscription', {
            workspaceId: workspaceId,
            subscriptionId: subscriptionId,
            workspaceUpdatedSeats: updatedSeats,
        }, this.headers());
    };
    Payments.prototype.cancelSubscription = function (userType) {
        var query = new URLSearchParams();
        if (userType)
            query.set('userType', userType);
        return this.client.delete("/subscriptions?".concat(query.toString()), this.headers());
    };
    Payments.prototype.createCheckoutSession = function (payload) {
        return this.client.post('/checkout-session', __assign({}, payload), this.headers());
    };
    Payments.prototype.updateCustomerBillingInfo = function (payload) {
        return this.client.patch('/billing', __assign({}, payload), this.headers());
    };
    /**
     * Gets the available products from the user
     * @returns an object containing available products
     */
    Payments.prototype.checkUserAvailableProducts = function () {
        return this.client.get('/products', this.headers());
    };
    /**
     * Gets product information based on the user's subscription tier.
     *
     * @param {UserType} [userType] - The type of user for which to query product information.
     *                               If not specified, UserType.Individual will be used by default.
     * @returns {Promise<Tier>} A promise that resolves with the product information
     *                         available for the specified tier.
     *
     * @example
     * // Get products for an individual user tier (default)
     * const individualProducts = await getUserTier();
     *
     * @example
     * // Get products for a business user tier
     * const businessProducts = await getUserTier(UserType.Business);
     */
    Payments.prototype.getUserTier = function (userType) {
        var query = new URLSearchParams();
        if (userType !== undefined)
            query.set('tierType', userType);
        return this.client.get("/products/tier?".concat(query.toString()), this.headers());
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Payments.prototype.headers = function () {
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    return Payments;
}());
exports.Payments = Payments;
