"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auth = void 0;
var headers_1 = require("../shared/headers");
var client_1 = require("../shared/http/client");
__exportStar(require("./types"), exports);
var Auth = /** @class */ (function () {
    function Auth(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity === null || apiSecurity === void 0 ? void 0 : apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
        this.apiUrl = apiUrl;
    }
    Auth.client = function (apiUrl, appDetails, apiSecurity) {
        return new Auth(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Runs the first phase (out of 2) of opaque registation of a new user
     * @param email - The user email.
     * @param registrationRequest - The opaque registration request.
     * @returns The opaque sign up response.
     */
    Auth.prototype.registerOpaqueStart = function (email, registrationRequest) {
        return this.client.post('/register-opaque/start', {
            email: email,
            registrationRequest: registrationRequest,
        }, this.basicHeaders());
    };
    /**
     * Runs the second phase (out of 2) of opaque registation of a new user
     * @param registrationRecord - The opaque registration record.
     * @param registerDetails - The user registration details.
     * @param startLoginRequest - The opaque start login request.
     * @returns The opaque login response.
     */
    Auth.prototype.registerOpaqueFinish = function (registrationRecord, registerDetails, startLoginRequest) {
        return this.client.post('/register-opaque/finish', {
            name: registerDetails.name,
            lastname: registerDetails.lastname,
            email: registerDetails.email,
            registrationRecord: registrationRecord,
            keys: {
                ecc: {
                    publicKey: registerDetails.keys.ecc.publicKey,
                    privateKey: registerDetails.keys.ecc.privateKey,
                },
                kyber: {
                    publicKey: registerDetails.keys.kyber.publicKey,
                    privateKey: registerDetails.keys.kyber.privateKey,
                },
            },
            startLoginRequest: startLoginRequest,
        }, this.basicHeaders());
    };
    /**
     * Tries to register a new user
     * @param registerDetails
     */
    Auth.prototype.register = function (registerDetails) {
        return this.client.post('/users', {
            name: registerDetails.name,
            captcha: registerDetails.captcha,
            lastname: registerDetails.lastname,
            email: registerDetails.email,
            password: registerDetails.password,
            mnemonic: registerDetails.mnemonic,
            salt: registerDetails.salt,
            /**
            / @deprecated The individual fields for keys should not be used
            */
            privateKey: registerDetails.keys.privateKeyEncrypted,
            publicKey: registerDetails.keys.publicKey,
            revocationKey: registerDetails.keys.revocationCertificate,
            keys: {
                ecc: {
                    publicKey: registerDetails.keys.ecc.publicKey,
                    privateKey: registerDetails.keys.ecc.privateKeyEncrypted,
                },
                kyber: {
                    publicKey: registerDetails.keys.kyber.publicKey,
                    privateKey: registerDetails.keys.kyber.privateKeyEncrypted,
                },
            },
            referral: registerDetails.referral,
            referrer: registerDetails.referrer,
        }, this.basicHeaders());
    };
    /**
     * Tries to register a new user without sending keys
     * @param registerDetails
     */
    Auth.prototype.registerWithoutKeys = function (registerDetails) {
        var body = {
            name: registerDetails.name,
            captcha: registerDetails.captcha,
            lastname: registerDetails.lastname,
            email: registerDetails.email,
            password: registerDetails.password,
            mnemonic: registerDetails.mnemonic,
            salt: registerDetails.salt,
            referral: registerDetails.referral,
            referrer: registerDetails.referrer,
        };
        return this.client.post('/users', body, this.basicHeaders());
    };
    /**
     * Registers a precreated user
     * @param registerDetails
     * @returns {Promise<RegisterPreCreatedUserResponse>} Returns sign in token, user data and uuid.
     */
    Auth.prototype.registerPreCreatedUser = function (registerDetails) {
        return this.client.post('users/pre-created-users/register', {
            name: registerDetails.name,
            captcha: registerDetails.captcha,
            lastname: registerDetails.lastname,
            email: registerDetails.email,
            password: registerDetails.password,
            mnemonic: registerDetails.mnemonic,
            salt: registerDetails.salt,
            /**
            / @deprecated The individual fields for keys should not be used
            */
            privateKey: registerDetails.keys.privateKeyEncrypted,
            publicKey: registerDetails.keys.publicKey,
            revocationKey: registerDetails.keys.revocationCertificate,
            keys: {
                ecc: {
                    publicKey: registerDetails.keys.ecc.publicKey,
                    privateKey: registerDetails.keys.ecc.privateKeyEncrypted,
                },
                kyber: {
                    publicKey: registerDetails.keys.kyber.publicKey,
                    privateKey: registerDetails.keys.kyber.privateKeyEncrypted,
                },
            },
            referral: registerDetails.referral,
            referrer: registerDetails.referrer,
            invitationId: registerDetails.invitationId,
        }, this.basicHeaders());
    };
    /**
     * Registers a precreated user without sending keys
     * @param registerDetails
     * @returns {Promise<RegisterPreCreatedUserResponse>} Returns sign in token, user data and uuid.
     */
    Auth.prototype.registerPreCreatedUserWithoutKeys = function (registerDetails) {
        return this.client.post('users/pre-created-users/register', {
            name: registerDetails.name,
            captcha: registerDetails.captcha,
            lastname: registerDetails.lastname,
            email: registerDetails.email,
            password: registerDetails.password,
            mnemonic: registerDetails.mnemonic,
            salt: registerDetails.salt,
            referral: registerDetails.referral,
            referrer: registerDetails.referrer,
            invitationId: registerDetails.invitationId,
        }, this.basicHeaders());
    };
    /**
     * Requests account unblock email
     *
     * @param {string} email - The email address associated with the account.
     * @returns {Promise<void>} - Resolves when the email is sent.
     */
    Auth.prototype.requestUnblockAccount = function (email) {
        return this.client.post('users/unblock-account', {
            email: email,
        }, this.basicHeaders());
    };
    /**
     * Unblocks account with token
     *
     * @param {string} token - The token received via email to verify and unblock the account.
     * @returns {Promise<void>} - Resolves successfuly when account is unblocked
     */
    Auth.prototype.unblockAccount = function (token) {
        return this.client.put('users/unblock-account', { token: token }, this.basicHeaders());
    };
    /**
     * Runs the first phase (out of 2) of opaque log for the given user
     * @param email - The user email.
     * @param startLoginRequest - The opaque start login request.
     * @param tfa - The two factor auth code.
     * @returns The opaque login response.
     */
    Auth.prototype.loginOpaqueStart = function (email, startLoginRequest) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.post('/auth/login-opaque/start', {
                        email: email,
                        startLoginRequest: startLoginRequest,
                    }, this.basicHeaders())];
            });
        });
    };
    /**
     * Runs the second phase (out of 2) of opaque log for the given user
     * @param email
     * @param finishLoginRequest
     */
    Auth.prototype.loginOpaqueFinish = function (email, finishLoginRequest, tfa) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.post('/auth/login-opaque/finish', {
                        email: email,
                        finishLoginRequest: finishLoginRequest,
                        tfa: tfa,
                    }, this.basicHeaders())];
            });
        });
    };
    /**
     * Tries to log in a user given its login details
     * @param details
     * @param cryptoProvider
     */
    Auth.prototype.login = function (details, cryptoProvider) {
        return __awaiter(this, void 0, void 0, function () {
            var securityDetails, encryptedSalt, encryptedPasswordHash, keys;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.securityDetails(details.email)];
                    case 1:
                        securityDetails = _a.sent();
                        encryptedSalt = securityDetails.encryptedSalt;
                        encryptedPasswordHash = cryptoProvider.encryptPasswordHash(details.password, encryptedSalt);
                        return [4 /*yield*/, cryptoProvider.generateKeys(details.password)];
                    case 2:
                        keys = _a.sent();
                        return [2 /*return*/, this.client
                                .post('/auth/login/access', {
                                email: details.email,
                                password: encryptedPasswordHash,
                                tfa: details.tfaCode,
                                /**
                                / @deprecated The individual fields for keys should not be used
                                */
                                privateKey: keys.privateKeyEncrypted,
                                publicKey: keys.publicKey,
                                revocateKey: keys.revocationCertificate,
                                keys: {
                                    ecc: {
                                        publicKey: keys.ecc.publicKey,
                                        privateKey: keys.ecc.privateKeyEncrypted,
                                    },
                                    kyber: {
                                        publicKey: keys.kyber.publicKey,
                                        privateKey: keys.kyber.privateKeyEncrypted,
                                    },
                                },
                            }, this.basicHeaders())
                                .then(function (data) {
                                // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                // @ts-ignore
                                data.user.revocationKey = data.user.revocateKey; // TODO : remove when all projects use SDK
                                return data;
                            })];
                }
            });
        });
    };
    /**
     * Tries to log in a user given its cli login details
     * @param details
     * @param cryptoProvider
     */
    Auth.prototype.loginAccess = function (details, cryptoProvider) {
        return __awaiter(this, void 0, void 0, function () {
            var securityDetails, encryptedSalt, encryptedPasswordHash, keys;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.securityDetails(details.email)];
                    case 1:
                        securityDetails = _a.sent();
                        encryptedSalt = securityDetails.encryptedSalt;
                        encryptedPasswordHash = cryptoProvider.encryptPasswordHash(details.password, encryptedSalt);
                        return [4 /*yield*/, cryptoProvider.generateKeys(details.password)];
                    case 2:
                        keys = _a.sent();
                        return [2 /*return*/, this.client.post('/auth/cli/login/access', {
                                email: details.email,
                                password: encryptedPasswordHash,
                                tfa: details.tfaCode,
                                keys: {
                                    ecc: {
                                        publicKey: keys.ecc.publicKey,
                                        privateKey: keys.ecc.privateKeyEncrypted,
                                    },
                                    kyber: {
                                        publicKey: keys.kyber.publicKey,
                                        privateKey: keys.kyber.privateKeyEncrypted,
                                    },
                                },
                            }, this.basicHeaders())];
                }
            });
        });
    };
    /**
     * Tries to log in a user given its login details without sending keys
     * @param details
     * @param cryptoProvider
     */
    Auth.prototype.loginWithoutKeys = function (details, cryptoProvider) {
        return __awaiter(this, void 0, void 0, function () {
            var securityDetails, encryptedSalt, encryptedPasswordHash;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.securityDetails(details.email)];
                    case 1:
                        securityDetails = _a.sent();
                        encryptedSalt = securityDetails.encryptedSalt;
                        encryptedPasswordHash = cryptoProvider.encryptPasswordHash(details.password, encryptedSalt);
                        return [2 /*return*/, this.client
                                .post('/auth/login/access', {
                                email: details.email,
                                password: encryptedPasswordHash,
                                tfa: details.tfaCode,
                            }, this.basicHeaders())
                                .then(function (data) {
                                // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                // @ts-ignore
                                data.user.revocationKey = data.user.revocateKey; // TODO : remove when all projects use SDK
                                return data;
                            })];
                }
            });
        });
    };
    /**
     * Updates the asymmetric keys
     * @param keys
     * @param token
     */
    Auth.prototype.updateKeys = function (keys, token) {
        return this.client.patch('/user/keys', {
            /**
            / @deprecated The individual fields for keys should not be used
            */
            publicKey: keys.publicKey,
            privateKey: keys.privateKeyEncrypted,
            revocationKey: keys.revocationCertificate,
            ecc: {
                publicKey: keys.ecc.publicKey,
                privateKey: keys.ecc.privateKeyEncrypted,
            },
            kyber: {
                publicKey: keys.kyber.publicKey,
                privateKey: keys.kyber.privateKeyEncrypted,
            },
        }, this.headersWithToken(token));
    };
    /**
     * Returns general security details
     * @param email
     */
    Auth.prototype.securityDetails = function (email) {
        return this.client
            .post('/auth/login', {
            email: email,
        }, this.basicHeaders())
            .then(function (data) {
            return {
                encryptedSalt: data.sKey,
                tfaEnabled: data.tfa === true,
                useOpaqueLogin: data.useOpaqueLogin === true,
            };
        });
    };
    /**
     * Logout
     */
    Auth.prototype.logout = function (token) {
        var _a;
        return this.client.get('/auth/logout', this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * Generates a new TwoFactorAuth code
     */
    Auth.prototype.generateTwoFactorAuthQR = function (token) {
        var _a;
        return this.client
            .get('/auth/tfa', this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token))
            .then(function (data) {
            return {
                qr: data.qr,
                backupKey: data.code,
            };
        });
    };
    /**
     * Disables TwoFactorAuthentication
     * @param pass
     * @param code
     */
    Auth.prototype.disableTwoFactorAuth = function (pass, code, token) {
        var _a;
        return this.client.delete('/auth/tfa', this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token), {
            pass: pass,
            code: code,
        });
    };
    /**
     * Store TwoFactorAuthentication details
     * @param backupKey
     * @param code
     */
    Auth.prototype.storeTwoFactorAuthKey = function (backupKey, code, token) {
        var _a;
        return this.client.put('/auth/tfa', {
            key: backupKey,
            code: code,
        }, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * @deprecated Use `sendUserDeactivationEmail` instead.
     * Sends request to send the email to delete the account
     * @param email
     */
    Auth.prototype.sendDeactivationEmail = function (email) {
        return this.client.get("/deactivate/".concat(email), this.basicHeaders());
    };
    /**
     * Sends request to send the email to delete the account
     */
    Auth.prototype.sendUserDeactivationEmail = function (token) {
        var _a;
        return this.client.post('/users/deactivation/send', {}, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * @deprecated Use `confirmUserDeactivation` instead.
     * Confirms the account deactivation
     * @param token
     */
    Auth.prototype.confirmDeactivation = function (token) {
        return this.client.get("/confirmDeactivation/".concat(token), this.basicHeaders());
    };
    /**
     * Confirms the account deactivation
     * @param token
     */
    Auth.prototype.confirmUserDeactivation = function (deactivationToken, token) {
        var _a;
        return this.client.post('/users/deactivation/confirm', {
            token: deactivationToken,
        }, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token));
    };
    /**
     * Check credentials
     * @param hashedPassword
     * @returns
     */
    Auth.prototype.areCredentialsCorrect = function (hashedPassword, token) {
        var _a;
        var url = '/auth/are-credentials-correct';
        return this.client
            .getWithParams(url, { hashedPassword: hashedPassword }, this.headersWithToken(token !== null && token !== void 0 ? token : (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.token))
            .then(function (res) {
            return res;
        })
            .catch(function (error) {
            var _a, _b, _c;
            if (((_a = error.response) === null || _a === void 0 ? void 0 : _a.status) === 401) {
                return false;
            }
            throw new Error("Request failed with status ".concat((_b = error.response) === null || _b === void 0 ? void 0 : _b.status, ": ").concat((_c = error.response) === null || _c === void 0 ? void 0 : _c.data));
        });
    };
    /**
     * Send email to change password
     * @param email
     */
    Auth.prototype.sendChangePasswordEmail = function (email) {
        return this.client.post('/users/recover-account', {
            email: email,
        }, this.basicHeaders());
    };
    /**
     * Restore password with email link
     * @param token
     * @param password
     * @param salt
     * @param mnemonic
     * @param keys
     */
    Auth.prototype.changePasswordWithLink = function (token, password, salt, mnemonic, keys) {
        return this.client.put("/users/recover-account?token=".concat(token, "&reset=false"), {
            password: password,
            salt: salt,
            mnemonic: mnemonic,
            privateKeys: keys,
        }, this.basicHeaders());
    };
    /**
     * Restore password with email link
     * @param token
     * @param password
     * @param salt
     * @param mnemonic
     * @param keys
     */
    Auth.prototype.changePasswordWithLinkV2 = function (token, password, salt, mnemonic, keys) {
        return this.client.put("/users/recover-account-v2?token=".concat(token, "&reset=false"), {
            password: password,
            salt: salt,
            mnemonic: mnemonic,
            privateKeys: keys,
        }, this.basicHeaders());
    };
    Auth.prototype.legacyRecoverAccount = function (_a) {
        var token = _a.token, encryptedPassword = _a.encryptedPassword, encryptedSalt = _a.encryptedSalt, encryptedMnemonic = _a.encryptedMnemonic, eccEncryptedMnemonic = _a.eccEncryptedMnemonic, kyberEncryptedMnemonic = _a.kyberEncryptedMnemonic, keys = _a.keys;
        var accountRecoverPayload = {
            token: token,
            password: encryptedPassword,
            salt: encryptedSalt,
            mnemonic: encryptedMnemonic,
            asymmetricEncryptedMnemonic: {
                ecc: eccEncryptedMnemonic,
                hybrid: kyberEncryptedMnemonic,
            },
            keys: keys,
        };
        return this.client.put('/users/legacy-recover-account', accountRecoverPayload, this.basicHeaders());
    };
    /**
     * Reset account with token
     * @param token
     * @param password
     * @param salt
     * @param mnemonic
     */
    Auth.prototype.resetAccountWithToken = function (token, password, salt, mnemonic) {
        return this.client.put("/users/recover-account?token=".concat(token, "&reset=true"), {
            password: password,
            salt: salt,
            mnemonic: mnemonic,
        }, this.basicHeaders());
    };
    Auth.prototype.basicHeaders = function () {
        return (0, headers_1.basicHeaders)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    Auth.prototype.headersWithToken = function (token) {
        var _a;
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: token,
            workspaceToken: (_a = this.apiSecurity) === null || _a === void 0 ? void 0 : _a.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    return Auth;
}());
exports.Auth = Auth;
