"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = extractMessageFromError;
/**
 * Extracts message from axios error
 *
 * @param err Axios error
 * @returns Extracted error message from axios error
 */
function extractMessageFromError(err) {
    var errMsg;
    var error = err;
    var isServerError = !!error.response;
    var serverUnavailable = !!error.request;
    if (isServerError) {
        errMsg = error.response.data.error;
    }
    else if (serverUnavailable) {
        errMsg = 'Server not available';
    }
    else {
        errMsg = error.message;
    }
    return errMsg;
}
