"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadFile = uploadFile;
exports.uploadMultipartFile = uploadMultipartFile;
var errors_1 = require("./errors");
function uploadFile(network, crypto, bucketId, mnemonic, fileSize, encryptFile, uploadFile) {
    return __awaiter(this, void 0, void 0, function () {
        var index, iv, key, mnemonicIsValid, uploads, _a, url, uuid, hash, finishUploadPayload, finishUploadResponse, err_1, context;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 6, , 7]);
                    mnemonicIsValid = crypto.validateMnemonic(mnemonic);
                    if (!mnemonicIsValid) {
                        throw new errors_1.UploadInvalidMnemonicError();
                    }
                    index = crypto.randomBytes(crypto.algorithm.ivSize);
                    iv = index.slice(0, 16);
                    return [4 /*yield*/, crypto.generateFileKey(mnemonic, bucketId, index)];
                case 1:
                    key = _b.sent();
                    return [4 /*yield*/, network.startUpload(bucketId, {
                            uploads: [
                                {
                                    index: 0,
                                    size: fileSize,
                                },
                            ],
                        })];
                case 2:
                    uploads = (_b.sent()).uploads;
                    _a = uploads[0], url = _a.url, uuid = _a.uuid;
                    if (!url) {
                        throw new errors_1.UrlNotReceivedFromNetworkError();
                    }
                    return [4 /*yield*/, encryptFile(crypto.algorithm.type, key, iv)];
                case 3:
                    _b.sent();
                    return [4 /*yield*/, uploadFile(url)];
                case 4:
                    hash = _b.sent();
                    finishUploadPayload = {
                        index: index.toString('hex'),
                        shards: [{ hash: hash, uuid: uuid }],
                    };
                    return [4 /*yield*/, network.finishUpload(bucketId, finishUploadPayload)];
                case 5:
                    finishUploadResponse = _b.sent();
                    return [2 /*return*/, finishUploadResponse.id];
                case 6:
                    err_1 = _b.sent();
                    context = (0, errors_1.getNetworkErrorContext)({
                        bucketId: bucketId,
                        fileSize: fileSize,
                        user: network.credentials.username,
                        crypto: {
                            mnemonic: mnemonic,
                        },
                    }, err_1);
                    err_1.context = context;
                    throw err_1;
                case 7: return [2 /*return*/];
            }
        });
    });
}
function uploadMultipartFile(network_1, crypto_1, bucketId_1, mnemonic_1, fileSize_1, encryptFile_1, uploadMultiparts_1) {
    return __awaiter(this, arguments, void 0, function (network, crypto, bucketId, mnemonic, fileSize, encryptFile, uploadMultiparts, parts) {
        var mnemonicIsValid, index, iv, key, uploads, _a, urls, uuid, UploadId, _b, hash, uploadedPartsReference, finishUploadPayload, finishUploadResponse;
        if (parts === void 0) { parts = 1; }
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    mnemonicIsValid = crypto.validateMnemonic(mnemonic);
                    if (!mnemonicIsValid) {
                        throw new errors_1.UploadInvalidMnemonicError();
                    }
                    index = crypto.randomBytes(crypto.algorithm.ivSize);
                    iv = index.slice(0, 16);
                    return [4 /*yield*/, crypto.generateFileKey(mnemonic, bucketId, index)];
                case 1:
                    key = _c.sent();
                    return [4 /*yield*/, network.startUpload(bucketId, {
                            uploads: [
                                {
                                    index: 0,
                                    size: fileSize,
                                },
                            ],
                        }, parts)];
                case 2:
                    uploads = (_c.sent()).uploads;
                    _a = uploads[0], urls = _a.urls, uuid = _a.uuid, UploadId = _a.UploadId;
                    if (!urls) {
                        throw new errors_1.UrlsNotReceivedFromNetworkError();
                    }
                    if (!UploadId) {
                        throw new errors_1.UploadIdNotReceivedFromNetworkError();
                    }
                    return [4 /*yield*/, encryptFile(crypto.algorithm.type, key, iv)];
                case 3:
                    _c.sent();
                    return [4 /*yield*/, uploadMultiparts(urls)];
                case 4:
                    _b = _c.sent(), hash = _b.hash, uploadedPartsReference = _b.parts;
                    finishUploadPayload = {
                        index: index.toString('hex'),
                        shards: [{ hash: hash, uuid: uuid, UploadId: UploadId, parts: uploadedPartsReference }],
                    };
                    return [4 /*yield*/, network.finishUpload(bucketId, finishUploadPayload)];
                case 5:
                    finishUploadResponse = _c.sent();
                    return [2 /*return*/, finishUploadResponse.id];
            }
        });
    });
}
