import { ApiSecurity, ApiUrl, AppDetails } from '../../shared';
import { FetchFolderContentResponse, FetchTrashContentResponse } from '../storage/types';
import { AddItemsToTrashPayload, DeleteFilePayload, DeleteItemsPermanentlyByUUIDPayload, DeleteItemsPermanentlyPayload } from './types';
export * as TrashTypes from './types';
export declare class Trash {
    private readonly client;
    private readonly appDetails;
    private readonly apiSecurity;
    static client(apiUrl: ApiUrl, appDetails: AppDetails, apiSecurity: ApiSecurity): Trash;
    private constructor();
    /**
     * Removes a specific folder from the centralized persistence
     * @param folderId
     */
    deleteFolder(folderId: number): Promise<unknown>;
    /**
     * Deletes a specific file entry
     * @param payload
     */
    deleteFile(payload: DeleteFilePayload): Promise<unknown>;
    /**
     * Returns a list of items in trash
     */
    getTrash(): Promise<FetchFolderContentResponse>;
    /**
     * Retrieves a paginated list of trashed files or folders.
     * @param {number} limit - The number of items to retrieve per page.
     * @param {number} [offset=0] - The number of items to skip before beginning to return items.
     * @param {'files' | 'folders'} type - The type of content to retrieve.
     * @param {boolean} root - A boolean indicating whether to retrieve content from the root folder.
     * If is not true it has to get a folderId in order to obtain the items or given folderId
     * @param {number} [folderId] - The ID of the folder to retrieve content from.
     * @returns {Promise<FetchTrashContentResponse>} - A promise that resolves with the paginated list of trashed content.
     */
    getTrashedFilesPaginated(limit: number, offset: number | undefined, type: 'files' | 'folders', root: boolean, folderId?: number): Promise<FetchTrashContentResponse>;
    /**
     * Retrieves a sorted list of trashed files or folders.
     * @param {number} limit - The number of items to retrieve per page.
     * @param {number} [offset=0] - The number of items to skip before beginning to return items.
     * @param {'files' | 'folders'} type - The type of content to retrieve.
     * @param {boolean} root - A boolean indicating whether to retrieve content from the root folder.
     * If is not true it has to get a folderId in order to obtain the items or given folderId
     * @param {'plainName' | 'date'} [sort] - The ID of the folder to retrieve content from.
     * @param {'ASC' | 'DESC'} [order] - The ID of the folder to retrieve content from.
     * @param {number} [folderId] - The ID of the folder to retrieve content from.
     * @returns {Promise<FetchTrashContentResponse>} - A promise that resolves with the paginated list of trashed content.
     */
    getTrashedItemsSorted(limit: number, offset: number | undefined, type: 'files' | 'folders', root: boolean, sort: 'plainName' | 'updatedAt', order: 'ASC' | 'DESC', folderId?: number): Promise<FetchTrashContentResponse>;
    /**
     * Add Items to Trash
     * @param payload
     */
    addItemsToTrash(payload: AddItemsToTrashPayload): Promise<void>;
    /**
     * Removes all items from the trash
     */
    clearTrash(): Promise<void>;
    /**
     * Deletes trashed items permanently
     * @param payload
     */
    deleteItemsPermanently(payload: DeleteItemsPermanentlyPayload): Promise<unknown>;
    /**
     * Deletes trashed items permanently by UUID.
     *
     * @param {DeleteItemsPermanentlyByUUIDPayload} payload - The payload containing the items to be deleted.
     * @return {Promise<void>} A promise that resolves when the items are deleted permanently.
     */
    deleteItemsPermanentlyByUUID(payload: DeleteItemsPermanentlyByUUIDPayload): Promise<unknown>;
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    private headers;
}
