"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Storage = exports.StorageTypes = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
exports.StorageTypes = __importStar(require("./types"));
var Storage = /** @class */ (function () {
    function Storage(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Storage.client = function (apiUrl, appDetails, apiSecurity) {
        return new Storage(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Creates a new folder
     * @param payload
     */
    Storage.prototype.createFolder = function (payload) {
        var _a = this.client.postCancellable('/storage/folder', {
            parentFolderId: payload.parentFolderId,
            folderName: payload.folderName,
        }, this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Creates a new folder
     * @param payload
     */
    Storage.prototype.createFolderByUuid = function (payload) {
        var _a = this.client.postCancellable('/folders', {
            plainName: payload.plainName,
            parentFolderUuid: payload.parentFolderUuid,
        }, this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Moves a specific folder to a new location
     * @param payload
     * @deprecated Use `moveFolderByUuid` instead.
     */
    Storage.prototype.moveFolder = function (payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.post('/storage/move/folder', {
                        folderId: payload.folderId,
                        destination: payload.destinationFolderId,
                    }, this.headers())];
            });
        });
    };
    /**
     * Moves a specific folder to a new location
     * @param payload
     */
    Storage.prototype.moveFolderByUuid = function (uuid, payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.patch("/folders/".concat(uuid), payload, this.headers())];
            });
        });
    };
    /**
     * Updates the metadata of a folder
     * @param payload
     */
    Storage.prototype.updateFolder = function (payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.client.post("/storage/folder/".concat(payload.folderId, "/meta"), {
                            metadata: payload.changes,
                        }, this.headers())];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Updates the name of a folder with the given UUID.
     *
     * @param {Object} payload - The payload containing the folder UUID and the new name.
     * @param {string} payload.folderUuid - The UUID of the folder to update.
     * @param {string} payload.name - The new name for the folder.
     * @param {Token} [resourcesToken] - An optional token for authentication.
     * @return {Promise<void>} A promise that resolves when the folder name is successfully updated.
     */
    Storage.prototype.updateFolderNameWithUUID = function (payload, resourcesToken) {
        var folderUuid = payload.folderUuid, name = payload.name;
        return this.client.put("/folders/".concat(folderUuid, "/meta"), {
            plainName: name,
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Fetches & returns the contents of a specific folder
     * @param folderId
     */
    Storage.prototype.getFolderContent = function (folderId, trash) {
        if (trash === void 0) { trash = false; }
        var query = trash ? '/?trash=true' : '';
        var _a = this.client.getCancellable("/storage/v2/folder/".concat(folderId).concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Fetches and returns the contents of a specific folder by its UUID.
     *
     * @param {string} folderUuid - The UUID of the folder.
     * @param {boolean} [trash=false] - Whether to include trash items in the response.
     * @param {boolean} [offset] - The position of the first file to return.
     * @param {boolean} [limit] - The max number of files to be returned.
     * @param {boolean} [workspacesToken] - Token for accessing workspaces.
     * @return {[Promise<FetchFolderContentResponse>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getFolderContentByUuid = function (_a) {
        var folderUuid = _a.folderUuid, _b = _a.trash, trash = _b === void 0 ? false : _b, offset = _a.offset, limit = _a.limit, workspacesToken = _a.workspacesToken;
        var query = new URLSearchParams();
        if (offset !== undefined)
            query.set('offset', String(offset));
        if (limit !== undefined)
            query.set('limit', String(limit));
        if (trash)
            query.set('trash', 'true');
        var customHeaders = workspacesToken
            ? {
                'x-internxt-workspace': workspacesToken,
            }
            : undefined;
        var _c = this.client.getCancellable("/folders/content/".concat(folderUuid, "?").concat(query), this.headers(customHeaders)), promise = _c.promise, requestCanceler = _c.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Retrieves a file with the specified fileId along with the associated workspacesToken.
     *
     * @param {string} fileId - The ID of the file to retrieve.
     * @param {string} [workspacesToken] - Token for accessing workspaces.
     * @return {[Promise<FileMeta>, RequestCanceler]} A promise with FileMeta and a canceler for the request.
     */
    Storage.prototype.getFile = function (fileId, workspacesToken) {
        var customHeaders = workspacesToken
            ? {
                'x-internxt-workspace': workspacesToken,
            }
            : undefined;
        var _a = this.client.getCancellable("/files/".concat(fileId, "/meta"), this.headers(customHeaders)), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Gets the files in a folder.
     *
     * @param {number} folderId - The ID of the folder.
     * @param {number} [offset=0] - The position of the first file to return.
     * @param {number} [limit=50] - The max number of files to be returned.
     * @param {string} [sort=plainName] - The reference column to sort it.
     * @param {string} [order=ASC] - The order to be followed.
     * @returns {[Promise<FetchPaginatedFolderContentResponse>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getFolderFiles = function (folderId, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("folders/".concat(folderId, "/files/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Gets the files in a folder by its UUID.
     *
     * @param {UUID} folderUuid - The UUID of the folder.
     * @param {number} [offset=0] - The position of the first file to return.
     * @param {number} [limit=50] - The max number of files to be returned.
     * @param {string} [sort=plainName] - The reference column to sort it.
     * @param {string} [order=ASC] - The order to be followed.
     * @returns {[Promise<FetchPaginatedFilesContent>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getFolderFilesByUuid = function (folderUuid, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("folders/content/".concat(folderUuid, "/files/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Gets the subfolders of a folder.
     *
     * @param {number} folderId - The ID of the folder.
     * @param {number} [offset=0] - The position of the first subfolder to return.
     * @param {number} [limit=50] - The max number of subfolders to return.
     * @param {string} [sort=plainName] - The reference column to sort it.
     * @param {string} [order=ASC] - The order to be followed.
     * @returns {[Promise<FetchPaginatedFolderContentResponse>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getFolderFolders = function (folderId, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("folders/".concat(folderId, "/folders/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Gets the subfolders of a folder by its UUID.
     *
     * @param {UUID} folderUuid - The UUID of the folder.
     * @param {number} [offset=0] - The position of the first subfolder to return.
     * @param {number} [limit=50] - The max number of subfolders to return.
     * @param {string} [sort=plainName] - The reference column to sort it.
     * @param {string} [order=ASC] - The order to be followed.
     * @returns {[Promise<FetchPaginatedFoldersContent>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getFolderFoldersByUuid = function (folderUuid, offset, limit, sort, order) {
        if (offset === void 0) { offset = 0; }
        if (limit === void 0) { limit = 50; }
        if (sort === void 0) { sort = ''; }
        if (order === void 0) { order = ''; }
        var offsetQuery = "?offset=".concat(offset);
        var limitQuery = "&limit=".concat(limit);
        var sortQuery = sort !== '' ? "&sort=".concat(sort) : '';
        var orderQuery = order !== '' ? "&order=".concat(order) : '';
        var query = "".concat(offsetQuery).concat(limitQuery).concat(sortQuery).concat(orderQuery);
        var _a = this.client.getCancellable("folders/content/".concat(folderUuid, "/folders/").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Removes a specific folder from the centralized persistence
     * @param folderId
     * @deprecated Use `deleteFolderByUuid` instead.
     */
    Storage.prototype.deleteFolder = function (folderId) {
        return this.client.delete("/storage/folder/".concat(folderId), this.headers());
    };
    /**
     * Deletes a folder from the storage system using its unique identifier (UUID).
     *
     * @param folderId - The UUID of the folder to be deleted.
     * @returns A promise that resolves with the response of the delete operation.
     */
    Storage.prototype.deleteFolderByUuid = function (folderId) {
        return this.client.delete("/folders/".concat(folderId), this.headers());
    };
    /**
     * Returns the total size of a folder
     * @param folderId
     */
    Storage.prototype.getFolderSize = function (folderId) {
        return this.client
            .get("/storage/folder/size/".concat(folderId), this.headers())
            .then(function (response) {
            return response.size;
        });
    };
    /**
     * Creates a new file entry
     * @param fileEntry
     * @deprecated Use `createFileEntryByUuid` instead.
     */
    Storage.prototype.createFileEntry = function (fileEntry, resourcesToken) {
        return this.client.post('/storage/file', {
            file: {
                fileId: fileEntry.id,
                type: fileEntry.type,
                bucket: fileEntry.bucket,
                size: fileEntry.size,
                folder_id: fileEntry.folder_id,
                name: fileEntry.name,
                plain_name: fileEntry.plain_name,
                encrypt_version: fileEntry.encrypt_version,
            },
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Creates a new file entry
     * @param fileEntry
     */
    Storage.prototype.createFileEntryByUuid = function (fileEntry, resourcesToken) {
        return this.client.post('/files', fileEntry, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Creates a new thumbnail entry
     * @param thumbnailEntry
     */
    Storage.prototype.createThumbnailEntry = function (thumbnailEntry, resourcesToken) {
        return this.client.post('/storage/thumbnail', {
            thumbnail: thumbnailEntry,
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Creates a new thumbnail entry using drive-server-wip
     * @param CreateThumbnailEntryPayload
     */
    Storage.prototype.createThumbnailEntryWithUUID = function (thumbnailEntry, resourcesToken) {
        return this.client.post('/files/thumbnail', __assign({}, thumbnailEntry), (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Updates the details of a file entry
     * @param payload
     */
    Storage.prototype.updateFile = function (payload, resourcesToken) {
        return this.client.post("/storage/file/".concat(payload.fileId, "/meta"), {
            metadata: payload.metadata,
            bucketId: payload.bucketId,
            relativePath: payload.destinationPath,
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Updates the name of a file with the given UUID.
     *
     * @param {Object} payload - The payload containing the UUID and new name of the file.
     * @param {string} payload.fileUuid - The UUID of the file.
     * @param {string} payload.name - The new name of the file.
     * @param {string} [resourcesToken] - The token for accessing resources.
     * @return {Promise<void>} - A Promise that resolves when the file name is successfully updated.
     */
    Storage.prototype.updateFileNameWithUUID = function (payload, resourcesToken) {
        var fileUuid = payload.fileUuid, name = payload.name;
        return this.client.put("/files/".concat(fileUuid, "/meta"), {
            plainName: name,
        }, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Updates the name and the type from a given file UUID.
     *
     * @param {Object} payload - The payload containing the UUID and the new properties of the file.
     * @param {string} payload.fileUuid - The UUID of the file.
     * @param {string} payload.name - The new name of the file.
     * @param {string} payload.type - The new type of the file.
     * @param {string} [resourcesToken] - The token for accessing resources.
     * @return {Promise<void>} - A Promise that resolves when the file name is successfully updated.
     */
    Storage.prototype.updateFileMetaByUUID = function (fileUuid, payload, resourcesToken) {
        return this.client.put("/files/".concat(fileUuid, "/meta"), payload, (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Deletes a specific file entry
     * @param payload
     * @deprecated Use `deleteFileByUuid` instead.
     */
    Storage.prototype.deleteFile = function (payload) {
        return this.client.delete("/storage/folder/".concat(payload.folderId, "/file/").concat(payload.fileId), this.headers());
    };
    /**
     * Deletes a file from the storage system using its unique identifier (UUID).
     *
     * @param fileId - The UUID of the file to be deleted.
     * @returns A promise that resolves with the response of the delete operation.
     */
    Storage.prototype.deleteFileByUuid = function (fileId) {
        return this.client.delete("/files/".concat(fileId), this.headers());
    };
    /**
     * Updates the persisted path of a file entry
     * @param payload
     * @deprecated Use `moveFileByUuid` instead.
     */
    Storage.prototype.moveFile = function (payload) {
        return this.client.post('/storage/move/file', {
            fileId: payload.fileId,
            destination: payload.destination,
            relativePath: payload.destinationPath,
            bucketId: payload.bucketId,
        }, this.headers());
    };
    /**
     * Moves a specific file to a new location
     * @param payload
     */
    Storage.prototype.moveFileByUuid = function (uuid, payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.patch("/files/".concat(uuid), payload, this.headers())];
            });
        });
    };
    /**
     * Returns a list of the n most recent files
     * @param limit
     * @deprecated use `getRecentFilesV2` call instead.
     */
    Storage.prototype.getRecentFiles = function (limit) {
        return this.client.get("/storage/recents?limit=".concat(limit), this.headers());
    };
    /**
     * Returns a list of the n most recent files
     * @param limit
     */
    Storage.prototype.getRecentFilesV2 = function (limit) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.get("/files/recents?limit=".concat(limit), this.headers())];
            });
        });
    };
    /**
     * Returns a list of items in trash
     */
    Storage.prototype.getTrash = function () {
        var _a = this.client.getCancellable('/storage/trash', this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Add Items to Trash
     * @param payload
     */
    Storage.prototype.addItemsToTrash = function (payload) {
        return this.client.post('/storage/trash/add', {
            items: payload.items,
        }, this.headers());
    };
    /**
     * @returns whether the user has uploaded any files
     */
    Storage.prototype.hasUploadedFiles = function () {
        return this.client.get('/users/me/upload-status', this.headers());
    };
    /**
     * Returns a list of the n most recent files
     * @param limit
     */
    Storage.prototype.searchItemsByName = function (plain_name) {
        return this.client.post('/users/search', { plain_name: plain_name }, this.headers());
    };
    /**
     * Returns the current space usage of the user
     * @deprecated use `spaceUsageV2` call instead.
     */
    Storage.prototype.spaceUsage = function () {
        return this.client.get('/usage', this.headers());
    };
    /**
     * Returns the current space usage of the user
     */
    Storage.prototype.spaceUsageV2 = function () {
        return this.client.get('/users/usage', this.headers());
    };
    /**
     * Returns the current space limit for the user
     * @deprecated use `spaceLimitV2` call instead.
     */
    Storage.prototype.spaceLimit = function () {
        return this.client.get('/limit', this.headers());
    };
    /**
     * Returns the current space limit for the user
     */
    Storage.prototype.spaceLimitV2 = function () {
        return this.client.get('/users/limit', this.headers());
    };
    /**
     * Get global search items.
     *
     * @param {string} search - The name of the item.
     * @param {string} workspaceId - The ID of the workspace (optional).
     * @param {number} offset - The position of the first item to return (optional).
     * @returns {[Promise<SearchResultData>, RequestCanceler]} An array containing a promise to get the API response and a function to cancel the request.
     */
    Storage.prototype.getGlobalSearchItems = function (search, workspaceId, offset) {
        var query = new URLSearchParams();
        if (offset !== undefined)
            query.set('offset', String(offset));
        var _a = workspaceId
            ? this.client.getCancellable("workspaces/".concat(workspaceId, "/fuzzy/").concat(search, "?").concat(query), this.headers())
            : this.client.getCancellable("fuzzy/".concat(search, "?").concat(query), this.headers()), promise = _a.promise, requestCanceler = _a.requestCanceler;
        return [promise, requestCanceler];
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Storage.prototype.headers = function (customHeaders) {
        var customExtraHeaders = {};
        if (customHeaders) {
            customExtraHeaders = customHeaders;
        }
        if (this.appDetails.customHeaders) {
            customExtraHeaders = __assign(__assign({}, customExtraHeaders), this.appDetails.customHeaders);
        }
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: customExtraHeaders,
        });
    };
    /**
     * Gets the ancestors of a given folder UUID
     *
     * @param {string} uuid - UUID of the folder.
     * @returns {Promise<FolderAncestor[]>} A promise that resolves with an array of ancestors of the given folder.
     */
    Storage.prototype.getFolderAncestors = function (uuid) {
        return this.client.get("folders/".concat(uuid, "/ancestors"), this.headers());
    };
    /**
     * Gets the ancestors of an item with the given UUID and type in a Workspace
     *
     * @param {string} workspaceId - UUID of the workspace.
     * @param {string} itemType - itemType to know if the item is file or folder
     * @param {string} uuid - UUID of the item.
     * @returns {Promise<FolderAncestor[]>} A promise that resolves with an array of ancestors of the given folder.
     */
    Storage.prototype.getFolderAncestorsInWorkspace = function (workspaceId, itemType, uuid, resourcesToken) {
        return this.client.get("workspaces/".concat(workspaceId, "/").concat(itemType, "/").concat(uuid, "/ancestors"), (0, headers_1.addResourcesTokenToHeaders)(this.headers(), resourcesToken));
    };
    /**
     * Gets the meta of a given folder UUID
     *
     * @param {string} folderUUID - UUID of the folder.
     * @returns {Promise<FolderMeta>}
     */
    Storage.prototype.getFolderMeta = function (uuid, workspacesToken, resourcesToken) {
        var customHeaders = workspacesToken
            ? {
                'x-internxt-workspace': workspacesToken,
            }
            : undefined;
        return this.client.get("folders/".concat(uuid, "/meta"), (0, headers_1.addResourcesTokenToHeaders)(this.headers(customHeaders), resourcesToken));
    };
    /**
     * Gets the meta of a given folder Id
     *
     * @param {number} folderId - Id of the folder.
     * @returns {Promise<FolderMeta>}
     */
    Storage.prototype.getFolderMetaById = function (folderId) {
        return this.client.get("folders/".concat(folderId, "/metadata"), this.headers());
    };
    /**
     * Replaces a file with a new one.
     *
     * @param {string} uuid - UUID of the file.
     * @param {ReplaceFile} payload
     * @returns {Promise<DriveFileData>} - The replaced file data.
     */
    Storage.prototype.replaceFile = function (uuid, payload) {
        return this.client.put("/files/".concat(uuid), __assign({}, payload), this.headers());
    };
    /**
     * Checks the size limit for a file.
     *
     * @param {number} size - The size of the file to check.
     * @return {Promise<void>} - A promise that resolves when the size limit check is complete.
     */
    Storage.prototype.checkSizeLimit = function (size) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.post('/files/check-size-limit', {
                        file: {
                            size: size,
                        },
                    }, this.headers())];
            });
        });
    };
    /**
     * Retrieves the folder tree based on the UUID.
     *
     * @param {string} uuid - The UUID of the folder.
     * @return {Promise<FolderTreeResponse>} The promise containing the folder tree response.
     */
    Storage.prototype.getFolderTree = function (uuid) {
        return this.client.get("/folders/".concat(uuid, "/tree"), this.headers());
    };
    /**
     * Checks if the given files already exist in the given folder.
     *
     * @param {CheckDuplicatedFilesPayload} payload - Payload containing the folder UUID and the list of files to check.
     * @return {Promise<CheckDuplicatedFilesResponse>} - Promise that contains the duplicated files in a list.
     */
    Storage.prototype.checkDuplicatedFiles = function (_a) {
        var folderUuid = _a.folderUuid, filesList = _a.filesList;
        return this.client.post("/folders/content/".concat(folderUuid, "/files/existence"), {
            files: filesList,
        }, this.headers());
    };
    /**
     * Checks if the given folders names already exist in the given folder
     *
     * @param {CheckDuplicatedFolderPayload} payload - Payload containing the folder UUID and the list of folders to check.
     * @return {Promise<CheckDuplicatedFoldersResponse>} - Promise that contains the duplicated folders in a list.
     */
    Storage.prototype.checkDuplicatedFolders = function (_a) {
        var folderUuid = _a.folderUuid, folderNamesList = _a.folderNamesList;
        return this.client.post("/folders/content/".concat(folderUuid, "/folders/existence"), {
            plainNames: folderNamesList,
        }, this.headers());
    };
    /**
     * Gets the folder meta from a given path (e.g. "/folder1/folder2")
     *
     * @param {string} folderPath - The path of the folder.
     * @returns {Promise<FolderMeta>} A promise that resolves the folder on that path.
     */
    Storage.prototype.getFolderByPath = function (folderPath) {
        return this.client.get("folders/meta?path=".concat(folderPath), this.headers());
    };
    /**
     * Gets the file meta from a given path (e.g. "/folder1/folder2/file.png")
     *
     * @param {string} filePath - The path of the file.
     * @returns {Promise<FileMeta>} A promise that resolves the file on that path.
     */
    Storage.prototype.getFileByPath = function (filePath) {
        return this.client.get("files/meta?path=".concat(filePath), this.headers());
    };
    return Storage;
}());
exports.Storage = Storage;
