"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjectStorage = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
var ObjectStorage = /** @class */ (function () {
    function ObjectStorage(apiUrl, appDetails) {
        this.client = client_1.HttpClient.create(apiUrl);
        this.appDetails = appDetails;
    }
    ObjectStorage.client = function (apiUrl, appDetails) {
        return new ObjectStorage(apiUrl, appDetails);
    };
    ObjectStorage.prototype.getObjectStoragePlanById = function (priceId, currency) {
        var query = new URLSearchParams();
        query.set('planId', priceId);
        if (currency !== undefined) {
            query.set('currency', currency);
        }
        return this.client.get("/object-storage/price?".concat(query.toString()), this.headers());
    };
    ObjectStorage.prototype.getObjectStorageCustomerId = function (_a) {
        var customerName = _a.customerName, email = _a.email, country = _a.country, postalCode = _a.postalCode, companyVatId = _a.companyVatId;
        var query = new URLSearchParams();
        query.set('customerName', customerName);
        query.set('email', email);
        query.set('postalCode', postalCode);
        query.set('country', country);
        if (companyVatId !== undefined) {
            query.set('companyVatId', companyVatId);
        }
        return this.client.get("/object-storage/customer?".concat(query.toString()), this.headers());
    };
    ObjectStorage.prototype.createObjectStorageSubscription = function (_a) {
        var customerId = _a.customerId, priceId = _a.priceId, currency = _a.currency, token = _a.token, promoCodeId = _a.promoCodeId;
        return this.client.post('/object-storage/subscription', {
            customerId: customerId,
            priceId: priceId,
            currency: currency,
            token: token,
            promoCodeId: promoCodeId,
        }, this.headers());
    };
    ObjectStorage.prototype.paymentMethodVerification = function (_a) {
        var customerId = _a.customerId, token = _a.token, _b = _a.currency, currency = _b === void 0 ? 'eur' : _b, priceId = _a.priceId, paymentMethod = _a.paymentMethod;
        return this.client.post('/payment-method-verification', {
            customerId: customerId,
            token: token,
            currency: currency,
            priceId: priceId,
            paymentMethod: paymentMethod,
        }, this.headers());
    };
    ObjectStorage.prototype.headers = function () {
        return (0, headers_1.basicHeaders)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    return ObjectStorage;
}());
exports.ObjectStorage = ObjectStorage;
