import { ApiSecurity, ApiUrl, AppDetails } from '../../shared';
import { Tier } from './types/tiers';
import { AvailableProducts, CreateCheckoutSessionPayload, CreatedSubscriptionData, CreatePaymentSessionPayload, CustomerBillingInfo, DisplayPrice, FreeTrialAvailable, Invoice, InvoicePayload, PaymentMethod, ProductData, RedeemCodePayload, UpdateSubscriptionPaymentMethod, UserSubscription, UserType } from './types/types';
export declare class Payments {
    private readonly client;
    private readonly appDetails;
    private readonly apiSecurity;
    static client(apiUrl: ApiUrl, appDetails: AppDetails, apiSecurity: ApiSecurity): Payments;
    private constructor();
    createCustomer(name: string, email: string, country?: string, companyVatId?: string): Promise<{
        customerId: string;
        token: string;
    }>;
    createSubscription(customerId: string, priceId: string, token: string, quantity: number, currency?: string, promoCodeId?: string): Promise<CreatedSubscriptionData>;
    createPaymentIntent(customerId: string, amount: number, planId: string, token: string, currency?: string, promoCodeName?: string): Promise<{
        clientSecret: string;
        id: string;
        invoiceStatus?: string;
    }>;
    /**
     * Fetches the existing products and its details
     */
    getProducts(): Promise<ProductData[]>;
    /**
     * Creates and returns a new session identifier for the client to go to payment platform
     * @param payload
     */
    createSession(payload: CreatePaymentSessionPayload): Promise<{
        id: string;
    }>;
    getSetupIntent(userType?: UserType): Promise<{
        clientSecret: string;
    }>;
    getDefaultPaymentMethod(userType?: UserType): Promise<PaymentMethod>;
    getInvoices({ subscriptionId, userType, startingAfter, limit, }: InvoicePayload): Promise<Invoice[]>;
    isCouponUsedByUser({ couponCode }: {
        couponCode: string;
    }): Promise<{
        couponUsed: boolean;
    }>;
    getPromoCodesUsedByUser(): Promise<{
        usedCoupons: string[];
    }>;
    getUserSubscription(userType?: UserType): Promise<UserSubscription>;
    getPrices(currency?: string, userType?: UserType): Promise<DisplayPrice[]>;
    requestPreventCancellation(): Promise<FreeTrialAvailable>;
    preventCancellation(): Promise<void>;
    applyRedeemCode(payload: RedeemCodePayload): Promise<void>;
    updateSubscriptionPaymentMethod(payload: UpdateSubscriptionPaymentMethod): Promise<void | Error>;
    updateSubscriptionPrice({ priceId, couponCode, userType, }: {
        priceId: string;
        couponCode?: string;
        userType: UserType;
    }): Promise<{
        userSubscription: UserSubscription;
        request3DSecure: boolean;
        clientSecret: string;
    }>;
    updateWorkspaceMembers(workspaceId: string, subscriptionId: string, updatedSeats: number): Promise<unknown>;
    cancelSubscription(userType?: UserType): Promise<void>;
    createCheckoutSession(payload: CreateCheckoutSessionPayload): Promise<{
        sessionId: string;
    }>;
    updateCustomerBillingInfo(payload: CustomerBillingInfo): Promise<void>;
    /**
     * Gets the available products from the user
     * @returns an object containing available products
     */
    checkUserAvailableProducts(): Promise<AvailableProducts>;
    /**
     * Gets product information based on the user's subscription tier.
     *
     * @param {UserType} [userType] - The type of user for which to query product information.
     *                               If not specified, UserType.Individual will be used by default.
     * @returns {Promise<Tier>} A promise that resolves with the product information
     *                         available for the specified tier.
     *
     * @example
     * // Get products for an individual user tier (default)
     * const individualProducts = await getUserTier();
     *
     * @example
     * // Get products for a business user tier
     * const businessProducts = await getUserTier(UserType.Business);
     */
    getUserTier(userType?: UserType): Promise<Tier>;
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    private headers;
}
