import { ApiSecurity, ApiUrl, AppDetails } from '../../shared';
import { Device, DeviceBackup } from './types';
import { DriveFolderData } from '../storage/types';
export declare class Backups {
    private readonly client;
    private readonly appDetails;
    private readonly apiSecurity;
    static client(apiUrl: ApiUrl, appDetails: AppDetails, apiSecurity: ApiSecurity): Backups;
    private constructor();
    /**
     * @deprecated Use `getBackupDevices` instead.
     * This method uses the old drive backend, while `getBackupDevices` uses the new drive backend.
     */
    getAllDevices(): Promise<Device[]>;
    /**
     * Retrieves the list of backup devices associated with the user's account.
     *
     * @returns {Promise<Device[]>} A promise that resolves to an array of Devices.
     */
    getBackupDevices(): Promise<Device[]>;
    /**
     * Retrieves a list of all devices represented as folders.
     *
     * This method sends a GET request to the `/backup/deviceAsFolder` endpoint
     * and returns an array of `DriveFolderData` objects, each representing a device
     * as a folder in the drive.
     *
     * @returns {Promise<DriveFolderData[]>} A promise that resolves to an array of DriveFolderData.
     */
    getAllDevicesAsFolder(): Promise<DriveFolderData[]>;
    /**
     * Retrieves all backups associated with a specific device identified by its mac ID.
     *
     * @param mac - The mac ID of the device for which backups are to be retrieved.
     * @returns A promise that resolves to an array of DeviceBackups.
     */
    getAllBackups(mac: string): Promise<DeviceBackup[]>;
    /**
     * Deletes a backup by its ID.
     *
     * @param backupId - The unique identifier of the backup to be deleted.
     * @returns A promise that resolves when the backup is successfully deleted.
     */
    deleteBackup(backupId: number): Promise<void>;
    /**
     * @deprecated Use `deleteBackupDevice` instead.
     * This method uses the old drive backend, while `deleteBackupDevice` uses the new drive backend.
     */
    deleteDevice(deviceId: number): Promise<void>;
    /**
     * Deletes a backup device by its ID.
     *
     * @param deviceId - The unique identifier of the device to be deleted.
     * @returns A promise that resolves when the device is successfully deleted.
     */
    deleteBackupDevice(deviceId: number): Promise<void>;
    /**
     * Deletes a backup device by its folder ID.
     *
     * @param folderId - The unique identifier of the folder to be deleted.
     * @returns A promise that resolves when the device is successfully deleted.
     */
    deleteBackupDeviceAsFolder(folderId: string): Promise<void>;
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    private headers;
}
