/**
 * Checks if a rename is needed and returns the new filename.
 * For example, if a file test.txt already exists, the new
 * filename will be test (1).txt.
 *
 * @param items Existing items in a folder
 * @param filename Filename of the new item
 * @param type Type of the new item
 * @returns
 * - Whether it already exists
 * - The number between parethensis. 0 if it already exists.
 * - The new filename. It can be the same as the input
 *   if it doesn't exist already.
 */
export default function renameIfNeeded(items: {
    name: string;
    type?: string;
}[], filename: string, type?: string): [boolean, number, string];
