"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bridge = exports.EmptyBridgeUrlError = void 0;
var lib_1 = require("../lib");
function emptyINXTRequest(config) {
    return new lib_1.INXTRequest(config, lib_1.Methods.Get, '', {}, false);
}
var InxtApi = /** @class */ (function () {
    function InxtApi(config) {
        var _a;
        this.config = config;
        this.url = (_a = config.bridgeUrl) !== null && _a !== void 0 ? _a : '';
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.getBucketById = function (bucketId, params) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.getFileById = function (bucketId, fileId, params) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.createFrame = function (params) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.createEntryFromFrame = function (bucketId, body, params) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.addShardToFrame = function (frameId, body, params) {
        return emptyINXTRequest(this.config);
    };
    InxtApi.prototype.sendUploadExchangeReport = function (exchangeReport) {
        return exchangeReport.sendReport();
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.sendShardToNode = function (shard, shardContent) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.createFileToken = function (bucketId, fileId, operation) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.renameFile = function (bucketId, fileId, newName) {
        return emptyINXTRequest(this.config);
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    InxtApi.prototype.createBucket = function (bucketName) {
        return emptyINXTRequest(this.config);
    };
    return InxtApi;
}());
// tslint:disable-next-line: max-classes-per-file
var EmptyBridgeUrlError = /** @class */ (function (_super) {
    __extends(EmptyBridgeUrlError, _super);
    function EmptyBridgeUrlError() {
        return _super.call(this, 'Empty bridge url') || this;
    }
    return EmptyBridgeUrlError;
}(Error));
exports.EmptyBridgeUrlError = EmptyBridgeUrlError;
// tslint:disable-next-line: max-classes-per-file
var Bridge = /** @class */ (function (_super) {
    __extends(Bridge, _super);
    function Bridge(config) {
        if (config.bridgeUrl === '') {
            throw new EmptyBridgeUrlError();
        }
        return _super.call(this, config) || this;
    }
    Bridge.prototype.getBucketById = function (bucketId, params) {
        var targetUrl = "".concat(this.url, "/buckets/").concat(bucketId);
        var defParams = {
            headers: {
                'Content-Type': 'application/octet-stream',
            },
        };
        var finalParams = __assign(__assign({}, defParams), params);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Get, targetUrl, finalParams, false);
    };
    Bridge.prototype.getFileById = function (bucketId, fileId, params) {
        var targetUrl = "".concat(this.url, "/buckets/").concat(bucketId, "/file-ids/").concat(fileId);
        var defParams = {
            headers: {
                'Content-Type': 'application/octet-stream',
            },
        };
        var finalParams = __assign(__assign({}, defParams), params);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Get, targetUrl, finalParams, false);
    };
    Bridge.prototype.createFrame = function (params) {
        var targetUrl = "".concat(this.url, "/frames");
        var defParams = {
            headers: {
                'Content-Type': 'application/octet-stream',
            },
        };
        var finalParams = __assign(__assign({}, defParams), params);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Post, targetUrl, finalParams, false);
    };
    Bridge.prototype.createEntryFromFrame = function (bucketId, body, params) {
        var targetUrl = "".concat(this.url, "/buckets/").concat(bucketId, "/files");
        var defParams = {
            headers: {
                'Content-Type': 'application/json',
            },
            data: body,
        };
        var finalParams = __assign(__assign({}, defParams), params);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Post, targetUrl, finalParams, false);
    };
    Bridge.prototype.addShardToFrame = function (frameId, body, params) {
        var targetUrl = "".concat(this.url, "/frames/").concat(frameId);
        var defParams = {
            headers: {
                'Content-Type': 'application/json',
            },
            data: __assign(__assign({}, body), { challenges: body.challenges_as_str }),
        };
        var finalParams = __assign(__assign({}, defParams), params);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Put, targetUrl, finalParams, false);
    };
    Bridge.prototype.sendUploadExchangeReport = function (exchangeReport) {
        return exchangeReport.sendReport();
    };
    Bridge.prototype.sendShardToNode = function (shard, shardContent) {
        var targetUrl = "http://".concat(shard.farmer.address, ":").concat(shard.farmer.port, "/shards/").concat(shard.hash, "?token=").concat(shard.token);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Post, targetUrl, { data: shardContent }, true);
    };
    Bridge.prototype.createFileToken = function (bucketId, fileId, operation) {
        var targetUrl = "".concat(this.config.bridgeUrl, "/buckets/").concat(bucketId, "/tokens");
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Post, targetUrl, { data: { operation: operation, file: fileId } }, false);
    };
    Bridge.prototype.renameFile = function (bucketId, fileId, newName) {
        var targetUrl = "".concat(this.config.bridgeUrl, "/buckets/").concat(bucketId, "/files/").concat(fileId);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Patch, targetUrl, { data: { name: newName } });
    };
    Bridge.prototype.createBucket = function (bucketName) {
        var targetUrl = "".concat(this.config.bridgeUrl, "/buckets");
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Post, targetUrl, { data: { name: bucketName } });
    };
    Bridge.prototype.deleteBucket = function (bucketId) {
        var targetUrl = "".concat(this.config.bridgeUrl, "/buckets/").concat(bucketId);
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Delete, targetUrl, {});
    };
    Bridge.prototype.getDownloadLinks = function (bucketId, fileIds) {
        var targetUrl = "".concat(this.config.bridgeUrl, "/buckets/").concat(bucketId, "/bulk-files?fileIds=").concat(fileIds.join(','));
        return new lib_1.INXTRequest(this.config, lib_1.Methods.Get, targetUrl, {});
    };
    return Bridge;
}(InxtApi));
exports.Bridge = Bridge;
