"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebuggerInstance = exports.logger = exports.Logger = void 0;
var Winston = __importStar(require("winston"));
var loggerOptions = {
    levels: {
        warn: 0,
        debug: 1,
        error: 2,
        info: 3,
    },
};
function parseLogLevel(level) {
    var levelNames = Object.keys(loggerOptions.levels);
    var valueIndex = Object.values(loggerOptions.levels).indexOf(level);
    if (valueIndex === -1) {
        return levelNames[levelNames.length - 1];
    }
    return levelNames[valueIndex];
}
var Logger = /** @class */ (function () {
    function Logger() {
    }
    Logger.getInstance = function (logLevel) {
        if (logLevel === void 0) { logLevel = 1; }
        if (!Logger.Instance) {
            Logger.Instance = getLoggerInstance(logLevel);
        }
        return Logger.Instance;
    };
    Logger.getDebugger = function (logLevel, debugCallback) {
        if (logLevel === void 0) { logLevel = 1; }
        if (!Logger.Debugger) {
            Logger.Debugger = (0, exports.getDebuggerInstance)(logLevel, debugCallback);
        }
        return Logger.Debugger;
    };
    return Logger;
}());
exports.Logger = Logger;
var getLoggerInstance = function (level, debug) {
    var _a;
    var levelName = parseLogLevel(level);
    var _logger = Winston.createLogger({
        level: levelName,
        exitOnError: true,
        handleExceptions: true,
        format: Winston.format.combine(Winston.format.colorize({ all: true }), Winston.format.timestamp({ format: 'YYYY-MM-DD HH:mm:ss' }), Winston.format.splat(), Winston.format.printf(function (info) {
            if (debug && debug.enabled) {
                debug.debugCallback(info.message);
            }
            return "".concat(info.timestamp, " ").concat(info.level, ": ").concat(info.message);
        })),
        transports: [new Winston.transports.Console()],
    });
    if (((_a = process === null || process === void 0 ? void 0 : process.env) === null || _a === void 0 ? void 0 : _a.STAGE) !== 'development') {
        _logger.silent = true;
    }
    return _logger;
};
exports.logger = getLoggerInstance(1);
var getDebuggerInstance = function (level, debugCallback) {
    return getLoggerInstance(1, { enabled: true, debugCallback: debugCallback });
};
exports.getDebuggerInstance = getDebuggerInstance;
