"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadOneShardStrategy = void 0;
var crypto_1 = require("crypto");
var strategy_1 = require("./strategy");
var MerkleTree_1 = require("../../utils/MerkleTree");
var api_1 = require("../../../api");
var error_1 = require("../../utils/error");
var streams_1 = require("../../utils/streams");
var __1 = require("../");
var logger_1 = require("../../utils/logger");
/**
 * TODO:
 * - Tests
 */
var UploadOneShardStrategy = /** @class */ (function (_super) {
    __extends(UploadOneShardStrategy, _super);
    function UploadOneShardStrategy(params) {
        var _this = _super.call(this) || this;
        _this.abortables = [];
        _this.aborted = false;
        _this.uploadProgress = 0;
        _this.encryptProgress = 0;
        _this.uploadProgressIntervalId = setTimeout(function () { });
        _this.encryptProgressIntervalId = setTimeout(function () { });
        _this.sourceToHash = params.sourceToHash;
        _this.sourceToUpload = params.sourceToUpload;
        _this.useProxy = params.useProxy;
        _this.once(__1.Events.Upload.Abort, _this.abort.bind(_this));
        return _this;
    }
    UploadOneShardStrategy.prototype.getIv = function () {
        return this.iv;
    };
    UploadOneShardStrategy.prototype.getFileEncryptionKey = function () {
        return this.fileEncryptionKey;
    };
    UploadOneShardStrategy.prototype.setIv = function (iv) {
        if (iv.length === 16) {
            this.iv = iv;
        }
        else {
            throw new Error('Invalid IV length');
        }
    };
    UploadOneShardStrategy.prototype.setFileEncryptionKey = function (fk) {
        if (fk.length === 32) {
            this.fileEncryptionKey = fk;
        }
        else {
            throw new Error('Invalid file encryption length');
        }
    };
    UploadOneShardStrategy.prototype.startNotifyingUploadProgress = function () {
        var _this = this;
        this.uploadProgressIntervalId = setInterval(function () {
            _this.emit(__1.Events.Upload.Progress, _this.uploadProgress);
        }, 5000);
    };
    UploadOneShardStrategy.prototype.stopNotifyingUploadProgress = function () {
        clearInterval(this.uploadProgressIntervalId);
    };
    UploadOneShardStrategy.prototype.startNotifyingEncryptProgress = function () {
        var _this = this;
        this.encryptProgressIntervalId = setInterval(function () {
            _this.emit(__1.Events.Upload.EncryptProgress, _this.encryptProgress);
        }, 5000);
    };
    UploadOneShardStrategy.prototype.stopNotifyingEncryptProgress = function () {
        clearInterval(this.encryptProgressIntervalId);
    };
    UploadOneShardStrategy.prototype.upload = function (negotiateContract) {
        return __awaiter(this, void 0, void 0, function () {
            var hashingStepCipher, hashingStepContent, hashingStepHasher_1, hashingStepProgress, hashingPipeline_1, merkleTree_1, contract_1, uploadStepCipher, uploadStepContent, uploadStepHasher, uploadStepProgressNotifier, uploadPipeline_1, hashCalculatedUploading, hashCalculatedHashing, err_1;
            var _this = this;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (this.fileEncryptionKey.length === 0 || this.iv.length === 0) {
                            throw new Error('Set file encryption key and iv before trying to upload');
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 5, , 6]);
                        this.emit(__1.Events.Upload.EncryptStarted);
                        hashingStepCipher = (0, crypto_1.createCipheriv)('aes-256-ctr', this.fileEncryptionKey, this.iv);
                        hashingStepContent = this.sourceToHash.stream;
                        hashingStepHasher_1 = new streams_1.HashStream();
                        hashingStepProgress = new streams_1.ProgressNotifier(this.sourceToHash.size, 5000);
                        hashingStepProgress.on(streams_1.Events.Progress, function (progress) {
                            _this.encryptProgress = progress;
                        });
                        hashingPipeline_1 = hashingStepContent
                            .pipe(hashingStepCipher)
                            .pipe(hashingStepHasher_1)
                            .pipe(hashingStepProgress);
                        hashingStepCipher.once('error', function (err) { return hashingPipeline_1.emit('error', err); });
                        hashingStepHasher_1.once('error', function (err) { return hashingPipeline_1.emit('error', err); });
                        hashingStepProgress.once('error', function (err) { return hashingPipeline_1.emit('error', err); });
                        this.startNotifyingEncryptProgress();
                        this.addToAbortables(function () { return _this.stopNotifyingEncryptProgress(); });
                        this.addToAbortables(function () { return hashingPipeline_1.destroy(); });
                        merkleTree_1 = (0, MerkleTree_1.generateMerkleTree)();
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                hashingPipeline_1.on('data', function () {
                                    // forces stream to flow
                                }).once('error', function (err) {
                                    reject(err);
                                }).once('end', function () {
                                    _this.shardMeta = {
                                        hash: hashingStepHasher_1.getHash().toString('hex'),
                                        challenges_as_str: merkleTree_1.challenges_as_str,
                                        index: 0,
                                        parity: false,
                                        size: _this.sourceToUpload.size,
                                        tree: merkleTree_1.leaf,
                                    };
                                    resolve(null);
                                });
                            })];
                    case 2:
                        _b.sent();
                        this.stopNotifyingEncryptProgress();
                        this.emit(__1.Events.Upload.EncryptFinished);
                        logger_1.logger.info('Upload/OneShardStrategy/Hashing: File hash encrypted is %s', (_a = this.shardMeta) === null || _a === void 0 ? void 0 : _a.hash);
                        return [4 /*yield*/, negotiateContract(this.shardMeta)];
                    case 3:
                        contract_1 = _b.sent();
                        this.emit(__1.Events.Upload.Started);
                        uploadStepCipher = (0, crypto_1.createCipheriv)('aes-256-ctr', this.fileEncryptionKey, this.iv);
                        uploadStepContent = this.sourceToUpload.stream;
                        uploadStepHasher = new streams_1.HashStream();
                        uploadStepProgressNotifier = new streams_1.ProgressNotifier(this.sourceToUpload.size, 5000);
                        uploadStepProgressNotifier.on(streams_1.Events.Progress, function (progress) {
                            _this.uploadProgress = progress;
                        });
                        uploadPipeline_1 = uploadStepContent
                            .pipe(uploadStepCipher)
                            .pipe(uploadStepHasher)
                            .pipe(uploadStepProgressNotifier);
                        uploadStepContent.once('error', function (err) { return uploadPipeline_1.emit('error', err); });
                        uploadStepCipher.once('error', function (err) { return uploadPipeline_1.emit('error', err); });
                        uploadStepHasher.once('error', function (err) { return uploadPipeline_1.emit('error', err); });
                        uploadStepProgressNotifier.once('error', function (err) { return uploadPipeline_1.emit('error', err); });
                        this.startNotifyingUploadProgress();
                        this.addToAbortables(function () { return uploadPipeline_1.destroy(); });
                        this.addToAbortables(function () { return _this.stopNotifyingUploadProgress(); });
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                api_1.ShardObject.putStreamTwo(contract_1.url, uploadPipeline_1, function (err) {
                                    if (err) {
                                        reject(err);
                                    }
                                    else {
                                        resolve(null);
                                    }
                                }, _this.useProxy);
                            })];
                    case 4:
                        _b.sent();
                        hashCalculatedUploading = uploadStepHasher.getHash().toString('hex');
                        hashCalculatedHashing = hashingStepHasher_1.getHash().toString('hex');
                        logger_1.logger.info('Upload/OneShardStrategy/Uploading: File hash encrypted is %s', hashCalculatedUploading);
                        if (hashCalculatedUploading === hashCalculatedHashing) {
                            logger_1.logger.info('Upload/OneShardStrategy: File uploaded');
                            this.stopNotifyingUploadProgress();
                            this.emit(__1.Events.Upload.Finished, { result: [this.shardMeta] });
                        }
                        else {
                            throw new Error('Hash mismatch: Uploading was ' +
                                hashCalculatedUploading +
                                ' hashing was ' +
                                hashCalculatedHashing);
                        }
                        return [3 /*break*/, 6];
                    case 5:
                        err_1 = _b.sent();
                        this.handleError(err_1);
                        return [3 /*break*/, 6];
                    case 6: return [2 /*return*/];
                }
            });
        });
    };
    UploadOneShardStrategy.prototype.addToAbortables = function (abortFunction) {
        if (this.aborted) {
            abortFunction();
        }
        else {
            this.abortables.push({ abort: abortFunction });
        }
    };
    UploadOneShardStrategy.prototype.handleError = function (err) {
        this.abortables.forEach(function (abortable) { return abortable.abort(); });
        this.emit(__1.Events.Upload.Error, (0, error_1.wrap)('OneShardStrategyError', err));
    };
    UploadOneShardStrategy.prototype.abort = function () {
        this.aborted = true;
        this.emit(__1.Events.Upload.Abort);
        this.abortables.forEach(function (abortable) { return abortable.abort(); });
        this.removeAllListeners();
    };
    return UploadOneShardStrategy;
}(strategy_1.UploadStrategy));
exports.UploadOneShardStrategy = UploadOneShardStrategy;
