import { EventEmitter } from 'events';
import { DownloadDynamicStrategyObject, DownloadOptions } from '.';
import { Abortable, ActionState, Shard } from '../../../api';
export type DownloadStrategyLabel = string;
export type DownloadStrategyObject<T> = DownloadDynamicStrategyObject<T>;
export type DownloadStrategyFunction<T> = (bucketId: string, fileId: string, opts: DownloadOptions, strategyObj: DownloadStrategyObject<T>) => ActionState;
export declare abstract class DownloadStrategy extends EventEmitter implements Abortable {
    fileEncryptionKey: Buffer<ArrayBuffer>;
    iv: Buffer<ArrayBuffer>;
    /**
     * Should return the initialization vector used for file encryption
     */
    getIv(): Buffer;
    /**
     * Should set the required iv to perform an encryption
     * @param iv Initialization vector used in file encryption
     */
    setIv(iv: Buffer): void;
    /**
     * Should return the file encryption key
     */
    getFileEncryptionKey(): Buffer;
    /**
     * Should set the file encryption key
     * @param fk File encryption key used to encrypt a file
     */
    setFileEncryptionKey(fk: Buffer): void;
    /**
     * Should execute the steps to perform an upload
     * @param negotiateContract Injected method to negotiate a contract
     */
    abstract download(mirrors: Shard[]): Promise<void>;
    /**
     * Should abort the upload strategy as soon as possible
     */
    abstract abort(): void;
}
export interface DownloadParams {
}
