"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadOneShardStrategy = void 0;
var crypto_1 = require("crypto");
var __1 = require("..");
var request_1 = require("../../../services/request");
var streams_1 = require("../../utils/streams");
var error_1 = require("../../utils/error");
var strategy_1 = require("./strategy");
var logger_1 = require("../../utils/logger");
var DownloadOneShardStrategy = /** @class */ (function (_super) {
    __extends(DownloadOneShardStrategy, _super);
    function DownloadOneShardStrategy(params) {
        var _this = _super.call(this) || this;
        _this.abortables = [];
        _this.downloadProgress = 0;
        _this.progressIntervalId = setTimeout(function () { });
        _this.aborted = false;
        _this.useProxy = params.useProxy;
        _this.decipher = (0, crypto_1.createDecipheriv)('aes-256-ctr', (0, crypto_1.randomBytes)(32), (0, crypto_1.randomBytes)(16));
        _this.startProgressInterval();
        _this.addAbortable(function () { return _this.stopProgressInterval(); });
        return _this;
    }
    DownloadOneShardStrategy.prototype.startProgressInterval = function () {
        var _this = this;
        this.progressIntervalId = setInterval(function () {
            _this.emit(__1.Events.Download.Progress, _this.downloadProgress);
        }, 5000);
    };
    DownloadOneShardStrategy.prototype.stopProgressInterval = function () {
        clearInterval(this.progressIntervalId);
    };
    DownloadOneShardStrategy.prototype.addAbortable = function (abort) {
        if (this.aborted) {
            return abort();
        }
        this.abortables.push({ abort: abort });
    };
    DownloadOneShardStrategy.prototype.download = function (mirrors) {
        return __awaiter(this, void 0, void 0, function () {
            var onlyMirror, encryptedFileStream_1, hasher_1, progressNotifier_1, err_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (mirrors.length !== 1) {
                            throw new Error('This strategy only supports files with one shard');
                        }
                        onlyMirror = mirrors[0];
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 4, , 5]);
                        if (this.fileEncryptionKey.length === 0 || this.iv.length === 0) {
                            throw new Error('Required decryption data not found');
                        }
                        this.decipher = (0, crypto_1.createDecipheriv)('aes-256-ctr', this.fileEncryptionKey, this.iv);
                        this.emit(__1.Events.Download.Start);
                        return [4 /*yield*/, (0, request_1.getStream)(onlyMirror.url, { useProxy: this.useProxy })];
                    case 2:
                        encryptedFileStream_1 = _a.sent();
                        hasher_1 = new streams_1.HashStream();
                        progressNotifier_1 = new streams_1.ProgressNotifier(onlyMirror.size, 2000);
                        progressNotifier_1.on(streams_1.Events.Progress, function (progress) {
                            _this.downloadProgress = progress;
                        });
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                var downloadPipeline = encryptedFileStream_1
                                    .pipe(progressNotifier_1)
                                    .pipe(hasher_1)
                                    .pipe(_this.decipher);
                                _this.addAbortable(function () { return downloadPipeline.destroy(); });
                                _this.emit(__1.Events.Download.Ready, downloadPipeline);
                                hasher_1.once('end', function () {
                                    _this.emit(__1.Events.Download.Progress, _this.downloadProgress);
                                    _this.stopProgressInterval();
                                    var hashCalculatedDownloading = hasher_1.getHash().toString('hex');
                                    var hashCalculatedUploading = onlyMirror.hash;
                                    logger_1.logger.info('Download/OneShardStrategy/Downloading: File hash encrypted is %s', hashCalculatedDownloading);
                                    logger_1.logger.info('Download/OneShardStrategy/StoredHash:  File hash encrypted is %s', hashCalculatedUploading);
                                    if (hashCalculatedDownloading === hashCalculatedUploading) {
                                        return resolve(null);
                                    }
                                    reject(new Error('Hash mismatch: Uploading was ' +
                                        hashCalculatedUploading +
                                        ' downloading was ' +
                                        hashCalculatedDownloading));
                                });
                            })];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        err_1 = _a.sent();
                        this.handleError(err_1);
                        return [3 /*break*/, 5];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    DownloadOneShardStrategy.prototype.cleanup = function () {
        this.stopProgressInterval();
    };
    DownloadOneShardStrategy.prototype.handleError = function (err) {
        this.cleanup();
        this.abortables.forEach(function (abortable) { return abortable.abort(); });
        this.decipher.emit('error', (0, error_1.wrap)('OneStreamStrategy', err));
    };
    DownloadOneShardStrategy.prototype.abort = function () {
        this.aborted = true;
        this.abortables.forEach(function (abortable) { return abortable.abort(); });
        this.emit(__1.Events.Download.Abort);
    };
    return DownloadOneShardStrategy;
}(strategy_1.DownloadStrategy));
exports.DownloadOneShardStrategy = DownloadOneShardStrategy;
